/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.market;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import net.sf.hibernate.Transaction;
import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.SUnit;
import server.campaign.market.MarketStatistics;

public class MarketStatisticKeeper
implements Serializable {
    Hashtable values = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransfer(int amount, SUnit m) {
        if (CampaignMain.cm.useHibernate()) {
            MarketStatistics stats = this.getStatsOn(m);
            if (stats == null) {
                stats = new MarketStatistics();
                stats.setAuctions(new Integer(1));
                stats.setSum(new Integer(amount));
                stats.setGunnery(new Integer(m.getPilot().getGunnery()));
                stats.setPiloting(new Integer(m.getPilot().getPiloting()));
                stats.setMechFileName(m.getUnitFilename());
                MMServ.mmlog.mainLog("Stats = null");
            } else {
                stats.setSum(new Integer(stats.getSum() + amount));
                stats.setAuctions(new Integer(stats.getAuctions() + 1));
                MMServ.mmlog.mainLog("Stats != null");
            }
            Session session = CampaignMain.cm.getSession();
            try {
                session.saveOrUpdate((Object)stats);
                session.flush();
                session.close();
            }
            catch (Exception e) {
                MMServ.mmlog.mainLog("Error in first try");
                MMServ.mmlog.errLog(e);
            }
            finally {
                try {
                    session.close();
                }
                catch (Exception e) {}
            }
        } else {
            Vector v = this.getVectorForUnit(m);
            v.add(new Integer(amount));
            this.values.put(this.buildIDString(m), v);
        }
    }

    private Vector getVectorForUnit(SUnit m) {
        Vector v = (Vector)this.values.get(this.buildIDString(m));
        if (v == null) {
            v = new Vector();
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MarketStatistics getStatsOn(SUnit m) {
        MarketStatistics stat = null;
        try {
            Session session = CampaignMain.cm.getSession();
            Transaction tx = null;
            try {
                tx = session.beginTransaction();
                Query q = session.createQuery("FROM MarketStatistics where mechFileName=:name AND gunnery=:gunnery AND piloting=:piloting");
                q.setParameter("name", (Object)m.getUnitFilename());
                q.setParameter("piloting", (Object)new Integer(m.getPilot().getPiloting()));
                q.setParameter("gunnery", (Object)new Integer(m.getPilot().getGunnery()));
                if (q.list().size() == 0) {
                    tx.commit();
                    MarketStatistics marketStatistics = null;
                    return marketStatistics;
                }
                stat = (MarketStatistics)q.list().get(0);
                tx.commit();
                session.close();
                return stat;
            }
            catch (Exception e) {
                try {
                    tx.rollback();
                }
                catch (Exception e2) {
                    MMServ.mmlog.errLog(e2);
                }
                MMServ.mmlog.errLog(e);
                return stat;
            }
            finally {
                try {
                    session.close();
                }
                catch (Exception e) {}
            }
        }
        catch (Exception ex) {
            MMServ.mmlog.errLog(ex);
        }
        return stat;
    }

    private double getExactAverageForMech(SUnit m) {
        if (CampaignMain.cm.useHibernate()) {
            MarketStatistics stat = this.getStatsOn(m);
            if (stat == null) {
                return 0.0;
            }
            double result = (double)stat.getSum().longValue() / (double)stat.getAuctions().longValue();
            return result;
        }
        Vector v = this.getVectorForUnit(m);
        if (v.size() == 0) {
            return 0.0;
        }
        int total = 0;
        for (int i = 0; i < v.size(); ++i) {
            total += ((Integer)v.elementAt(i)).intValue();
        }
        return (double)total / (double)v.size();
    }

    public int getAverageForMech(SUnit m) {
        return (int)this.getExactAverageForMech(m);
    }

    private String buildIDString(SUnit m) {
        String res = "";
        res = res + m.getModelName() + "\u00a7" + m.getPilot().getGunnery() + "\u00a7" + m.getPilot().getPiloting();
        return res;
    }
}

