/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.mercenaries;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlanet;
import server.campaign.SPlayer;
import server.campaign.dataFiles.SHouseData;
import server.campaign.mercenaries.ContractInfo;

public class MercHouse
extends SHouse {
    public MercHouse(int id, String name, String HouseColor, int BaseGunner, int BasePilot, String abbreviation, Random rnd) {
        super(id, name, HouseColor, BaseGunner, BasePilot, abbreviation);
        this.getMySHouseData().setHouseType(2);
    }

    public MercHouse(int id) {
        super(id);
        this.getMySHouseData().setHouseType(2);
    }

    public MercHouse() {
        this.getMySHouseData().setHouseType(2);
    }

    public MercHouse(SHouseData data) {
        super(data);
    }

    public int getDistanceTo(SPlanet p, SPlayer player) {
        if (this.getHouseFightingFor(player).isMercHouse()) {
            return 0x7FFFFFFD;
        }
        return this.getHouseFightingFor(player).getDistanceTo(p, player);
    }

    public boolean isMercHouse() {
        return true;
    }

    public SHouse getHouseFightingFor(SPlayer player) {
        ContractInfo playerContract = (ContractInfo)this.getOutstandingContracts().get(player.getName());
        if (playerContract != null) {
            return playerContract.getEmployingHouse();
        }
        return this;
    }

    public void setContract(ContractInfo cToAdd, SPlayer player) {
        this.getOutstandingContracts().put(player.getName(), cToAdd);
        this.setOutstandingContracts(this.getOutstandingContracts());
    }

    public boolean endContract(SPlayer player) {
        boolean terminated = false;
        if (this.getOutstandingContracts().containsKey(player.getName())) {
            this.getOutstandingContracts().remove(player.getName());
            terminated = true;
        }
        return terminated;
    }

    public ContractInfo getContractInfo(SPlayer player) {
        ContractInfo currentContract = null;
        currentContract = (ContractInfo)this.getOutstandingContracts().get(player.getName());
        return currentContract;
    }

    public int getBaysProvided() {
        int mercBays = Integer.parseInt(CampaignMain.cm.getConfig("MercHouseBays"));
        return mercBays;
    }

    public String payWelfare(SPlayer p) {
        String s = "";
        s = p.getMoney() < 30 ? "You're running low on funds. It may be time to secure a loan." : "";
        return s;
    }

    public String toString() {
        ContractInfo ci;
        StringBuffer result = new StringBuffer();
        result.append("[M]");
        result.append(super.toString());
        Enumeration e = this.getOutstandingContracts().elements();
        while (e.hasMoreElements()) {
            ci = (ContractInfo)e.nextElement();
            if (ci.isLegal()) continue;
            this.getOutstandingContracts().remove(ci.getOfferingPlayer().getName());
        }
        result.append(this.getOutstandingContracts().size());
        result.append("|");
        e = this.getOutstandingContracts().elements();
        while (e.hasMoreElements()) {
            ci = (ContractInfo)e.nextElement();
            result.append(ci.toString());
            result.append("|");
        }
        return result.toString();
    }

    public Hashtable getOutstandingContracts() {
        return this.getMySHouseData().getOutstandingContracts();
    }

    public void setOutstandingContracts(Hashtable h) {
        this.getMySHouseData().setOutstandingContracts(h);
    }

    public boolean canConquerPlanets() {
        return false;
    }
}

