/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.operations;

import java.util.TreeMap;
import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.SUnit;

public class OpsScrapThread
extends Thread {
    private String playerName;
    private int maxTotalPayment;
    private int paymentsToDate;
    private long waitTime;
    boolean selectSalvage;
    boolean wasStopped;
    private TreeMap<Integer, Integer> salvagedUnits;

    public OpsScrapThread(String playerName) {
        this.playerName = playerName;
        this.waitTime = new Long(CampaignMain.cm.getConfig("TimeToSelectSalvage"));
        this.maxTotalPayment = 0;
        this.paymentsToDate = 0;
        this.salvagedUnits = new TreeMap();
        this.selectSalvage = Boolean.valueOf(CampaignMain.cm.getConfig("SelectableSalvage"));
    }

    public void addScrappableUnit(int unitID, int scrapValue) {
        this.salvagedUnits.put(unitID, scrapValue);
    }

    public void setMaxPayment(int maxPayment) {
        this.maxTotalPayment = maxPayment;
    }

    public void stopScrap() {
        this.wasStopped = true;
        SPlayer currPlayer = CampaignMain.cm.getPlayer(this.playerName);
        if (currPlayer == null) {
            return;
        }
        for (int currID : this.salvagedUnits.keySet()) {
            SUnit currU = currPlayer.getUnit(currID);
            if (currU == null) continue;
            currU.setScrappableFor(-1);
            if (currPlayer.getActivityStatus() < 2) continue;
            CampaignMain.cm.toUser("You may only scrap units salvaged in your most recent game.", this.playerName, false);
        }
    }

    public int scrapUnit(int unitID) {
        Integer scrapValue = this.salvagedUnits.remove(unitID);
        if (scrapValue == null) {
            return 0;
        }
        int toReturn = scrapValue;
        if (toReturn <= 0) {
            return 0;
        }
        SPlayer p = CampaignMain.cm.getPlayer(this.playerName);
        if (p == null) {
            return 0;
        }
        this.paymentsToDate += scrapValue.intValue();
        int maxScrapValue = this.maxTotalPayment - scrapValue;
        TreeMap<Integer, Integer> toReplace = new TreeMap<Integer, Integer>();
        for (Integer currID : this.salvagedUnits.keySet()) {
            int currScrapValue = this.salvagedUnits.get(currID);
            if (currScrapValue <= maxScrapValue) continue;
            toReplace.put(currID, maxScrapValue);
        }
        this.salvagedUnits.putAll(toReplace);
        for (int currID : toReplace.keySet()) {
            SUnit currU = p.getUnit(currID);
            if (currU == null) continue;
            currU.setScrappableFor(maxScrapValue);
            CampaignMain.cm.toUser("PL|UU|" + currU.getId() + "|" + currU.toString(true), this.playerName, false);
        }
        return scrapValue;
    }

    public synchronized void run() {
        boolean shouldGetText;
        SPlayer currPlayer = CampaignMain.cm.getPlayer(this.playerName);
        if (currPlayer == null) {
            return;
        }
        if (currPlayer.getActivityStatus() < 2) {
            return;
        }
        this.waitTime *= 1000L;
        for (int currID : this.salvagedUnits.keySet()) {
            SUnit currU = currPlayer.getUnit(currID);
            if (this.selectSalvage) {
                int scrapValue = this.salvagedUnits.get(currID);
                currU.setScrappableFor(scrapValue);
            } else {
                currU.setScrappableFor(-1);
            }
            CampaignMain.cm.toUser("PL|UU|" + currU.getId() + "|" + currU.toString(true), this.playerName, false);
        }
        if (!this.selectSalvage) {
            return;
        }
        TreeMap<Integer, Integer> toReplace = new TreeMap<Integer, Integer>();
        for (Integer currID : this.salvagedUnits.keySet()) {
            int currScrapValue = this.salvagedUnits.get(currID);
            if (currScrapValue <= this.maxTotalPayment) continue;
            toReplace.put(currID, this.maxTotalPayment);
        }
        this.salvagedUnits.putAll(toReplace);
        CampaignMain.cm.toUser("You have " + CampaignMain.readableTimeWithSeconds(this.waitTime) + " to scrap salvaged units and recover repair costs.", this.playerName, true);
        try {
            this.wait(this.waitTime);
        }
        catch (Exception ex) {
            MMServ.mmlog.errLog(ex);
        }
        currPlayer = CampaignMain.cm.getPlayer(this.playerName);
        boolean bl = shouldGetText = currPlayer.getActivityStatus() >= 2;
        if (currPlayer == null) {
            return;
        }
        int scrappablesRemaining = 0;
        for (int currID : this.salvagedUnits.keySet()) {
            SUnit currU = currPlayer.getUnit(currID);
            if (currU == null) continue;
            currU.setScrappableFor(-1);
            if (shouldGetText) {
                CampaignMain.cm.toUser("PL|UU|" + currU.getId() + "|" + currU.toString(true), this.playerName, false);
            }
            ++scrappablesRemaining;
        }
        if (scrappablesRemaining > 0 && shouldGetText) {
            CampaignMain.cm.toUser("Time to scrap salvaged units without charge has expired.", this.playerName, true);
        }
    }
}

