/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.operations;

import common.AdvanceTerrain;
import common.PlanetEnvironment;
import common.Unit;
import common.util.AorAn;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeMap;
import server.campaign.AutoArmy;
import server.campaign.CampaignMain;
import server.campaign.SArmy;
import server.campaign.SHouse;
import server.campaign.SPlanet;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.operations.Operation;
import server.campaign.operations.OperationEntity;
import server.campaign.operations.OpsChickenThread;
import server.campaign.pilot.SPilot;
import server.util.MMNetPasswd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortOperation
implements Comparable {
    public static int STATUS_WAITING = 0;
    public static int STATUS_INPROGRESS = 1;
    public static int STATUS_REPORTING = 2;
    public static int STATUS_FINISHED = 4;
    public static int TIME_DAY = 0;
    public static int TIME_DUSK = 1;
    public static int TIME_NIGHT = 2;
    private SPlanet targetWorld;
    private int shortID = -1;
    private int longID = -1;
    private TreeMap<String, Integer> defenders;
    private TreeMap<String, Integer> attackers;
    private TreeMap<String, OpsChickenThread> chickenThreads;
    private TreeMap<Integer, OperationEntity> unitsInProgress;
    private TreeMap<Integer, SPilot> pilotsInProgress;
    private SPlayer initiator;
    private PlanetEnvironment playEnvironment;
    AdvanceTerrain aTerrain = null;
    private int intelTemp = 0;
    private double intelGravity = 0.0;
    private boolean intelVacuum = false;
    private int intelTimeFrame = TIME_DAY;
    private String[] intelTimeFrameString = new String[]{"Day", "Dusk", "Night"};
    private int maxAttackers = 1;
    private int maxDefenders = 1;
    private int minAttackers = 1;
    private int minDefenders = 1;
    private String finishedStringComplete;
    private String finishedStringIncomplete;
    private int currentStatus;
    private int showsToClear;
    private String gameOptions;
    private String attackerAutoString = null;
    private String defenderAutoString = null;
    private String attackArtDesc = "";
    private String defendArtDesc = "";
    private boolean isBuildingOperation = false;
    private String buildingOptions = "";
    private int[] mapEdge = new int[]{2, 6, 4, 8};
    private int[] mapEdgeReverse = new int[]{6, 2, 8, 4};
    private int attackerEdge = -1;
    private int defenderEdge = -1;
    private int totalBuildings = -1;
    private int minBuildings = -1;
    private Dimension mapsize = new Dimension(32, 17);
    private String opName;
    private TreeMap<String, String> playerModifyingOps;

    public ShortOperation(String opName, SPlanet target, SPlayer initiator, SArmy attackingArmy, ArrayList<SArmy> possibleDefenders, int shortID, int longID) {
        this.targetWorld = target;
        this.initiator = initiator;
        this.opName = opName;
        this.shortID = shortID;
        this.longID = longID;
        this.playerModifyingOps = new TreeMap();
        this.chickenThreads = new TreeMap();
        this.attackers = new TreeMap();
        this.defenders = new TreeMap();
        this.playEnvironment = this.targetWorld.getEnvironments().getRandomEnvironment(CampaignMain.cm.getR());
        if (Boolean.valueOf(CampaignMain.cm.getConfig("UseStaticMaps")).booleanValue()) {
            this.aTerrain = (AdvanceTerrain)this.targetWorld.getAdvanceTerrain().get(new Integer(this.playEnvironment.getId()));
        }
        this.addAttacker(initiator, attackingArmy, "");
        this.unitsInProgress = new TreeMap();
        this.pilotsInProgress = new TreeMap();
        this.showsToClear = 3;
        this.currentStatus = STATUS_WAITING;
        this.gameOptions = "GO";
        this.informPossibleDefenders(possibleDefenders);
    }

    public void addAttacker(SPlayer p, SArmy a, String modName) {
        this.attackers.put(p.getName().toLowerCase(), a.getID());
        if (!modName.equals("")) {
            this.playerModifyingOps.put(p.getName().toLowerCase(), modName);
        }
        a.setLocked(true);
        CampaignMain.cm.toUser("PL|SAL|" + a.getID() + "#" + true, p.getName(), false);
    }

    public void removeAttacker(SPlayer p) {
        String pNameLower = p.getName().toLowerCase();
        this.attackers.remove(pNameLower);
        this.playerModifyingOps.remove(pNameLower);
    }

    public void addDefender(SPlayer p, SArmy a, String modName) {
        this.defenders.put(p.getName().toLowerCase(), a.getID());
        if (!modName.equals("")) {
            this.playerModifyingOps.put(p.getName(), modName);
        }
        a.setLocked(true);
        CampaignMain.cm.toUser("PL|SAL|" + a.getID() + "#" + true, p.getName(), false);
        this.changeStatus(STATUS_INPROGRESS);
    }

    public void removeDefender(SPlayer p) {
        String pNameLower = p.getName().toLowerCase();
        this.defenders.remove(pNameLower);
        this.playerModifyingOps.remove(pNameLower);
    }

    public String getName() {
        return this.opName;
    }

    public TreeMap<String, Integer> getAttackers() {
        return this.attackers;
    }

    public TreeMap<String, Integer> getDefenders() {
        return this.defenders;
    }

    public TreeMap<String, OpsChickenThread> getChickenThreads() {
        return this.chickenThreads;
    }

    public int getStatus() {
        return this.currentStatus;
    }

    public int getTotalBuildings() {
        return this.totalBuildings;
    }

    public int getMinBuildings() {
        return this.minBuildings;
    }

    public void changeStatus(int newStatus) {
        if (newStatus == STATUS_INPROGRESS) {
            SUnit u;
            Enumeration<Unit> units;
            SArmy currA;
            int tempToSet;
            int tempdiff;
            int lowTemp;
            int highTemp;
            SPlayer currP;
            Operation o = CampaignMain.cm.getOpsManager().getOperation(this.opName);
            boolean attackerArty = Boolean.valueOf(o.getValue("AttackerReceivesAutoArtillery"));
            boolean defenderArty = Boolean.valueOf(o.getValue("DefenderReceivesAutoArtillery"));
            int totalBV = 0;
            if (attackerArty || defenderArty) {
                SPlayer currPlayer;
                for (String currN : this.defenders.keySet()) {
                    currPlayer = CampaignMain.cm.getPlayer(currN);
                    totalBV += currPlayer.getArmy(this.defenders.get(currN)).getBV();
                }
                for (String currN : this.attackers.keySet()) {
                    currPlayer = CampaignMain.cm.getPlayer(currN);
                    totalBV += currPlayer.getArmy(this.attackers.get(currN)).getBV();
                }
            }
            int attackArtBV = 0;
            if (attackerArty) {
                int flatMod = Integer.parseInt(o.getValue("AttackerFlatArtilleryModifier"));
                double percMod = Double.parseDouble(o.getValue("AttackerPercentArtilleryModifier"));
                int attackArtyMin = Integer.parseInt(o.getValue("MinAttackerArtilleryBV"));
                int attackArtyMax = Integer.parseInt(o.getValue("MaxAttackerArtilleryBV"));
                attackArtBV = (int)((double)totalBV * percMod);
                if ((attackArtBV += flatMod) < attackArtyMin) {
                    attackArtBV = attackArtyMin;
                } else if (attackArtBV > attackArtyMax) {
                    attackArtBV = attackArtyMax;
                }
            }
            int defendArtBV = 0;
            if (defenderArty) {
                int flatMod = Integer.parseInt(o.getValue("DefenderFlatArtilleryModifier"));
                double percMod = Double.parseDouble(o.getValue("DefenderPercentArtilleryModifier"));
                int defendArtyMin = Integer.parseInt(o.getValue("MinDefenderArtilleryBV"));
                int defendArtyMax = Integer.parseInt(o.getValue("MaxDefenderArtilleryBV"));
                defendArtBV = (int)((double)totalBV * percMod);
                if ((defendArtBV += flatMod) < defendArtyMin) {
                    defendArtBV = defendArtyMin;
                } else if (defendArtBV > defendArtyMax) {
                    defendArtBV = defendArtyMax;
                }
            }
            if (attackArtBV > 0) {
                AutoArmy currAutoArmy = new AutoArmy(attackArtBV);
                this.attackerAutoString = "PL|AAA|" + currAutoArmy.toString("|");
                this.attackArtDesc = "[Bonus Arty: " + currAutoArmy.getUnits().size() + " pieces, " + currAutoArmy + "BV]";
                for (String currP2 : this.attackers.keySet()) {
                    CampaignMain.cm.toUser(this.attackerAutoString, currP2, false);
                }
            }
            if (defendArtBV > 0) {
                AutoArmy currAutoArmy = new AutoArmy(defendArtBV);
                this.defenderAutoString = "PL|AAA|" + currAutoArmy.toString("|");
                this.defendArtDesc = "[Bonus Arty: " + currAutoArmy.getUnits().size() + " pieces, " + currAutoArmy + "BV]";
                for (String currP3 : this.defenders.keySet()) {
                    CampaignMain.cm.toUser(this.defenderAutoString, currP3, false);
                }
            }
            this.currentStatus = STATUS_INPROGRESS;
            for (String currN : this.getAllPlayerNames()) {
                SPlayer currP4 = CampaignMain.cm.getPlayer(currN);
                currP4.getMyHouse().setBusy(currP4.getName());
                CampaignMain.cm.sendPlayerStatusUpdate(currP4, true);
                CampaignMain.cm.toUser("TL|" + this.getInfo(true), currN, false);
            }
            this.terminateChickenThreads();
            TreeMap<String, SHouse> houseMap = new TreeMap<String, SHouse>();
            for (String currN : this.getAllPlayerNames()) {
                SPlayer currP5 = CampaignMain.cm.getPlayer(currN);
                SHouse currH = currP5.getMyHouse();
                if (houseMap.get(currH.getName()) != null) continue;
                houseMap.put(currH.getName(), currH);
            }
            for (SHouse currH : houseMap.values()) {
                CampaignMain.cm.doSendHouseMail(currH, "New Game:", this.getInfo(true));
            }
            String firstAttackName = this.attackers.firstKey();
            String firstDefendName = this.defenders.firstKey();
            SPlayer firstAttPlayer = CampaignMain.cm.getPlayer(firstAttackName);
            SPlayer firstDefPlayer = CampaignMain.cm.getPlayer(firstDefendName);
            String attackLogo = "<img height=\"150\" width=\"150\" src =\"" + firstAttPlayer.getHouseFightingFor().getLogo() + "\">";
            String defendLogo = "<img height=\"150\" width=\"150\" src =\"" + firstDefPlayer.getHouseFightingFor().getLogo() + "\">";
            if (MMNetPasswd.getRecord(firstAttackName) != null && MMNetPasswd.getRecord(firstAttackName).getPlayerLogo().length() > 1) {
                attackLogo = "<img height=\"150\" width=\"150\" src =\"" + MMNetPasswd.getRecord(firstAttackName).getPlayerLogo() + "\">";
            }
            if (MMNetPasswd.getRecord(firstDefendName) != null && MMNetPasswd.getRecord(firstDefendName).getPlayerLogo().length() > 1) {
                defendLogo = "<img height=\"150\" width=\"150\" src =\"" + MMNetPasswd.getRecord(firstDefendName).getPlayerLogo() + "\">";
            }
            String logos = attackLogo + " vs " + defendLogo + "<br>";
            double averageAttackELO = 0.0;
            double averageDefendELO = 0.0;
            for (String currN : this.defenders.keySet()) {
                currP = CampaignMain.cm.getPlayer(currN);
                averageDefendELO += currP.getRating();
            }
            for (String currN : this.attackers.keySet()) {
                currP = CampaignMain.cm.getPlayer(currN);
                averageAttackELO += currP.getRating();
            }
            double difference = Math.abs((averageAttackELO /= (double)this.attackers.size()) - (averageDefendELO /= (double)this.defenders.size()));
            String better = "";
            String worse = "";
            if (difference <= 50.0) {
                better = "<b>Intel Report:</b> This appears to be a balanced fight.";
                worse = "<b>Intel Report:</b> This appears to be a balanced fight.";
            } else if (difference <= 100.0) {
                better = "<b>Intel Report:</b> It appears that our forces have slightly more experience than the enemy.";
                worse = "<b>Intel Report:</b> It appears that our forces are slightly less experienced than the enemy.";
            } else if (difference <= 150.0) {
                better = "<b>Intel Report:</b> The opposing force is somewhat inexperienced. The advantage is ours.";
                worse = "<b>Intel Report:</b> The opposing force has seen a fair amount of combat, and will not be easily dispatched.";
            } else if (difference <= 210.0) {
                better = "<b>Intel Report:</b> Our forces are considerably more experienced than the enemy. Victory is likely, but not assured.";
                worse = "<b>Intel Report:</b> The enemy has sent a hardened, veteran force. This will be a difficult battle.";
            } else {
                better = "<b>Intel Report:</b> The opposing force is little more than ragtag militia - be merciful.";
                worse = "<b>Intel Report:</b> The enemy force is elite. Victory will be difficult to achieve, but would bring great honor.";
            }
            String attackIntel = "";
            String defendIntel = "";
            if (averageAttackELO > averageDefendELO) {
                attackIntel = better;
                defendIntel = worse;
            } else {
                attackIntel = worse;
                defendIntel = better;
            }
            if (Integer.parseInt(o.getValue("TotalBuildings")) > 0) {
                this.isBuildingOperation = true;
                attackIntel = attackIntel + "<br><b>Mission Objectives:</b><br>You must destory " + o.getValue("MinBuildingsForOp") + " out of " + o.getValue("TotalBuildings") + " facilities.";
                defendIntel = defendIntel + "<br><b>Mission Objectives:</b><br>You must defend all " + o.getValue("TotalBuildings") + " of your facilities.";
            }
            this.gameOptions = this.gameOptions + "|real_blind_drop|" + Boolean.valueOf(CampaignMain.cm.getConfig("UseBlindDrops"));
            this.gameOptions = this.gameOptions + "|set_arty_player_homeedge|true";
            if (Boolean.valueOf(CampaignMain.cm.getConfig("UseStaticMaps")).booleanValue()) {
                highTemp = this.aTerrain.getHighTemp();
                lowTemp = this.aTerrain.getLowTemp();
                tempdiff = highTemp - lowTemp;
                tempToSet = lowTemp;
                if (tempdiff > 0) {
                    tempToSet = CampaignMain.cm.getR().nextInt(tempdiff) + lowTemp;
                }
                if (CampaignMain.cm.getR().nextInt(100) + 1 <= this.aTerrain.getNightChance() / 2) {
                    this.gameOptions = this.gameOptions + "|night_battle|true";
                    this.gameOptions = this.gameOptions + "|dusk|true";
                    tempToSet -= Math.abs(this.aTerrain.getNightTempMod()) / 2;
                    this.intelTimeFrame = TIME_DUSK;
                } else if (CampaignMain.cm.getR().nextInt(100) + 1 <= this.aTerrain.getNightChance()) {
                    this.gameOptions = this.gameOptions + "|night_battle|true";
                    this.gameOptions = this.gameOptions + "|dusk|false";
                    tempToSet -= Math.abs(this.aTerrain.getNightTempMod());
                    this.intelTimeFrame = TIME_NIGHT;
                } else {
                    this.gameOptions = this.gameOptions + "|night_battle|false";
                    this.gameOptions = this.gameOptions + "|dusk|false";
                    this.intelTimeFrame = TIME_DAY;
                }
                this.gameOptions = this.gameOptions + "|temperature|" + tempToSet;
                this.gameOptions = this.gameOptions + "|gravity|" + this.aTerrain.getGravity();
                this.gameOptions = this.gameOptions + "|vacuum|" + this.aTerrain.isVacuum();
                if (this.aTerrain.isVacuum()) {
                    this.gameOptions = this.gameOptions + "|fire|false";
                }
                this.intelGravity = this.aTerrain.getGravity();
                this.intelTemp = tempToSet;
                this.intelVacuum = this.aTerrain.isVacuum();
            } else {
                highTemp = this.targetWorld.getTemp().height;
                lowTemp = this.targetWorld.getTemp().width;
                tempdiff = highTemp - lowTemp;
                tempToSet = lowTemp;
                if (tempdiff > 0) {
                    tempToSet = CampaignMain.cm.getR().nextInt(tempdiff) + lowTemp;
                }
                this.gameOptions = this.gameOptions + "|temperature|" + tempToSet;
                this.gameOptions = this.gameOptions + "|gravity|" + this.targetWorld.getGravity();
                this.gameOptions = this.gameOptions + "|vacuum|" + this.targetWorld.isVacuum();
                if (this.targetWorld.isVacuum()) {
                    this.gameOptions = this.gameOptions + "|fire|false";
                }
                this.intelGravity = this.targetWorld.getGravity();
                this.intelTemp = tempToSet;
                this.intelVacuum = this.targetWorld.isVacuum();
            }
            this.gameOptions = this.gameOptions + "|inf_proto_move_multi|" + CampaignMain.cm.getConfig("InfProtoClusterCount");
            int totalWeight = 0;
            for (String currN : this.defenders.keySet()) {
                SPlayer currP6 = CampaignMain.cm.getPlayer(currN);
                currA = currP6.getArmy(this.defenders.get(currN));
                units = currA.getUnits().elements();
                while (units.hasMoreElements()) {
                    u = (SUnit)units.nextElement();
                    totalWeight += u.getMapSizeModification();
                }
            }
            for (String currN : this.attackers.keySet()) {
                SPlayer currP7 = CampaignMain.cm.getPlayer(currN);
                currA = currP7.getArmy(this.attackers.get(currN));
                units = currA.getUnits().elements();
                while (units.hasMoreElements()) {
                    u = (SUnit)units.nextElement();
                    totalWeight += u.getMapSizeModification();
                }
            }
            if ((totalWeight = (int)Math.sqrt(totalWeight)) < 17) {
                totalWeight = 17;
            }
            this.mapsize = new Dimension(totalWeight + 3, totalWeight - 2);
            for (String currN : this.attackers.keySet()) {
                if (Boolean.valueOf(CampaignMain.cm.getConfig("AllowPreliminaryOperationsReports")).booleanValue()) {
                    SPlayer currP8 = CampaignMain.cm.getPlayer(currN);
                    CampaignMain.cm.toUser(logos + this.planetIntel(attackIntel, currP8.getHouseFightingFor()), currP8.getName(), true);
                } else {
                    CampaignMain.cm.toUser(logos + attackIntel, currN, true);
                }
                CampaignMain.cm.toUser(this.getInfo(true), currN, true);
            }
            for (String currN : this.defenders.keySet()) {
                if (Boolean.valueOf(CampaignMain.cm.getConfig("AllowPreliminaryOperationsReports")).booleanValue()) {
                    SPlayer currP9 = CampaignMain.cm.getPlayer(currN);
                    CampaignMain.cm.toUser(logos + this.planetIntel(defendIntel, currP9.getHouseFightingFor()), currP9.getName(), true);
                } else {
                    CampaignMain.cm.toUser(logos + defendIntel, currN, true);
                }
                CampaignMain.cm.toUser(this.getInfo(true), currN, true);
            }
            if (this.isBuildingOperation) {
                this.totalBuildings = Integer.parseInt(o.getValue("TotalBuildings"));
                this.minBuildings = Integer.parseInt(o.getValue("MinBuildingsForOp"));
                this.buildingOptions = "RBP|" + this.totalBuildings;
                this.buildingOptions = this.buildingOptions + "|" + this.minBuildings;
                this.buildingOptions = this.buildingOptions + "|" + o.getValue("MinFloors");
                this.buildingOptions = this.buildingOptions + "|" + o.getValue("MaxFloors");
                this.buildingOptions = this.buildingOptions + "|" + o.getValue("MinCF");
                this.buildingOptions = this.buildingOptions + "|" + o.getValue("MaxCF");
                this.buildingOptions = this.buildingOptions + "|" + o.getValue("BuildingType");
                if (Boolean.valueOf(o.getValue("BuildingsStartOnMapEdge")).booleanValue()) {
                    int pos = CampaignMain.cm.getR().nextInt(4);
                    this.defenderEdge = this.mapEdge[pos];
                    this.attackerEdge = this.mapEdgeReverse[pos];
                    this.buildingOptions = this.buildingOptions + "|" + this.defenderEdge;
                } else {
                    this.buildingOptions = this.buildingOptions + "|-1";
                }
            }
            for (String currN : this.getAllPlayerNames()) {
                CampaignMain.cm.toUser(this.gameOptions, currN, false);
                if (this.aTerrain != null) {
                    CampaignMain.cm.toUser("APE|" + this.aTerrain.toString() + "|" + this.mapsize.width + "|" + this.mapsize.height, currN, false);
                    CampaignMain.cm.toUser("PE|" + this.playEnvironment.toString() + "|" + this.mapsize.width + "|" + this.mapsize.height, currN, false);
                } else {
                    CampaignMain.cm.toUser("PE|" + this.playEnvironment.toString() + "|" + this.mapsize.width + "|" + this.mapsize.height, currN, false);
                }
                if (this.buildingOptions.length() > 1) {
                    CampaignMain.cm.toUser(this.buildingOptions, currN, false);
                }
                CampaignMain.cm.getPlayer(currN).setSave(true);
            }
            if (this.defenderEdge != -1) {
                for (String currN : this.defenders.keySet()) {
                    String edge = "GMEP|" + this.defenderEdge;
                    CampaignMain.cm.toUser(edge, currN, false);
                }
            }
            if (this.attackerEdge != -1) {
                for (String currN : this.attackers.keySet()) {
                    String edge = "GMEP|" + this.attackerEdge;
                    CampaignMain.cm.toUser(edge, currN, false);
                }
            }
        } else if (newStatus == STATUS_REPORTING) {
            this.currentStatus = newStatus;
        } else if (newStatus == STATUS_FINISHED) {
            this.currentStatus = newStatus;
            CampaignMain.cm.getOpsManager().clearAllDisconnectionTracks(this);
            this.defenders.clear();
            this.attackers.clear();
        }
    }

    public void sendReconnectInfoToPlayer(SPlayer p) {
        String lowerName = p.getName().toLowerCase();
        if (this.currentStatus != STATUS_INPROGRESS) {
            return;
        }
        CampaignMain.cm.toUser(this.gameOptions, lowerName, false);
        if (this.aTerrain != null) {
            CampaignMain.cm.toUser("APE|" + this.aTerrain.toString() + "|" + this.mapsize.width + "|" + this.mapsize.height, lowerName, false);
            CampaignMain.cm.toUser("PE|" + this.playEnvironment.toString() + "|" + this.mapsize.width + "|" + this.mapsize.height, lowerName, false);
        } else {
            CampaignMain.cm.toUser("PE|" + this.playEnvironment.toString() + "|" + this.mapsize.width + "|" + this.mapsize.height, lowerName, false);
        }
        if (this.attackers.containsKey(lowerName)) {
            CampaignMain.cm.toUser(this.attackerAutoString, lowerName, false);
        } else if (this.defenders.containsKey(lowerName)) {
            CampaignMain.cm.toUser(this.defenderAutoString, lowerName, false);
        }
        SHouse h = p.getMyHouse();
        if (h.getFightingMembers().get(lowerName) == null) {
            p.setActiveNoOpplist();
            p.getMyHouse().setBusyNoOppList(p.getName());
        }
        CampaignMain.cm.sendPlayerStatusUpdate(p, true);
    }

    public int getMaxAttackers() {
        return this.maxAttackers;
    }

    public int getMaxDefenders() {
        return this.maxDefenders;
    }

    public int getMinAttackers() {
        return this.minAttackers;
    }

    public int getMinDefedners() {
        return this.minDefenders;
    }

    public SPlanet getTargetWorld() {
        return this.targetWorld;
    }

    public int getShortID() {
        return this.shortID;
    }

    public void setShortID(int newID) {
        this.shortID = newID;
    }

    public int getLongID() {
        return this.longID;
    }

    public void addInProgressUpdate(String s) {
        StringTokenizer tokenizer = new StringTokenizer(s, "*");
        if (s.startsWith("MW*")) {
            tokenizer.nextToken();
            int originalID = Integer.parseInt(tokenizer.nextToken());
            int pickupID = Integer.parseInt(tokenizer.nextToken());
            boolean isDead = Boolean.valueOf(tokenizer.nextToken());
            SPilot mw = SPilot.getMekWarrior(originalID, pickupID);
            mw.setDeath(isDead);
            this.pilotsInProgress.put(originalID, mw);
        } else {
            String ownerName = tokenizer.nextToken();
            int externalID = Integer.parseInt(tokenizer.nextToken());
            int removalCondition = Integer.parseInt(tokenizer.nextToken());
            int ctIS = Integer.parseInt(tokenizer.nextToken());
            int headIS = Integer.parseInt(tokenizer.nextToken());
            boolean repairable = Boolean.valueOf(tokenizer.nextToken());
            OperationEntity oe = new OperationEntity(ownerName, externalID, removalCondition, ctIS, headIS, repairable);
            this.unitsInProgress.put(externalID, oe);
        }
    }

    public TreeMap<Integer, OperationEntity> getUnitsInProgress() {
        return this.unitsInProgress;
    }

    public TreeMap<Integer, SPilot> getPilotsInProgress() {
        return this.pilotsInProgress;
    }

    public void informPossibleDefenders(ArrayList<SArmy> pdlist) {
        for (SArmy currArmy : pdlist) {
            SPlayer currPlayer = CampaignMain.cm.getPlayer(currArmy.getPlayerName());
            String playername = currPlayer.getName().toLowerCase();
            if (this.chickenThreads.containsKey(playername)) {
                OpsChickenThread pThread = this.chickenThreads.get(playername);
                pThread.addArmy(currArmy);
                continue;
            }
            String defenderMess = this.getDefenderMessage();
            OpsChickenThread newThread = new OpsChickenThread(currPlayer, this.shortID, this.opName, defenderMess);
            newThread.addArmy(currArmy);
            this.chickenThreads.put(playername, newThread);
        }
        for (OpsChickenThread ct : this.chickenThreads.values()) {
            ct.start();
        }
    }

    public void removePossibleDefender(String name, boolean penalize) {
        String currName = name.toLowerCase();
        OpsChickenThread currT = this.chickenThreads.get(currName);
        if (currT == null) {
            return;
        }
        if (penalize) {
            currT.doPenalty();
        }
        currT.stopChicken();
        this.chickenThreads.remove(currName);
    }

    public void terminateChickenThreads() {
        for (OpsChickenThread currT : this.chickenThreads.values()) {
            currT.stopChicken();
        }
        this.chickenThreads.clear();
    }

    public String getInfo(boolean complete) {
        if (this.currentStatus == STATUS_WAITING) {
            return this.getWaitingInfo(complete);
        }
        if (this.currentStatus == STATUS_INPROGRESS || this.currentStatus == STATUS_REPORTING) {
            return this.getInProgressInfo(complete);
        }
        if (this.currentStatus == STATUS_FINISHED) {
            return this.getFinishedInfo(complete);
        }
        return "";
    }

    private String getDefenderMessage() {
        String resultString = "";
        int numAttackers = this.attackers.size();
        resultString = resultString + this.getAttackerString(false);
        resultString = numAttackers > 1 ? resultString + " are " : resultString + " is ";
        resultString = resultString + " attacking " + this.targetWorld.getNameAsColoredLink() + "! ";
        if (numAttackers == 1) {
            SArmy attackArm = CampaignMain.cm.getPlayer(this.attackers.firstKey()).getArmy(this.attackers.get(this.attackers.firstKey()));
            resultString = resultString + attackArm.getInaccurateDescription();
        } else if (numAttackers > 1) {
            int totalBV = 0;
            int totalUnits = 0;
            for (String currN : this.attackers.keySet()) {
                SArmy currArmy = CampaignMain.cm.getPlayer(currN).getArmy(this.attackers.get(currN));
                totalBV += currArmy.getOperationsBV(null);
                totalUnits += currArmy.getAmountOfUnits();
            }
            resultString = resultString + "(Total Units: " + totalUnits + " / Total BV: " + totalBV + ")";
        }
        return resultString;
    }

    private String getWaitingInfo(boolean complete) {
        String resultString = "";
        resultString = resultString + "#" + this.getShortID() + " ";
        int numAttackers = this.attackers.size();
        resultString = resultString + this.getAttackerString(complete);
        resultString = numAttackers > 1 ? resultString + " are " : resultString + " is ";
        resultString = resultString + " attacking " + this.targetWorld.getNameAsColoredLink() + "! ";
        if (numAttackers == 1) {
            SArmy attackArm = CampaignMain.cm.getPlayer(this.attackers.firstKey()).getArmy(this.attackers.get(this.attackers.firstKey()));
            resultString = complete ? resultString + attackArm.getInaccurateDescription() : resultString + attackArm.getInaccurateDescription();
        } else if (numAttackers > 1) {
            int totalBV = 0;
            int totalUnits = 0;
            for (String currN : this.attackers.keySet()) {
                SArmy currArmy = CampaignMain.cm.getPlayer(currN).getArmy(this.attackers.get(currN));
                totalBV += currArmy.getOperationsBV(null);
                totalUnits += currArmy.getAmountOfUnits();
            }
            resultString = resultString + "(Total Units: " + totalUnits + " / Total BV: " + totalBV + ")";
        }
        return resultString;
    }

    private String getInProgressInfo(boolean complete) {
        SArmy currArmy;
        int totalUnits;
        String resultString = "";
        String multiPlayerString = "";
        boolean blindDrop = Boolean.valueOf(CampaignMain.cm.getConfig("UseBlindDrops"));
        resultString = resultString + "#" + this.getShortID() + " ";
        int numAttackers = this.attackers.size();
        int numDefenders = this.defenders.size();
        resultString = resultString + this.getAttackerString(complete);
        resultString = numAttackers > 1 ? resultString + " are " : resultString + " is ";
        resultString = resultString + " attempting " + AorAn.check(this.opName, true) + " " + this.opName;
        resultString = resultString + " on " + this.targetWorld.getNameAsColoredLink();
        if (numAttackers == 1 && numDefenders < 2) {
            SArmy attackArm = CampaignMain.cm.getPlayer(this.attackers.firstKey()).getArmy(this.attackers.get(this.attackers.firstKey()));
            resultString = complete && !blindDrop ? resultString + " with " + attackArm.getDescription(true) : resultString + attackArm.getInaccurateDescription();
        } else if (numAttackers > 1 || numDefenders > 1) {
            int totalBV = 0;
            totalUnits = 0;
            for (String currN : this.attackers.keySet()) {
                currArmy = CampaignMain.cm.getPlayer(currN).getArmy(this.attackers.get(currN));
                totalBV += currArmy.getOperationsBV(null);
                totalUnits += currArmy.getAmountOfUnits();
            }
            multiPlayerString = multiPlayerString + " - Total Attacker Units: " + totalUnits + " / BV: " + totalBV + "<br>";
        }
        resultString = resultString + ". " + this.getDefenderString(complete);
        resultString = numDefenders > 1 ? resultString + " are " : resultString + " is ";
        resultString = resultString + "defending ";
        if (numDefenders == 1 && numAttackers < 2) {
            SArmy defendArm = CampaignMain.cm.getPlayer(this.defenders.firstKey()).getArmy(this.defenders.get(this.defenders.firstKey()));
            resultString = complete && !blindDrop ? resultString + " with " + defendArm.getDescription(true) : resultString + defendArm.getInaccurateDescription();
        } else if (numDefenders > 1 || numDefenders > 1) {
            int totalBV = 0;
            totalUnits = 0;
            for (String currN : this.defenders.keySet()) {
                currArmy = CampaignMain.cm.getPlayer(currN).getArmy(this.defenders.get(currN));
                totalBV += currArmy.getOperationsBV(null);
                totalUnits += currArmy.getAmountOfUnits();
            }
            multiPlayerString = multiPlayerString + " - Total Defender Units: " + totalUnits + " / BV: " + totalBV;
        }
        if (!multiPlayerString.equals("")) {
            resultString = resultString + "<br>" + multiPlayerString;
        }
        return resultString;
    }

    private String getFinishedInfo(boolean complete) {
        if (complete) {
            return "#" + this.getShortID() + " " + this.finishedStringComplete;
        }
        return "#" + this.getShortID() + " " + this.finishedStringIncomplete;
    }

    public void setFinishedInfo(boolean complete, String toSet) {
        if (complete) {
            this.finishedStringComplete = toSet;
        } else {
            this.finishedStringIncomplete = toSet;
        }
    }

    private String getAttackerString(boolean complete) {
        int currAttacker = 0;
        int numAttackers = this.attackers.size();
        boolean blindDrop = Boolean.valueOf(CampaignMain.cm.getConfig("UseBlindDrops"));
        String attackString = "";
        if (complete && !blindDrop) {
            Iterator<String> i = this.attackers.keySet().iterator();
            while (i.hasNext()) {
                SPlayer currPlayer = CampaignMain.cm.getPlayer(i.next());
                ++currAttacker;
                attackString = attackString + currPlayer.getColoredName() + "[" + currPlayer.getMyHouse().getColoredAbbreviation() + "]";
                if (numAttackers == 2 && i.hasNext()) {
                    attackString = attackString + " and ";
                    continue;
                }
                if (numAttackers <= 2 || !i.hasNext()) continue;
                if (currAttacker + 1 < numAttackers) {
                    attackString = attackString + ", ";
                    continue;
                }
                if (currAttacker + 1 != numAttackers) continue;
                attackString = attackString + " and ";
            }
        } else {
            String factionLink = this.initiator.getMyHouse().getColoredNameAsLink();
            if (numAttackers == 1) {
                attackString = attackString + factionLink;
            } else if (numAttackers > 1) {
                attackString = attackString + numAttackers + " " + factionLink + " players ";
            }
        }
        return attackString;
    }

    private String getDefenderString(boolean complete) {
        int currDefender = 0;
        int numDefenders = this.defenders.size();
        boolean blindDrop = Boolean.valueOf(CampaignMain.cm.getConfig("UseBlindDrops"));
        String defendString = "";
        if (complete && !blindDrop) {
            Iterator<String> i = this.defenders.keySet().iterator();
            while (i.hasNext()) {
                SPlayer currPlayer = CampaignMain.cm.getPlayer(i.next());
                ++currDefender;
                defendString = defendString + currPlayer.getColoredName() + "[" + currPlayer.getMyHouse().getColoredAbbreviation() + "]";
                if (numDefenders == 2 && i.hasNext()) {
                    defendString = defendString + " and ";
                    continue;
                }
                if (numDefenders <= 2 || !i.hasNext()) continue;
                if (currDefender + 1 < numDefenders) {
                    defendString = defendString + ", ";
                    continue;
                }
                if (currDefender + 1 != numDefenders) continue;
                defendString = defendString + " and ";
            }
        } else {
            String factionLink = CampaignMain.cm.getPlayer(this.defenders.firstKey()).getMyHouse().getColoredNameAsLink();
            if (numDefenders == 1) {
                defendString = defendString + factionLink;
            } else if (numDefenders > 1) {
                defendString = defendString + numDefenders + " " + factionLink + " players ";
            }
        }
        return defendString;
    }

    public boolean hasPlayer(SPlayer p) {
        for (String currN : this.getAllPlayerNames()) {
            if (!currN.equalsIgnoreCase(p.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean hasPlayerFrom(SHouse h) {
        for (String currN : this.getAllPlayerNames()) {
            SPlayer currP = CampaignMain.cm.getPlayer(currN);
            if (!currP.getMyHouse().equals(h)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPlayerWhoseHouseBeginsWith(String s) {
        for (String currN : this.getAllPlayerNames()) {
            SPlayer currP = CampaignMain.cm.getPlayer(currN);
            if (!currP.getMyHouse().getName().toLowerCase().startsWith(s)) continue;
            return true;
        }
        return false;
    }

    public Collection<String> getAllPlayerNames() {
        TreeMap<String, Integer> c = new TreeMap<String, Integer>();
        c.putAll(this.attackers);
        c.putAll(this.defenders);
        return c.keySet();
    }

    public TreeMap<String, Integer> getAllPlayersAndArmies() {
        TreeMap<String, Integer> c = new TreeMap<String, Integer>();
        c.putAll(this.attackers);
        c.putAll(this.defenders);
        return c;
    }

    public void decrementShowsToClear() {
        --this.showsToClear;
    }

    public boolean shouldRemoveOnTick() {
        return this.showsToClear <= 0;
    }

    public int compareTo(Object o) {
        if (o instanceof ShortOperation) {
            ShortOperation compOp = (ShortOperation)o;
            if (compOp.getShortID() > this.getShortID()) {
                return 1;
            }
            if (compOp.getShortID() == this.getShortID()) {
                return 0;
            }
            return -1;
        }
        return 0;
    }

    public String planetIntel(String intel, SHouse house) {
        String result = intel;
        int factionOwnerShip = this.getTargetWorld().getInfluence().getInfluence(house.getId());
        int basedOwnerShip = Integer.parseInt(CampaignMain.cm.getConfig("MinChanceForAccurateOperationsReports"));
        int chanceVacuum = CampaignMain.cm.getR().nextInt(100);
        int chanceGravity = CampaignMain.cm.getR().nextInt(100);
        int chanceTemp = CampaignMain.cm.getR().nextInt(100);
        int chanceTime = CampaignMain.cm.getR().nextInt(100);
        if (factionOwnerShip < basedOwnerShip) {
            factionOwnerShip = basedOwnerShip;
        }
        result = result + "<br><B>Planet Name:</b> " + this.getTargetWorld().getName() + "<br>";
        result = Boolean.valueOf(CampaignMain.cm.getConfig("UseStaticMaps")) != false ? result + "<b>Continent:</b> " + this.aTerrain.getDisplayName() + "<br>" : result + "<b>Terrain Type:</b> " + this.playEnvironment.getName() + "<br>";
        if (this.intelVacuum && factionOwnerShip >= chanceVacuum) {
            result = result + "<b>Atmosphere:</b> Missing<br>";
        }
        if (this.intelGravity != 1.0 && factionOwnerShip >= chanceGravity) {
            result = result + "<b>Gravity:</b> " + this.intelGravity + "<br>";
        }
        if ((this.intelTemp > 50 || this.intelTemp < -30) && factionOwnerShip >= chanceTemp) {
            result = result + "<b>Current Temp:</b> " + this.intelTemp + "<br>";
        }
        if (this.intelTimeFrame != TIME_DAY && factionOwnerShip >= chanceTime) {
            result = result + "<b>Current Time of Day:</b> " + this.intelTimeFrameString[this.intelTimeFrame] + "<br>";
        }
        return result;
    }
}

