/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.operations;

import common.Unit;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeMap;
import server.campaign.CampaignMain;
import server.campaign.SArmy;
import server.campaign.SPlanet;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.SUnitFactory;
import server.campaign.operations.Operation;
import server.campaign.operations.OperationEntity;
import server.campaign.operations.OpsScrapThread;
import server.campaign.operations.ShortOperation;
import server.campaign.pilot.SPilot;
import server.campaign.util.ELORanking;

public class ShortResolver {
    TreeMap<String, SPlayer> winners;
    TreeMap<String, SPlayer> losers;
    TreeMap<String, SPlayer> allPlayers;
    TreeMap<String, SArmy> allArmies;
    TreeMap<String, String> metaStrings;
    TreeMap<String, String> unitStrings;
    TreeMap<String, String> payStrings;
    TreeMap<String, String> techStrings;
    TreeMap<String, String> longStrings;
    TreeMap<String, Integer> unitCosts;
    TreeMap<String, Integer> beginPay;
    TreeMap<String, Integer> actualPay;
    TreeMap<Integer, OperationEntity> salvagableUnits;
    TreeMap<Integer, OperationEntity> destroyedUnits;
    TreeMap<Integer, OperationEntity> livingUnits;
    TreeMap<Integer, SPilot> pilots;
    TreeMap<String, OpsScrapThread> scrapThreads;
    boolean attackersWon = false;
    boolean defendersWon = false;
    int totalUnits = 0;
    int totalBV = 0;
    int buildingsLeft = -1;
    int buildingsDestroyed = 0;
    String finishedInfoString = "";

    private void resetVariables() {
        this.winners = null;
        this.losers = null;
        this.allPlayers = null;
        this.allArmies = null;
        this.metaStrings = null;
        this.unitStrings = null;
        this.payStrings = null;
        this.longStrings = null;
        this.techStrings = null;
        this.unitCosts = null;
        this.beginPay = null;
        this.actualPay = null;
        this.salvagableUnits = null;
        this.destroyedUnits = null;
        this.livingUnits = null;
        this.pilots = null;
        this.scrapThreads = null;
        this.attackersWon = false;
        this.defendersWon = false;
        this.totalUnits = 0;
        this.totalBV = 0;
        this.buildingsLeft = -1;
        this.buildingsDestroyed = 0;
        this.finishedInfoString = "";
    }

    public void resolveShortAttack(Operation o, ShortOperation so, String report) {
        boolean saveStats;
        if (so.getStatus() != ShortOperation.STATUS_INPROGRESS) {
            return;
        }
        this.resetVariables();
        so.changeStatus(ShortOperation.STATUS_REPORTING);
        StringTokenizer reportTokenizer = new StringTokenizer(report, "#");
        this.winners = new TreeMap();
        this.losers = new TreeMap();
        this.allPlayers = new TreeMap();
        this.allArmies = new TreeMap();
        TreeMap<String, Integer> soIdentifiers = so.getAllPlayersAndArmies();
        for (String currName : soIdentifiers.keySet()) {
            SPlayer currP = CampaignMain.cm.getPlayer(currName);
            SArmy currA = currP.getArmy(soIdentifiers.get(currName));
            this.allPlayers.put(currName, currP);
            this.allArmies.put(currName, currA);
        }
        this.totalUnits = 0;
        this.totalBV = 0;
        for (SArmy currArmy : this.allArmies.values()) {
            this.totalUnits += currArmy.getAmountOfUnits();
            this.totalBV += currArmy.getBV();
        }
        StringTokenizer winnerTokenizer = new StringTokenizer(reportTokenizer.nextToken(), "*");
        while (winnerTokenizer.hasMoreElements()) {
            String nextName = winnerTokenizer.nextToken().toLowerCase();
            if (this.winners.containsKey(nextName)) continue;
            this.winners.put(nextName, this.allPlayers.get(nextName));
        }
        for (String currName : this.allPlayers.keySet()) {
            if (this.winners.containsKey(currName) || this.losers.containsKey(currName)) continue;
            this.losers.put(currName, this.allPlayers.get(currName));
        }
        if (this.winners.size() == 0) {
            for (String pname : this.allPlayers.keySet()) {
                CampaignMain.cm.toUser("Reporting error: Game had no winner.", pname, true);
            }
            CampaignMain.cm.getOpsManager().terminateOperation(so, 3, null);
            return;
        }
        this.possibleSalvageFromReport(reportTokenizer);
        this.assembleDescriptionStrings(o, so);
        this.assembleSalvageStrings(o, so);
        this.assemblePaymentStrings(o, so, null);
        this.assembleTechnicianStrings(o);
        boolean bl = saveStats = Boolean.valueOf(o.getValue("NoStatisticsMode")) == false;
        if (saveStats) {
            for (SArmy currA : this.allArmies.values()) {
                if (this.winners.containsKey(currA.getPlayerName().toLowerCase())) {
                    for (Unit currU : currA.getUnits()) {
                        CampaignMain.cm.addMechStat(currU.getUnitFilename(), currU.getWeightclass(), 1, 1, 0);
                    }
                    continue;
                }
                if (!this.losers.containsKey(currA.getPlayerName().toLowerCase())) continue;
                for (Unit currU : currA.getUnits()) {
                    CampaignMain.cm.addMechStat(currU.getUnitFilename(), currU.getWeightclass(), 1, 0, 0);
                }
            }
        }
        for (SArmy currA : this.allArmies.values()) {
            currA.setLocked(false);
            CampaignMain.cm.toUser("PL|SAL|" + currA.getID() + "#" + false, currA.getPlayerName(), false);
        }
        for (SPlayer currPlayer : this.allPlayers.values()) {
            int immunitySeconds;
            String currName = currPlayer.getName().toLowerCase();
            String toSend = this.metaStrings.get(currName) + this.unitStrings.get(currName) + this.payStrings.get(currName) + this.techStrings.get(currName);
            CampaignMain.cm.toUser(toSend, currName, true);
            if (this.scrapThreads.containsKey(currName)) {
                Integer maxScrapPay;
                if (CampaignMain.cm.getOpsManager().getScrapThreads().containsKey(currName)) {
                    CampaignMain.cm.getOpsManager().getScrapThreads().get(currName).stopScrap();
                }
                if ((maxScrapPay = this.beginPay.get(currName)) == null) {
                    maxScrapPay = new Integer(0);
                }
                this.scrapThreads.get(currName).setMaxPayment(maxScrapPay);
                this.scrapThreads.get(currName).start();
                CampaignMain.cm.getOpsManager().getScrapThreads().put(currName, this.scrapThreads.get(currName));
            }
            if ((immunitySeconds = Integer.parseInt(CampaignMain.cm.getConfig("ImmunityTime"))) > 0) {
                currPlayer.setImmunetill(System.currentTimeMillis() + (long)(immunitySeconds * 1000));
                CampaignMain.cm.toUser("You're immune to attacks for " + immunitySeconds + " seconds. [<a href=\"MEKWARS/c deactivate\">Deactivate</a>]", currName, true);
            }
            for (SArmy currA : currPlayer.getArmies()) {
                currA.setBV(0);
                CampaignMain.cm.toUser("PL|SAD|" + currA.toString(true, "%"), currA.getPlayerName(), false);
                CampaignMain.cm.getOpsManager().checkOperations(currA, true);
            }
            currPlayer.resetWeightedArmyNumber();
            currPlayer.getMyHouse().setUnBusy(currName);
            CampaignMain.cm.sendPlayerStatusUpdate(currPlayer, true);
        }
        so.setFinishedInfo(true, this.finishedInfoString);
        so.setFinishedInfo(false, this.finishedInfoString);
        so.changeStatus(ShortOperation.STATUS_FINISHED);
        CampaignMain.cm.addGamesCompleted(1);
    }

    public void resolveShortAttack(Operation o, ShortOperation so, SPlayer winner, SPlayer loser) {
        this.resetVariables();
        if (so.getStatus() != ShortOperation.STATUS_INPROGRESS) {
            return;
        }
        so.changeStatus(ShortOperation.STATUS_REPORTING);
        this.winners = new TreeMap();
        this.losers = new TreeMap();
        this.winners.put(winner.getName().toLowerCase(), winner);
        this.losers.put(loser.getName().toLowerCase(), loser);
        this.allPlayers = new TreeMap();
        this.allArmies = new TreeMap();
        TreeMap<String, Integer> soIdentifiers = so.getAllPlayersAndArmies();
        for (String currName : soIdentifiers.keySet()) {
            SPlayer currP = CampaignMain.cm.getPlayer(currName);
            SArmy currA = currP.getArmy(soIdentifiers.get(currName));
            this.allPlayers.put(currName, currP);
            this.allArmies.put(currName, currA);
        }
        this.totalUnits = 0;
        this.totalBV = 0;
        for (SArmy currArmy : this.allArmies.values()) {
            this.totalUnits += currArmy.getAmountOfUnits();
            this.totalBV += currArmy.getBV();
        }
        if (this.winners.size() == 0) {
            for (String pname : this.allPlayers.keySet()) {
                CampaignMain.cm.toUser("Reporting error: Game had no winner.", pname, true);
            }
            CampaignMain.cm.getOpsManager().terminateOperation(so, 3, null);
            return;
        }
        this.possibleSalvageFromInProgressInfo(so, loser);
        this.assembleDescriptionStrings(o, so);
        this.assembleSalvageStrings(o, so);
        this.assemblePaymentStrings(o, so, loser);
        this.assembleTechnicianStrings(o);
        for (SArmy currA : this.allArmies.values()) {
            currA.setLocked(false);
            CampaignMain.cm.toUser("PL|SAL|" + currA.getID() + "#" + false, currA.getPlayerName(), false);
        }
        String winName = winner.getName().toLowerCase();
        String toSend = "Time expired. GAME RESOLVED AUTOMATICALLY.<br>" + this.metaStrings.get(winName) + this.unitStrings.get(winName) + this.payStrings.get(winName) + this.techStrings.get(winName);
        CampaignMain.cm.toUser(toSend, winName, true);
        int immunitySeconds = Integer.parseInt(CampaignMain.cm.getConfig("ImmunityTime"));
        if (immunitySeconds > 0) {
            winner.setImmunetill(System.currentTimeMillis() + (long)(immunitySeconds * 1000));
            CampaignMain.cm.toUser("You're immune to attacks for " + immunitySeconds + " seconds. [<a href=\"MEKWARS/c deactivate\">Deactivate</a>]", winName, true);
        }
        for (SArmy currA : winner.getArmies()) {
            CampaignMain.cm.toUser("PL|SAD|" + currA.toString(true, "%"), currA.getPlayerName(), false);
            CampaignMain.cm.getOpsManager().checkOperations(currA, true);
        }
        if (this.scrapThreads.containsKey(winName)) {
            Integer maxScrapPay = this.beginPay.get(winName);
            if (maxScrapPay == null) {
                maxScrapPay = new Integer(0);
            }
            this.scrapThreads.get(winName).setMaxPayment(maxScrapPay);
            this.scrapThreads.get(winName).start();
            if (CampaignMain.cm.getOpsManager().getScrapThreads().containsKey(winName)) {
                CampaignMain.cm.getOpsManager().getScrapThreads().get(winName).stopScrap();
            }
            CampaignMain.cm.getOpsManager().getScrapThreads().put(winName, this.scrapThreads.get(winName));
        }
        winner.resetWeightedArmyNumber();
        winner.getMyHouse().setUnBusy(winName);
        CampaignMain.cm.sendPlayerStatusUpdate(winner, true);
        String loseName = loser.getName().toLowerCase();
        toSend = "You were disconnected too long. GAME RESOLVED AUTOMATICALLY.<br>" + this.metaStrings.get(loseName) + this.unitStrings.get(loseName) + this.payStrings.get(loseName) + this.techStrings.get(loseName);
        CampaignMain.cm.toUser(toSend, loseName, true);
        so.setFinishedInfo(true, this.finishedInfoString);
        so.setFinishedInfo(false, this.finishedInfoString);
        so.changeStatus(ShortOperation.STATUS_FINISHED);
        CampaignMain.cm.addGamesCompleted(1);
    }

    private void assembleTechnicianStrings(Operation o) {
        this.techStrings = new TreeMap();
        boolean gamePaysTechs = Boolean.valueOf(o.getValue("PayTechsForGame"));
        for (String currName : this.allPlayers.keySet()) {
            String toSet = "";
            if (gamePaysTechs) {
                SPlayer currP = CampaignMain.cm.getPlayer(currName);
                toSet = currP.doPayTechnicians(1.0, this.actualPay.get(currName));
            } else {
                toSet = "No tech payments made for this game.";
            }
            this.techStrings.put(currName, toSet);
        }
    }

    private void assemblePaymentStrings(Operation o, ShortOperation so, SPlayer disconnector) {
        int defenderTotalBVXPAdjustment;
        int attackerTotalBVXPAdjustment;
        int defenderTotalBVFluAdjustment;
        int attackerTotalBVFluAdjustment;
        int defenderTotalBVMoneyAdjustment;
        this.payStrings = new TreeMap();
        this.beginPay = new TreeMap();
        this.actualPay = new TreeMap();
        int baseAttackerMoneyPay = Integer.parseInt(o.getValue("BaseAttackerPayCBills"));
        int baseAttackerFluPay = Integer.parseInt(o.getValue("BaseAttackerPayInfluence"));
        int baseDefenderMoneyPay = Integer.parseInt(o.getValue("BaseDefenderPayCBills"));
        int baseDefenderFluPay = Integer.parseInt(o.getValue("BaseDefenderPayInfluence"));
        int baseAttackerExperiencePay = Integer.parseInt(o.getValue("BaseAttackerPayExperience"));
        int baseDefenderExperiencePay = Integer.parseInt(o.getValue("BaseDefenderPayExperience"));
        int baseAttackerRewardPointsPay = Integer.parseInt(o.getValue("RPForAttacker"));
        int baseDefenderRewardPointsPay = Integer.parseInt(o.getValue("RPForDefender"));
        int attackerTotalBVMoneyAdjustment = Integer.parseInt(o.getValue("AttackerPayBVforCBill"));
        if (attackerTotalBVMoneyAdjustment > 0) {
            baseAttackerMoneyPay = (int)((double)baseAttackerMoneyPay + Math.floor(this.totalBV / attackerTotalBVMoneyAdjustment));
        }
        if ((defenderTotalBVMoneyAdjustment = Integer.parseInt(o.getValue("DefenderPayBVforCBill"))) > 0) {
            baseDefenderMoneyPay = (int)((double)baseDefenderMoneyPay + Math.floor(this.totalBV / defenderTotalBVMoneyAdjustment));
        }
        if ((attackerTotalBVFluAdjustment = Integer.parseInt(o.getValue("AttackerPayBVforInfluence"))) > 0) {
            baseAttackerFluPay = (int)((double)baseAttackerFluPay + Math.floor(this.totalBV / attackerTotalBVFluAdjustment));
        }
        if ((defenderTotalBVFluAdjustment = Integer.parseInt(o.getValue("DefenderPayBVforInfluence"))) > 0) {
            baseDefenderFluPay = (int)((double)baseDefenderFluPay + Math.floor(this.totalBV / defenderTotalBVFluAdjustment));
        }
        if ((attackerTotalBVXPAdjustment = Integer.parseInt(o.getValue("AttackerPayBVforExperience"))) > 0) {
            baseAttackerExperiencePay = (int)((double)baseAttackerExperiencePay + Math.floor(this.totalBV / attackerTotalBVXPAdjustment));
        }
        if ((defenderTotalBVXPAdjustment = Integer.parseInt(o.getValue("DefenderPayBVforExperience"))) > 0) {
            baseDefenderExperiencePay = (int)((double)baseDefenderExperiencePay + Math.floor(this.totalBV / defenderTotalBVXPAdjustment));
        }
        if (this.buildingsLeft > -1 && this.buildingsLeft < so.getTotalBuildings()) {
            int defenderBuildingMoneyAdjustment;
            int defenderBuildingRPAdjustment;
            int defenderBuildingFluAdjustment;
            int defenderBuildingXPAdjustment;
            int MinBuildingsIfAttackerWins;
            int totalBuildings = so.getTotalBuildings();
            int minBuildings = so.getMinBuildings();
            this.buildingsDestroyed = totalBuildings - this.buildingsLeft;
            if (this.attackerisWinner(so) && this.buildingsDestroyed < (MinBuildingsIfAttackerWins = Integer.parseInt(o.getValue("AttackerMinBuildingsIfAttackerWins")))) {
                this.buildingsDestroyed = MinBuildingsIfAttackerWins;
            }
            if (this.buildingsDestroyed >= minBuildings) {
                int attackerBuildingMoneyAdjustment;
                int attackerBuildingRPAdjustment;
                int attackerBuildingFluAdjustment;
                int attackerBuildingXPAdjustment = Integer.parseInt(o.getValue("AttackerExpPerBuilding"));
                if (attackerBuildingXPAdjustment > 0) {
                    baseAttackerExperiencePay += attackerBuildingXPAdjustment * this.buildingsDestroyed;
                }
                if ((attackerBuildingFluAdjustment = Integer.parseInt(o.getValue("AttackerFluPerBuilding"))) > 0) {
                    baseAttackerFluPay += attackerBuildingFluAdjustment * this.buildingsDestroyed;
                }
                if ((attackerBuildingRPAdjustment = Integer.parseInt(o.getValue("AttackerRPPerBuilding"))) > 0) {
                    baseAttackerRewardPointsPay += attackerBuildingRPAdjustment * this.buildingsDestroyed;
                }
                if ((attackerBuildingMoneyAdjustment = Integer.parseInt(o.getValue("AttackerMoneyPerBuilding"))) > 0) {
                    baseAttackerMoneyPay += attackerBuildingMoneyAdjustment * this.buildingsDestroyed;
                }
            }
            if ((defenderBuildingXPAdjustment = Integer.parseInt(o.getValue("DefenderExpPerBuilding"))) > 0) {
                baseDefenderExperiencePay += defenderBuildingXPAdjustment * this.buildingsLeft;
            }
            if ((defenderBuildingFluAdjustment = Integer.parseInt(o.getValue("DefenderFluPerBuilding"))) > 0) {
                baseDefenderFluPay += defenderBuildingFluAdjustment * this.buildingsLeft;
            }
            if ((defenderBuildingRPAdjustment = Integer.parseInt(o.getValue("DefenderRPPerBuilding"))) > 0) {
                baseDefenderRewardPointsPay += defenderBuildingRPAdjustment * this.buildingsLeft;
            }
            if ((defenderBuildingMoneyAdjustment = Integer.parseInt(o.getValue("DefenderMoneyPerBuilding"))) > 0) {
                baseDefenderMoneyPay += defenderBuildingMoneyAdjustment * this.buildingsLeft;
            }
        }
        for (String currName : this.allPlayers.keySet()) {
            SPlayer currP = CampaignMain.cm.getPlayer(currName);
            if (disconnector != null && disconnector.getName().toLowerCase().equals(currName)) {
                this.payStrings.put(currName, "You received no pay for this game because you disconnected.");
                this.beginPay.put(currName, 0);
                this.actualPay.put(currName, 0);
                continue;
            }
            int earnedMoney = 0;
            int earnedFlu = 0;
            int earnedXP = 0;
            int earnedRP = 0;
            boolean payAllAsWinners = Boolean.valueOf(o.getValue("PayAllAsWinners"));
            if (payAllAsWinners) {
                this.winners.putAll(this.losers);
                this.losers.clear();
            }
            String buildingReport = "";
            if (so.getAttackers().containsKey(currName)) {
                earnedMoney += baseAttackerMoneyPay;
                earnedFlu += baseAttackerFluPay;
                earnedXP += baseAttackerExperiencePay;
                earnedRP += baseAttackerRewardPointsPay;
                if (this.winners.containsKey(currName)) {
                    earnedRP += Integer.parseInt(o.getValue("RPForWinner"));
                    earnedMoney += Integer.parseInt(o.getValue("AttackerWinModifierCBillsFlat"));
                    earnedFlu += Integer.parseInt(o.getValue("AttackerWinModifierInfluenceFlat"));
                    earnedXP += Integer.parseInt(o.getValue("AttackerWinModifierExperienceFlat"));
                    double moneyMod = 1.0 + Double.parseDouble(o.getValue("AttackerWinModifierCBillsPercent")) / 100.0;
                    double fluMod = 1.0 + Double.parseDouble(o.getValue("AttackerWinModifierInfluencePercent")) / 100.0;
                    double expMod = 1.0 + Double.parseDouble(o.getValue("AttackerWinModifierExperiencePercent")) / 100.0;
                    if (moneyMod > 0.0) {
                        earnedMoney = (int)((double)earnedMoney * moneyMod);
                    }
                    if (fluMod > 0.0) {
                        earnedFlu = (int)((double)earnedFlu * fluMod);
                    }
                    if (expMod > 0.0) {
                        earnedXP = (int)((double)earnedXP * expMod);
                    }
                } else if (this.losers.containsKey(currName)) {
                    earnedRP += Integer.parseInt(o.getValue("RPForLoser"));
                    earnedMoney -= Integer.parseInt(o.getValue("AttackerLossModifierCBillsFlat"));
                    earnedFlu -= Integer.parseInt(o.getValue("AttackerLossModifierInfluenceFlat"));
                    earnedXP -= Integer.parseInt(o.getValue("AttackerLossModifierExperienceFlat"));
                    double moneyMod = 1.0 - Double.parseDouble(o.getValue("AttackerLossModifierCBillsPercent")) / 100.0;
                    double fluMod = 1.0 - Double.parseDouble(o.getValue("AttackerLossModifierInfluencePercent")) / 100.0;
                    double expMod = 1.0 - Double.parseDouble(o.getValue("AttackerLossModifierExperiencePercent")) / 100.0;
                    if (moneyMod > 0.0) {
                        earnedMoney = (int)((double)earnedMoney * moneyMod);
                    }
                    if (fluMod > 0.0) {
                        earnedFlu = (int)((double)earnedFlu * fluMod);
                    }
                    if (expMod > 0.0) {
                        earnedXP = (int)((double)earnedXP * expMod);
                    }
                    if (Boolean.valueOf(o.getValue("OnlyGiveRPtoWinners")).booleanValue()) {
                        earnedRP = 0;
                    }
                }
                if (this.buildingsLeft > -1) {
                    int totalBuildings = so.getTotalBuildings();
                    int minBuildings = so.getMinBuildings();
                    buildingReport = this.buildingsDestroyed == 0 ? "<b>Mission Report: Failed</b><br>You did not manage to destroy a single enemy facility!<br>" : (this.buildingsDestroyed == totalBuildings ? "<b>Mission Report: Success</b><br>You managed to destroy all of the enemies facilities!<br>" : (this.buildingsDestroyed >= minBuildings ? "<b>Mission Report: Success</b><br>You managed to destroy " + this.buildingsDestroyed + " out of " + totalBuildings + " facilities!<br>" : "<b>Mission Report: Failed</b><br>You only managed to destroy " + this.buildingsDestroyed + " out of " + totalBuildings + " facilities!<br>"));
                }
            } else if (so.getDefenders().containsKey(currName)) {
                earnedMoney += baseDefenderMoneyPay;
                earnedFlu += baseDefenderFluPay;
                earnedXP += baseDefenderExperiencePay;
                earnedRP += baseDefenderRewardPointsPay;
                if (this.winners.containsKey(currName)) {
                    earnedRP += Integer.parseInt(o.getValue("RPForWinner"));
                    earnedMoney += Integer.parseInt(o.getValue("DefenderWinModifierCBillsFlat"));
                    earnedFlu += Integer.parseInt(o.getValue("DefenderWinModifierInfluenceFlat"));
                    earnedXP += Integer.parseInt(o.getValue("DefenderWinModifierExperienceFlat"));
                    double moneyMod = 1.0 + Double.parseDouble(o.getValue("DefenderWinModifierCBillsPercent")) / 100.0;
                    double fluMod = 1.0 + Double.parseDouble(o.getValue("DefenderWinModifierInfluencePercent")) / 100.0;
                    double expMod = 1.0 + Double.parseDouble(o.getValue("DefenderWinModifierExperiencePercent")) / 100.0;
                    if (moneyMod > 0.0) {
                        earnedMoney = (int)((double)earnedMoney * moneyMod);
                    }
                    if (fluMod > 0.0) {
                        earnedFlu = (int)((double)earnedFlu * fluMod);
                    }
                    if (expMod > 0.0) {
                        earnedXP = (int)((double)earnedXP * expMod);
                    }
                } else if (this.losers.containsKey(currName)) {
                    earnedRP += Integer.parseInt(o.getValue("RPForLoser"));
                    earnedMoney -= Integer.parseInt(o.getValue("DefenderLossModifierCBillsFlat"));
                    earnedFlu -= Integer.parseInt(o.getValue("DefenderLossModifierInfluenceFlat"));
                    earnedXP -= Integer.parseInt(o.getValue("DefenderLossModifierExperienceFlat"));
                    double moneyMod = 1.0 - Double.parseDouble(o.getValue("DefenderLossModifierCBillsPercent")) / 100.0;
                    double fluMod = 1.0 - Double.parseDouble(o.getValue("DefenderLossModifierInfluencePercent")) / 100.0;
                    double expMod = 1.0 - Double.parseDouble(o.getValue("DefenderLossModifierExperiencePercent")) / 100.0;
                    if (moneyMod > 0.0) {
                        earnedMoney = (int)((double)earnedMoney * moneyMod);
                    }
                    if (fluMod > 0.0) {
                        earnedFlu = (int)((double)earnedFlu * fluMod);
                    }
                    if (expMod > 0.0) {
                        earnedXP = (int)((double)earnedXP * expMod);
                    }
                    if (Boolean.valueOf(o.getValue("OnlyGiveRPtoWinners")).booleanValue()) {
                        earnedRP = 0;
                    }
                }
                if (this.buildingsLeft > -1) {
                    int totalBuildings = so.getTotalBuildings();
                    int minBuildings = so.getMinBuildings();
                    buildingReport = this.buildingsDestroyed == 0 ? "<b>Mission Report: Success</b><br>You to stop the enemy from destroing any facilites!<br>" : (this.buildingsDestroyed == totalBuildings ? "<b>Mission Report: Failed</b><br>You managed to allow the enemy to destroy all our facilites!<br>" : (this.buildingsDestroyed >= minBuildings ? "<b>Mission Report: Failed</b><br>You managed to allow the enemy to destroy " + this.buildingsDestroyed + " out of " + totalBuildings + " facilities!<br>" : "<b>Mission Report: Success</b><br>You managed to keep the enemry from only destroying " + this.buildingsDestroyed + " out of " + totalBuildings + " facilities!<br>"));
                }
            }
            int salvageAndRepairCosts = 0;
            if (this.unitCosts.containsKey(currName)) {
                salvageAndRepairCosts = this.unitCosts.get(currName);
            }
            String toSet = "You've gained ";
            if (buildingReport.length() > 1) {
                toSet = buildingReport + toSet;
            }
            boolean hasGain = false;
            if (earnedMoney < 0) {
                earnedMoney = 0;
            }
            this.beginPay.put(currName, earnedMoney);
            if (earnedMoney > 0 || salvageAndRepairCosts > 0) {
                if ((earnedMoney -= salvageAndRepairCosts) < 0) {
                    earnedMoney = 0;
                }
                this.actualPay.put(currName, earnedMoney);
                toSet = toSet + CampaignMain.cm.moneyOrFluMessage(true, false, earnedMoney);
                if (salvageAndRepairCosts > 0) {
                    toSet = toSet + " (after repair costs)";
                }
                if (earnedMoney > 0) {
                    currP.addMoney(earnedMoney);
                }
                hasGain = true;
            }
            if (earnedFlu > 0) {
                if (hasGain) {
                    toSet = toSet + ", ";
                }
                toSet = toSet + CampaignMain.cm.moneyOrFluMessage(false, false, earnedFlu);
                currP.addInfluence(earnedFlu);
                hasGain = true;
            }
            if (earnedXP > 0) {
                if (hasGain) {
                    toSet = toSet + ", ";
                }
                toSet = toSet + earnedXP + "XP";
                currP.addExperience(earnedXP);
                hasGain = true;
            }
            if (earnedRP > 0) {
                if (hasGain) {
                    toSet = toSet + ", ";
                }
                toSet = toSet + earnedRP + "RP";
                currP.addReward(earnedRP);
                hasGain = true;
            }
            if (hasGain) {
                int lastComma = (toSet = toSet + ".").lastIndexOf(", ");
                if (lastComma >= 0) {
                    String front = toSet.substring(0, lastComma);
                    String back = toSet.substring(lastComma + 2, toSet.length());
                    toSet = front + " and " + back;
                }
                this.payStrings.put(currName, toSet);
                continue;
            }
            this.payStrings.put(currName, "There was no pay (money, experience, etc.) for this game.");
            this.beginPay.put(currName, 0);
            this.actualPay.put(currName, 0);
        }
        boolean opEffectsElo = Boolean.valueOf(o.getValue("CountGameForRanking"));
        if (this.allPlayers.size() == 2 && opEffectsElo) {
            SPlayer wp = this.winners.get(this.winners.firstKey());
            SPlayer lp = this.losers.get(this.losers.firstKey());
            double oldWinnerRating = wp.getRating();
            double oldLoserRating = lp.getRating();
            wp.setRating(ELORanking.getNewRatingWinner(oldWinnerRating, oldLoserRating, 8));
            lp.setRating(ELORanking.getNewRatingLoser(oldWinnerRating, oldLoserRating, 8));
            if (!Boolean.valueOf(CampaignMain.cm.getConfig("HideELO")).booleanValue()) {
                DecimalFormat myFormatter = new DecimalFormat("###.##");
                double winnerRating = wp.getRating() - oldWinnerRating;
                double loserRating = lp.getRating() - oldLoserRating;
                String winRatingStr = myFormatter.format(winnerRating);
                String LoseRatingStr = myFormatter.format(loserRating);
                String winToUser = "Your new Rating is " + wp.getRatingRounded() + " (+" + winRatingStr + ")";
                String loseToUser = "Your new Rating is " + lp.getRatingRounded() + " (" + LoseRatingStr + ")";
                String ls = this.payStrings.get(lp.getName().toLowerCase());
                String ws = this.payStrings.get(wp.getName().toLowerCase());
                this.payStrings.put(lp.getName().toLowerCase(), loseToUser + "<br>" + ls);
                this.payStrings.put(wp.getName().toLowerCase(), winToUser + "<br>" + ws);
            }
        }
    }

    private void assembleSalvageStrings(Operation o, ShortOperation so) {
        String toSet;
        this.unitStrings = new TreeMap();
        this.unitCosts = new TreeMap();
        this.scrapThreads = new TreeMap();
        if (Boolean.valueOf(o.getValue("NoDestructionMode")).booleanValue()) {
            this.livingUnits.putAll(this.salvagableUnits);
            this.livingUnits.putAll(this.destroyedUnits);
            this.salvagableUnits.clear();
            this.destroyedUnits.clear();
            this.pilots.clear();
        }
        int unitXP = Integer.parseInt(o.getValue("BaseUnitXP"));
        int totalUnitsAsjusment = Integer.parseInt(o.getValue("UnitXPUnitsAdjustment"));
        int totalBVAdjustment = Integer.parseInt(o.getValue("UnitXPBVAdjustment"));
        if (totalUnitsAsjusment > 0) {
            unitXP = (int)((double)unitXP + Math.floor(this.totalUnits / totalUnitsAsjusment));
        }
        if (totalBVAdjustment > 0) {
            unitXP = (int)((double)unitXP + Math.floor(this.totalBV / totalBVAdjustment));
        }
        int winnerXP = Integer.parseInt(o.getValue("WinnerBonusUnitXP"));
        int defenderXP = Integer.parseInt(o.getValue("DefenderBonusUnitXP"));
        int flatKillXP = Integer.parseInt(o.getValue("KillBonusUnitXP"));
        for (OperationEntity currEntity : this.livingUnits.values()) {
            boolean countKills;
            String ownerName = currEntity.getOwnerName().toLowerCase();
            SPlayer owner = CampaignMain.cm.getPlayer(ownerName);
            SUnit currU = owner.getUnit(currEntity.getID());
            int totalXPforUnit = unitXP;
            if (this.winners.containsKey(ownerName)) {
                totalXPforUnit += winnerXP;
            }
            if (so.getDefenders().containsKey(ownerName)) {
                totalXPforUnit += defenderXP;
            }
            int realKills = 0;
            boolean bl = countKills = Boolean.valueOf(o.getValue("NoStatisticsMode")) == false;
            if (currEntity.getKills().size() > 0 && countKills) {
                for (Integer id : currEntity.getKills()) {
                    SUnit killedUnit;
                    OperationEntity killed = this.salvagableUnits.get(id);
                    if (killed == null) {
                        killed = this.destroyedUnits.get(id);
                    }
                    if (killed == null || (killedUnit = currEntity.getOwner().getUnit(currEntity.getID())) == null || this.winners.containsKey(ownerName) && this.winners.containsKey(killed.getOwnerName().toLowerCase()) || this.losers.containsKey(ownerName) && this.losers.containsKey(killed.getOwnerName().toLowerCase())) continue;
                    totalXPforUnit += flatKillXP;
                    int bvForBonusXP = Integer.parseInt(o.getValue("KillBonusXPforBV"));
                    if (bvForBonusXP > 0) {
                        totalXPforUnit = (int)((double)totalXPforUnit + Math.floor(killedUnit.getBV() / bvForBonusXP));
                    }
                    ++realKills;
                }
                currU.getPilot().addKill(realKills);
            }
            boolean housePilotGetsXP = Boolean.valueOf(o.getValue("HousePilotsGainXP"));
            boolean solPilotGetsXP = Boolean.valueOf(o.getValue("SOLPilotsGainXP"));
            if (owner.getMyHouse().isNewbieHouse() && !solPilotGetsXP) {
                totalXPforUnit = 0;
            }
            if (!owner.getMyHouse().isNewbieHouse() && !housePilotGetsXP) {
                totalXPforUnit = 0;
            }
            if (totalXPforUnit < 0) {
                totalXPforUnit = 0;
            }
            if (currU.getPilot().getSkills().has(17)) {
                totalXPforUnit = (int)((double)totalXPforUnit * 1.05);
            }
            currU.getPilot().setExperience(currU.getPilot().getExperience() + totalXPforUnit);
            String append = "";
            if (this.winners.containsKey(ownerName)) {
                boolean solPilotCanLevel = Boolean.valueOf(o.getValue("SOLPilotsCheckLevelUp"));
                boolean housePilotCanLevel = Boolean.valueOf(o.getValue("HousePilotsCheckLevelUp"));
                if (owner.getMyHouse().isNewbieHouse() && solPilotCanLevel || !owner.getMyHouse().isNewbieHouse() && housePilotCanLevel) {
                    append = currU.checkForPilotSkillImprovement(owner);
                }
            }
            if (append.equals("")) {
                append = ". " + currU.getPilot().getName() + " gained " + totalXPforUnit + " XP";
            }
            if (realKills == 1) {
                append = append + ". Earned 1 kill";
            } else if (realKills > 1) {
                append = append + ". Earned " + realKills + " kills";
            }
            if (this.unitStrings.containsKey(ownerName)) {
                String s = this.unitStrings.get(ownerName);
                this.unitStrings.put(ownerName, s + "The " + currU.getModelName() + " survived the battle" + append + ".<br>");
            } else {
                this.unitStrings.put(ownerName, "The " + currU.getModelName() + " survived the battle" + append + ".<br>");
            }
            CampaignMain.cm.toUser("PL|UU|" + currU.getId() + "|" + currU.toString(true), ownerName, false);
        }
        boolean winnerAlwaysSalvagesOwn = Boolean.valueOf(o.getValue("WinnerAlwaysSalvagesOwnUnits"));
        int winnerSalvagePercent = 0;
        int salvageAdjustment = 0;
        if (this.attackersWon) {
            winnerSalvagePercent = Integer.parseInt(o.getValue("BaseAttackerSalvagePercent"));
            salvageAdjustment = Integer.parseInt(o.getValue("AttackerSalvageAdjustment"));
        } else {
            winnerSalvagePercent = Integer.parseInt(o.getValue("BaseDefenderSalvagePercent"));
            salvageAdjustment = Integer.parseInt(o.getValue("DefenderSalvageAdjustment"));
        }
        for (OperationEntity currEntity : this.salvagableUnits.values()) {
            Boolean pilotLived;
            String oldOwnerName = currEntity.getOwnerName().toLowerCase();
            SPlayer oldOwner = CampaignMain.cm.getPlayer(oldOwnerName);
            SUnit currU = oldOwner.getUnit(currEntity.getID());
            Object[] pilotinformation = this.setupPilotStringForUnit(currEntity, currU, so.getTargetWorld());
            if (winnerAlwaysSalvagesOwn && this.winners.containsKey(oldOwnerName)) {
                String toOwner = " You recovered your " + currU.getModelName() + ". ";
                String toOthers = oldOwner.getColoredName() + " recovered his " + currU.getModelName() + ". ";
                Boolean pilotLived2 = (Boolean)pilotinformation[0];
                if (!pilotLived2.booleanValue()) {
                    String deathString = this.handleDeadPilot(oldOwner, currU, currEntity);
                    String workingS = (String)pilotinformation[1];
                    pilotinformation[1] = workingS + deathString;
                }
                for (String currName : this.allPlayers.keySet()) {
                    SPlayer captor = (SPlayer)pilotinformation[4];
                    toSet = toOthers + pilotinformation[3];
                    toSet = currName.equals(oldOwnerName) ? toOwner + pilotinformation[1] : (captor != null && currName.equals(captor.getName().toLowerCase()) ? toOthers + pilotinformation[2] : toOthers + pilotinformation[3]);
                    if (this.unitStrings.containsKey(currName)) {
                        String workingS = this.unitStrings.get(currName);
                        this.unitStrings.put(currName, workingS + toSet + "<br>");
                        continue;
                    }
                    this.unitStrings.put(currName, toSet + "<br>");
                }
                int costToRepair = this.getSalvageCost(oldOwner, currU, currEntity, o, so);
                if (this.unitCosts.containsKey(oldOwnerName)) {
                    Integer oldCost = this.unitCosts.get(oldOwnerName);
                    this.unitCosts.put(oldOwnerName, oldCost + costToRepair);
                } else {
                    this.unitCosts.put(oldOwnerName, costToRepair);
                }
                if (this.scrapThreads.containsKey(oldOwnerName)) {
                    this.scrapThreads.get(oldOwnerName).addScrappableUnit(currU.getId(), costToRepair);
                } else {
                    OpsScrapThread ost = new OpsScrapThread(oldOwnerName);
                    ost.addScrappableUnit(currU.getId(), costToRepair);
                    this.scrapThreads.put(oldOwnerName, ost);
                }
                CampaignMain.cm.toUser("PL|UU|" + currU.getId() + "|" + currU.toString(true), oldOwnerName, false);
                continue;
            }
            SPlayer newOwner = null;
            if (CampaignMain.cm.getR().nextInt(100) < winnerSalvagePercent) {
                if (!this.winners.containsKey(oldOwnerName)) {
                    newOwner = this.selectRandomWinner();
                }
                if (salvageAdjustment != 0) {
                    winnerSalvagePercent -= salvageAdjustment;
                }
                if (winnerSalvagePercent < 0) {
                    winnerSalvagePercent = 0;
                }
            } else {
                if (!this.losers.containsKey(oldOwnerName)) {
                    newOwner = this.selectRandomLoser();
                }
                if (salvageAdjustment != 0) {
                    winnerSalvagePercent += salvageAdjustment;
                }
                if (winnerSalvagePercent > 100) {
                    winnerSalvagePercent = 100;
                }
            }
            if (!(pilotLived = (Boolean)pilotinformation[0]).booleanValue() && newOwner == null) {
                String deathString = this.handleDeadPilot(oldOwner, currU, currEntity);
                String workingS = (String)pilotinformation[1];
                workingS = workingS + deathString;
            }
            if (pilotLived.booleanValue() && newOwner != null) {
                this.handleDispossesedPilot(oldOwner, currU);
            }
            String toOriginalOwner = "";
            String toNewOwner = "";
            String toOthers = "";
            if (newOwner == null) {
                toOriginalOwner = " You recovered your " + currU.getModelName() + ". ";
                toOthers = oldOwner.getColoredName() + " recovered his " + currU.getModelName() + ". ";
            } else {
                toOriginalOwner = " " + newOwner.getColoredName() + " has recovered your " + currU.getModelName() + ". ";
                toNewOwner = " You recovered " + oldOwner.getColoredName() + "'s " + currU.getModelName() + ". ";
                toOthers = " " + newOwner + " recovered " + oldOwner.getColoredName() + "'s " + currU.getModelName() + ". ";
            }
            for (String currName : this.allPlayers.keySet()) {
                SPlayer captor = (SPlayer)pilotinformation[4];
                String toSet2 = toOthers + pilotinformation[3];
                toSet2 = currName.equals(oldOwnerName) ? toOriginalOwner + pilotinformation[1] : (newOwner != null && currName.equals(newOwner.getName().toLowerCase()) ? (captor != null && currName.equals(captor.getName().toLowerCase()) ? toNewOwner + pilotinformation[2] : toNewOwner + pilotinformation[3]) : (captor != null && currName.equals(captor.getName().toLowerCase()) ? toOthers + pilotinformation[2] : toOthers + pilotinformation[3]));
                if (this.unitStrings.containsKey(currName)) {
                    String workingS = this.unitStrings.get(currName);
                    this.unitStrings.put(currName, workingS + toSet2 + "<br>");
                    continue;
                }
                this.unitStrings.put(currName, toSet2 + "<br>");
            }
            if (newOwner != null) {
                boolean usingPPQ = Boolean.valueOf(CampaignMain.cm.getConfig("AllowPersonalPilotQueues"));
                if (usingPPQ) {
                    currU.setPilot(new SPilot("Vacant", 99, 99), true);
                    oldOwner.removeUnit(currU.getId(), false);
                    newOwner.addUnit(currU, true);
                } else {
                    oldOwner.removeUnit(currU.getId(), false);
                    String newPilot = this.handleDeadPilot(newOwner, currU, currEntity);
                    newOwner.addUnit(currU, true);
                    String workingS = this.unitStrings.get(newOwner.getName().toLowerCase());
                    workingS = workingS.substring(0, workingS.length() - 4);
                    this.unitStrings.put(newOwner.getName().toLowerCase(), workingS + newPilot + "<br>");
                }
            } else {
                if (pilotLived.booleanValue()) {
                    boolean countKills;
                    int realKills = 0;
                    int totalXPforUnit = 0;
                    boolean bl = countKills = Boolean.valueOf(o.getValue("NoStatisticsMode")) == false;
                    if (currEntity.getKills().size() > 0 && countKills) {
                        for (Integer id : currEntity.getKills()) {
                            SUnit killedUnit;
                            OperationEntity killed = this.salvagableUnits.get(id);
                            if (killed == null) {
                                killed = this.destroyedUnits.get(id);
                            }
                            if (killed == null || (killedUnit = currEntity.getOwner().getUnit(currEntity.getID())) == null || this.winners.containsKey(oldOwnerName) && this.winners.containsKey(killed.getOwnerName().toLowerCase()) || this.losers.containsKey(oldOwnerName) && this.losers.containsKey(killed.getOwnerName().toLowerCase())) continue;
                            totalXPforUnit += flatKillXP;
                            int bvForBonusXP = Integer.parseInt(o.getValue("KillBonusXPforBV"));
                            if (bvForBonusXP > 0) {
                                totalXPforUnit = (int)((double)totalXPforUnit + Math.floor(killedUnit.getBV() / bvForBonusXP));
                            }
                            ++realKills;
                        }
                        currU.getPilot().addKill(realKills);
                        boolean housePilotGetsXP = Boolean.valueOf(o.getValue("HousePilotsGainXP"));
                        boolean solPilotGetsXP = Boolean.valueOf(o.getValue("SOLPilotsGainXP"));
                        if (oldOwner.getMyHouse().isNewbieHouse() && !solPilotGetsXP) {
                            totalXPforUnit = 0;
                        }
                        if (!oldOwner.getMyHouse().isNewbieHouse() && !housePilotGetsXP) {
                            totalXPforUnit = 0;
                        }
                        if (totalXPforUnit < 0) {
                            totalXPforUnit = 0;
                        }
                        if (currU.getPilot().getSkills().has(17)) {
                            totalXPforUnit = (int)((double)totalXPforUnit * 1.05);
                        }
                        currU.getPilot().setExperience(currU.getPilot().getExperience() + totalXPforUnit);
                        String workingS = this.unitStrings.get(oldOwnerName);
                        workingS = workingS.substring(0, workingS.length() - 4);
                        String killString = "Earned ";
                        if (realKills == 1) {
                            killString = killString + "1 kill.";
                        } else if (realKills > 1) {
                            killString = killString + realKills + " kills";
                        }
                        this.unitStrings.put(oldOwnerName, workingS + " Gained " + totalXPforUnit + "XP, " + killString + ".<br>");
                    }
                }
                CampaignMain.cm.toUser("PL|UU|" + currU.getId() + "|" + currU.toString(true), oldOwnerName, false);
            }
            int costToRepair = 0;
            String nameKey = "";
            if (newOwner != null) {
                costToRepair = this.getSalvageCost(newOwner, currU, currEntity, o, so);
                nameKey = newOwner.getName().toLowerCase();
            } else {
                costToRepair = this.getSalvageCost(oldOwner, currU, currEntity, o, so);
                nameKey = oldOwnerName;
            }
            if (this.unitCosts.containsKey(nameKey)) {
                Integer cost = this.unitCosts.get(nameKey);
                cost = cost + costToRepair;
            } else {
                this.unitCosts.put(nameKey, costToRepair);
            }
            if (this.scrapThreads.containsKey(nameKey)) {
                this.scrapThreads.get(nameKey).addScrappableUnit(currU.getId(), costToRepair);
                continue;
            }
            OpsScrapThread ost = new OpsScrapThread(nameKey);
            ost.addScrappableUnit(currU.getId(), costToRepair);
            this.scrapThreads.put(nameKey, ost);
        }
        for (OperationEntity currEntity : this.destroyedUnits.values()) {
            String oldOwnerName = currEntity.getOwnerName().toLowerCase();
            SPlayer oldOwner = CampaignMain.cm.getPlayer(oldOwnerName);
            SUnit currU = oldOwner.getUnit(currEntity.getID());
            String toOwner = "Your " + currU.getModelName() + " was utterly destroyed. ";
            String toOthers = oldOwner.getColoredName() + "'s " + currU.getModelName() + " was utterly destroyed. ";
            Object[] pilotinformation = this.setupPilotStringForUnit(currEntity, currU, so.getTargetWorld());
            Boolean pilotLived = (Boolean)pilotinformation[0];
            if (pilotLived.booleanValue()) {
                this.handleDispossesedPilot(oldOwner, currU);
            }
            oldOwner.removeUnit(currU.getId(), false);
            for (String currName : this.allPlayers.keySet()) {
                SPlayer captor = (SPlayer)pilotinformation[4];
                toSet = toOthers + pilotinformation[3];
                toSet = currName.equals(oldOwnerName) ? toOwner + pilotinformation[1] : (captor != null && currName.equals(captor.getName().toLowerCase()) ? toOthers + pilotinformation[2] : toOthers + pilotinformation[3]);
                if (this.unitStrings.containsKey(currName)) {
                    String workingS = this.unitStrings.get(currName);
                    this.unitStrings.put(currName, workingS + toSet + "<br>");
                    continue;
                }
                this.unitStrings.put(currName, toSet + "<br>");
            }
        }
    }

    private void assembleDescriptionStrings(Operation o, ShortOperation so) {
        int delayBVAdjust;
        int delayUnitAdjust;
        int conquestBVAdjust;
        int conquestUnitAdjust;
        int totalConquest;
        String toSet;
        this.metaStrings = new TreeMap();
        SPlayer aWinner = this.winners.get(this.winners.firstKey());
        SPlayer aLoser = this.losers.get(this.losers.firstKey());
        if (so.getAttackers().containsKey(this.winners.firstKey())) {
            this.attackersWon = true;
            this.defendersWon = false;
        } else {
            this.defendersWon = true;
            this.attackersWon = false;
        }
        boolean attackersPolluted = false;
        boolean defendersPolluted = false;
        for (SPlayer wp : this.winners.values()) {
            for (SPlayer compareP : this.winners.values()) {
                if (compareP.getHouseFightingFor().equals(wp.getHouseFightingFor())) continue;
                attackersPolluted = true;
            }
            if (!attackersPolluted) continue;
            break;
        }
        block2: for (SPlayer lp : this.losers.values()) {
            for (SPlayer compareP : this.losers.values()) {
                if (!compareP.getHouseFightingFor().equals(lp.getHouseFightingFor())) {
                    defendersPolluted = true;
                    continue block2;
                }
                if (!defendersPolluted) continue;
                continue block2;
            }
        }
        if (attackersPolluted || defendersPolluted) {
            String genericWinnerString = "";
            int marker = 0;
            int total = this.winners.size();
            for (SPlayer wp : this.winners.values()) {
                genericWinnerString = genericWinnerString + wp.getName();
                if (++marker + 1 == total) {
                    genericWinnerString = genericWinnerString + " and ";
                    continue;
                }
                if (marker + 1 >= total) continue;
                genericWinnerString = genericWinnerString + ", ";
            }
            this.finishedInfoString = this.finishedInfoString + genericWinnerString;
            this.finishedInfoString = this.finishedInfoString + " defeated ";
            String genericLoserString = "";
            marker = 0;
            total = this.losers.size();
            for (SPlayer lp : this.losers.values()) {
                genericLoserString = genericLoserString + lp.getName();
                if (++marker + 1 == total) {
                    genericLoserString = genericLoserString + " and ";
                    continue;
                }
                if (marker + 1 >= total) continue;
                genericLoserString = genericLoserString + ", ";
            }
            this.finishedInfoString = this.finishedInfoString + genericLoserString + " (" + so.getName() + ").";
            int numberOfWinners = this.winners.size();
            for (SPlayer wp : this.winners.values()) {
                if (numberOfWinners == 1) {
                    this.metaStrings.put(wp.getName().toLowerCase(), "You have defeated " + genericLoserString + " (" + so.getName() + ").");
                    continue;
                }
                int i = 0;
                int numToList = numberOfWinners - 1;
                String toSet2 = "You worked with ";
                for (SPlayer loopP : this.winners.values()) {
                    if (!wp.equals(loopP)) {
                        toSet2 = toSet2 + wp.getName();
                        if (++i + 1 == numToList) {
                            toSet2 = toSet2 + " and ";
                            continue;
                        }
                        if (marker + 1 >= numToList) continue;
                        toSet2 = toSet2 + ", ";
                        continue;
                    }
                    ++i;
                }
                toSet2 = toSet2 + " to defeat " + genericLoserString + " (" + so.getName() + ").";
                this.metaStrings.put(wp.getName().toLowerCase(), toSet2);
            }
            for (SPlayer lp : this.losers.values()) {
                this.metaStrings.put(lp.getName().toLowerCase(), "You were defeated by " + genericWinnerString + " (" + so.getName() + ").");
            }
            return;
        }
        int numWinners = this.winners.size();
        int numLosers = this.losers.size();
        for (SPlayer wp : this.winners.values()) {
            toSet = "";
            toSet = numWinners > 1 ? toSet + "Your team " : toSet + "You ";
            toSet = toSet + " defeated ";
            toSet = numLosers > 1 ? toSet + aLoser.getHouseFightingFor().getColoredNameAsLink() : toSet + aLoser.getColoredName();
            toSet = toSet + " on " + so.getTargetWorld().getNameAsColoredLink() + " (" + so.getName() + ").";
            this.metaStrings.put(wp.getName().toLowerCase(), toSet + "<br>");
        }
        for (SPlayer lp : this.losers.values()) {
            toSet = "";
            toSet = numLosers > 1 ? toSet + "Your team was defeated by " : toSet + "You were defeated by ";
            toSet = numWinners > 1 ? toSet + aWinner.getHouseFightingFor().getColoredNameAsLink() : toSet + aWinner.getColoredName();
            toSet = toSet + " on " + so.getTargetWorld().getNameAsColoredLink() + " (" + so.getName() + ").";
            this.metaStrings.put(lp.getName().toLowerCase(), toSet + "<br>");
        }
        this.finishedInfoString = numWinners > 1 ? this.finishedInfoString + aWinner.getHouseFightingFor().getColoredNameAsLink() : this.finishedInfoString + aWinner.getColoredName();
        String loserTemp = "";
        loserTemp = numLosers > 1 ? loserTemp + aLoser.getHouseFightingFor().getColoredNameAsLink() : loserTemp + aLoser.getColoredName();
        this.finishedInfoString = numLosers > 1 && this.attackersWon ? this.finishedInfoString + " defeated" + loserTemp + "defenders" : (numLosers == 1 && this.attackersWon ? this.finishedInfoString + " attacked and defeated " + loserTemp : (numLosers > 1 && this.defendersWon ? this.finishedInfoString + " defeated " + loserTemp + " attackers" : this.finishedInfoString + " defeated an attack by " + loserTemp));
        this.finishedInfoString = this.finishedInfoString + " on " + so.getTargetWorld().getNameAsColoredLink() + " (" + so.getName() + ").";
        if (o.getTypeIndicator() == Operation.TYPE_SHORTANDLONG) {
            return;
        }
        boolean hasLoss = false;
        int conquestCap = Integer.parseInt(o.getValue("ConquestAmountCap"));
        int delayCap = Integer.parseInt(o.getValue("DelayAmountCap"));
        int ppCaptureCap = Integer.parseInt(o.getValue("PPCapptureCap"));
        int unitCaptureCap = Integer.parseInt(o.getValue("UnitCaptureCap"));
        String winnerMetaString = "";
        String loserMetaString = "";
        SPlanet target = so.getTargetWorld();
        if (this.attackersWon) {
            totalConquest = Integer.parseInt(o.getValue("AttackerBaseConquestAmount"));
            conquestUnitAdjust = Integer.parseInt(o.getValue("AttackerConquestUnitAdjustment"));
            conquestBVAdjust = Integer.parseInt(o.getValue("AttackerConquestBVAdjustment"));
            if (conquestUnitAdjust > 0) {
                totalConquest = (int)((double)totalConquest + Math.floor(this.totalUnits / conquestUnitAdjust));
            }
            if (conquestBVAdjust > 0) {
                totalConquest = (int)((double)totalConquest + Math.floor(this.totalBV / conquestBVAdjust));
            }
            if (totalConquest > conquestCap) {
                totalConquest = conquestCap;
            }
            if (!aWinner.getMyHouse().isConquerable() || !aLoser.getMyHouse().isConquerable()) {
                totalConquest = 0;
            }
            if (!so.getTargetWorld().isConquerable()) {
                totalConquest = 0;
            }
            if ((totalConquest = so.getTargetWorld().doGainInfluence(aWinner.getHouseFightingFor(), aLoser.getHouseFightingFor(), totalConquest)) > 0) {
                hasLoss = true;
                winnerMetaString = winnerMetaString + " gained " + totalConquest + "% of " + target.getNameAsColoredLink();
                loserMetaString = loserMetaString + " lost " + totalConquest + "% of " + target.getNameAsColoredLink();
            }
            int totalDelay = Integer.parseInt(o.getValue("AttackerBaseDelayAmount"));
            delayUnitAdjust = Integer.parseInt(o.getValue("AttackerDelayUnitAdjustment"));
            delayBVAdjust = Integer.parseInt(o.getValue("AttackerDelayBVAdjustment"));
            if (delayUnitAdjust > 0) {
                totalDelay = (int)((double)totalDelay + Math.floor(this.totalUnits / delayUnitAdjust));
            }
            if (delayBVAdjust > 0) {
                totalDelay = (int)((double)totalDelay + Math.floor(this.totalBV / delayBVAdjust));
            }
            if (this.buildingsLeft > -1 && this.buildingsLeft < so.getTotalBuildings()) {
                int MinBuildingsIfAttackerWins;
                if (this.attackerisWinner(so) && this.buildingsDestroyed < (MinBuildingsIfAttackerWins = Integer.parseInt(o.getValue("AttackerMinBuildingsIfAttackerWins")))) {
                    this.buildingsDestroyed = MinBuildingsIfAttackerWins;
                }
                if (this.buildingsDestroyed >= so.getMinBuildings()) {
                    int buildingDestructionDelayAmount = Integer.parseInt(o.getValue("DelayPerBuilding"));
                    totalDelay += buildingDestructionDelayAmount * this.buildingsDestroyed;
                }
            }
            if (totalDelay > delayCap) {
                totalDelay = delayCap;
            }
            if (target.getFactoryCount() == 0) {
                totalDelay = 0;
            }
            if (totalDelay > 0) {
                for (SUnitFactory currFacility : target.getUnitFactories()) {
                    currFacility.addRefresh(totalDelay);
                }
                if (hasLoss) {
                    winnerMetaString = winnerMetaString + ",";
                    loserMetaString = loserMetaString + ",";
                }
                winnerMetaString = winnerMetaString + " stopped production on " + target.getNameAsColoredLink() + " for " + totalDelay + " miniticks";
                loserMetaString = loserMetaString + " allowed " + aWinner.getHouseFightingFor().getColoredNameAsLink() + " to stop production on " + target.getNameAsColoredLink() + " for " + totalDelay + " miniticks";
                hasLoss = true;
            }
            int unitsToCapture = Integer.parseInt(o.getValue("AttackerBaseUnitsTaken"));
            int unitUnitAdjust = Integer.parseInt(o.getValue("AttackerUnitsUnitAdjustment"));
            int unitBVAdjust = Integer.parseInt(o.getValue("AttackerUnitsBVAdjustment"));
            if (unitUnitAdjust > 0) {
                unitsToCapture = (int)((double)unitsToCapture + Math.floor(this.totalUnits / unitUnitAdjust));
            }
            if (unitBVAdjust > 0) {
                unitsToCapture = (int)((double)unitsToCapture + Math.floor(this.totalBV / unitBVAdjust));
            }
            if (unitsToCapture > unitCaptureCap) {
                unitsToCapture = unitCaptureCap;
            }
            ArrayList<SUnit> capturedUnits = new ArrayList<SUnit>();
            if (unitsToCapture > 0) {
                int numCaptured = 0;
                ArrayList<SUnitFactory> factoriesSearched = new ArrayList<SUnitFactory>();
                while (factoriesSearched.size() < target.getFactoryCount()) {
                    SUnitFactory currFacility = target.getRandomUnitFactory();
                    if (factoriesSearched.contains(currFacility)) continue;
                    factoriesSearched.add(currFacility);
                    int currWeight = currFacility.getWeightclass();
                    for (int type = 0; type <= 4; ++type) {
                        if (!currFacility.canProduce(type)) continue;
                        boolean noUnits = false;
                        while (!noUnits && numCaptured < unitsToCapture) {
                            SUnit captured = aLoser.getHouseFightingFor().getEntity(currWeight, type);
                            if (captured == null) {
                                noUnits = true;
                                continue;
                            }
                            capturedUnits.add(captured);
                            aWinner.getHouseFightingFor().addUnit(captured, true);
                            ++numCaptured;
                        }
                    }
                }
                if (numCaptured >= 1) {
                    if (hasLoss) {
                        winnerMetaString = winnerMetaString + ",";
                        loserMetaString = loserMetaString + ",";
                    }
                    hasLoss = true;
                    String unitString = "";
                    for (SUnit currU : capturedUnits) {
                        unitString = unitString + currU.getModelName() + ", ";
                    }
                    unitString = unitString.substring(0, unitString.length() - 2);
                    if (numCaptured == 1) {
                        winnerMetaString = winnerMetaString + " taken a unit [" + unitString + "]";
                        loserMetaString = loserMetaString + " lost a unit [" + unitString + "]";
                    } else {
                        winnerMetaString = winnerMetaString + " taken " + numCaptured + " units [" + unitString + "]";
                        loserMetaString = loserMetaString + " lost " + numCaptured + " units [" + unitString + "]";
                    }
                }
            }
            double ppToCaptureDoub = Double.parseDouble(o.getValue("AttackerBasePPAmount"));
            double ppUnitAdjust = Double.parseDouble(o.getValue("AttackerPPBVAdjustment"));
            double ppBVAdjust = Double.parseDouble(o.getValue("AttackerPPUnitAdjustment"));
            if (ppUnitAdjust > 0.0) {
                ppToCaptureDoub *= (double)this.totalUnits / ppUnitAdjust;
            }
            if (ppBVAdjust > 0.0) {
                ppToCaptureDoub *= (double)this.totalBV / ppBVAdjust;
            }
            if (ppToCaptureDoub > (double)ppCaptureCap) {
                ppToCaptureDoub = ppCaptureCap;
            }
            int ppToCapture = (int)ppToCaptureDoub;
            int ppCaptured = 0;
            ArrayList<SUnitFactory> factoriesSearched = new ArrayList<SUnitFactory>();
            while (factoriesSearched.size() < target.getFactoryCount() && ppCaptured < ppToCapture) {
                SUnitFactory currFacility = target.getRandomUnitFactory();
                if (factoriesSearched.contains(currFacility)) continue;
                factoriesSearched.add(currFacility);
                int currWeight = currFacility.getWeightclass();
                for (int type = 0; type <= 4; ++type) {
                    if (!currFacility.canProduce(type)) continue;
                    boolean noPP = false;
                    while (!noPP && ppCaptured < ppToCapture) {
                        int ppAvailable = aLoser.getHouseFightingFor().getPP(currWeight, type);
                        if (ppAvailable <= 0) {
                            noPP = true;
                            continue;
                        }
                        int toTake = ppToCapture;
                        if (ppToCapture > ppAvailable) {
                            toTake = ppAvailable;
                        }
                        aLoser.getHouseFightingFor().addPP(currWeight, type, -toTake);
                        aWinner.getHouseFightingFor().addPP(currWeight, type, toTake);
                        ppCaptured += toTake;
                        if (hasLoss) {
                            winnerMetaString = winnerMetaString + ",";
                            loserMetaString = loserMetaString + ",";
                        }
                        winnerMetaString = winnerMetaString + " stolen " + toTake + " " + SUnit.getWeightClassDesc(currWeight) + " " + SUnit.getTypeClassDesc(type) + " components";
                        loserMetaString = loserMetaString + " lost " + toTake + " " + SUnit.getWeightClassDesc(currWeight) + " " + SUnit.getTypeClassDesc(type) + " components";
                        hasLoss = true;
                    }
                }
            }
        } else if (this.defendersWon) {
            totalConquest = Integer.parseInt(o.getValue("DefenderBaseConquestAmount"));
            conquestUnitAdjust = Integer.parseInt(o.getValue("DefenderConquestUnitAdjustment"));
            conquestBVAdjust = Integer.parseInt(o.getValue("DefenderConquestBVAdjustment"));
            if (conquestUnitAdjust > 0) {
                totalConquest = (int)((double)totalConquest + Math.floor(this.totalUnits / conquestUnitAdjust));
            }
            if (conquestBVAdjust > 0) {
                totalConquest = (int)((double)totalConquest + Math.floor(this.totalBV / conquestBVAdjust));
            }
            if (totalConquest > conquestCap) {
                totalConquest = conquestCap;
            }
            if (!aWinner.getMyHouse().isConquerable() || !aLoser.getMyHouse().isConquerable()) {
                totalConquest = 0;
            }
            if (!so.getTargetWorld().isConquerable()) {
                totalConquest = 0;
            }
            if ((totalConquest = so.getTargetWorld().doGainInfluence(aWinner.getHouseFightingFor(), aLoser.getHouseFightingFor(), totalConquest)) > 0) {
                hasLoss = true;
                winnerMetaString = winnerMetaString + " gained " + totalConquest + "% of " + target.getNameAsColoredLink();
                loserMetaString = loserMetaString + " lost " + totalConquest + "% of " + target.getNameAsColoredLink();
            }
            int totalRefreshBoost = Integer.parseInt(o.getValue("DefenderBaseDelayAmount"));
            delayUnitAdjust = Integer.parseInt(o.getValue("DefenderDelayUnitAdjustment"));
            delayBVAdjust = Integer.parseInt(o.getValue("DefenderDelayBVAdjustment"));
            if (delayUnitAdjust > 0) {
                totalRefreshBoost = (int)((double)totalRefreshBoost + Math.floor(this.totalUnits / delayUnitAdjust));
            }
            if (delayBVAdjust > 0) {
                totalRefreshBoost = (int)((double)totalRefreshBoost + Math.floor(this.totalBV / delayBVAdjust));
            }
            if (totalRefreshBoost > delayCap) {
                totalRefreshBoost = delayCap;
            }
            if (target.getFactoryCount() == 0) {
                totalRefreshBoost = 0;
            }
            if (totalRefreshBoost > 0) {
                for (SUnitFactory currFacility : target.getUnitFactories()) {
                    currFacility.addRefresh(totalRefreshBoost);
                }
                if (hasLoss) {
                    winnerMetaString = winnerMetaString + ",";
                    loserMetaString = loserMetaString + ",";
                }
                winnerMetaString = winnerMetaString + " sped up production on " + target.getNameAsColoredLink() + " by " + totalRefreshBoost + " miniticks";
                loserMetaString = loserMetaString + " encouraged the workers on " + target.getNameAsColoredLink() + " to speed up the production lines for " + totalRefreshBoost + "miniticks";
                hasLoss = true;
            }
            if (target.getFactoryCount() > 0) {
                int ppToGenerate;
                double ppToGenerateDoub = Double.parseDouble(o.getValue("DefenderBasePPAmount"));
                double ppUnitAdjust = Double.parseDouble(o.getValue("DefenderPPUnitAdjustment"));
                double ppBVAdjust = Double.parseDouble(o.getValue("DefenderPPBVAdjustment"));
                if (ppUnitAdjust > 0.0) {
                    ppToGenerateDoub *= (double)this.totalUnits / ppUnitAdjust;
                }
                if (ppBVAdjust > 0.0) {
                    ppToGenerateDoub *= (double)this.totalBV / ppBVAdjust;
                }
                if (ppToGenerateDoub > (double)ppCaptureCap) {
                    ppToGenerateDoub = ppCaptureCap;
                }
                if ((ppToGenerate = (int)ppToGenerateDoub) > 0) {
                    SUnitFactory currFacility = target.getRandomUnitFactory();
                    for (int type = 0; type <= 4; ++type) {
                        if (!currFacility.canProduce(type)) continue;
                        aWinner.getHouseFightingFor().addPP(currFacility.getWeightclass(), type, ppToGenerate);
                        if (hasLoss) {
                            winnerMetaString = winnerMetaString + ",";
                            loserMetaString = loserMetaString + ",";
                        }
                        winnerMetaString = winnerMetaString + " generated an extra " + ppToGenerate + " " + SUnit.getWeightClassDesc(currFacility.getWeightclass()) + " " + SUnit.getTypeClassDesc(type) + " components";
                        loserMetaString = loserMetaString + " inspired the workers on " + target.getNameAsColoredLink() + " to manufacture " + ppToGenerate + " " + SUnit.getWeightClassDesc(currFacility.getWeightclass()) + " " + SUnit.getTypeClassDesc(type) + " components";
                        hasLoss = true;
                    }
                }
            }
        }
        if (hasLoss) {
            String meta1 = "";
            String meta2 = "";
            int winnerIndex = winnerMetaString.lastIndexOf(", ");
            int loserIndex = loserMetaString.lastIndexOf(", ");
            if (winnerIndex >= 0) {
                meta1 = winnerMetaString.substring(0, winnerIndex);
                meta2 = winnerMetaString.substring(winnerIndex + 2, winnerMetaString.length());
                winnerMetaString = meta1 + " and " + meta2 + ".";
            }
            this.finishedInfoString = this.finishedInfoString + " " + aWinner.getHouseFightingFor().getColoredNameAsLink() + " has " + winnerMetaString;
            if (loserIndex >= 0) {
                meta1 = loserMetaString.substring(0, loserIndex);
                meta2 = loserMetaString.substring(loserIndex + 2, loserMetaString.length());
                loserMetaString = meta1 + " and " + meta2 + ".";
            }
            for (String currName : this.winners.keySet()) {
                String currMeta = this.metaStrings.get(currName);
                this.metaStrings.put(currName, currMeta + " You've " + winnerMetaString + "<br>");
            }
            for (String currName : this.losers.keySet()) {
                String currentMeta = this.metaStrings.get(currName);
                this.metaStrings.put(currName, currentMeta + " You've " + loserMetaString + "<br>");
            }
        }
    }

    private void possibleSalvageFromReport(StringTokenizer reportTokenizer) {
        this.salvagableUnits = new TreeMap();
        this.destroyedUnits = new TreeMap();
        this.livingUnits = new TreeMap();
        this.pilots = new TreeMap();
        while (reportTokenizer.hasMoreTokens()) {
            String currentUnit = reportTokenizer.nextToken();
            if (currentUnit.startsWith("MW*")) {
                StringTokenizer mwTokenizer = new StringTokenizer(currentUnit, "*");
                mwTokenizer.nextToken();
                int originalID = Integer.parseInt(mwTokenizer.nextToken());
                int pickUpID = Integer.parseInt(mwTokenizer.nextToken());
                boolean isDead = Boolean.valueOf(mwTokenizer.nextToken());
                SPilot mw = SPilot.getMekWarrior(originalID, pickUpID);
                mw.setDeath(isDead);
                this.pilots.put(originalID, mw);
                continue;
            }
            if (currentUnit.startsWith("BL*")) {
                this.buildingsLeft = Integer.parseInt(currentUnit.substring(3));
                continue;
            }
            OperationEntity oEntity = new OperationEntity(currentUnit);
            if (CampaignMain.cm.getPlayer(oEntity.getOwnerName()).getUnit(oEntity.getID()) == null) continue;
            if (oEntity.isLiving()) {
                this.livingUnits.put(oEntity.getID(), oEntity);
                continue;
            }
            if (oEntity.isSalvagable()) {
                this.salvagableUnits.put(oEntity.getID(), oEntity);
                continue;
            }
            this.destroyedUnits.put(oEntity.getID(), oEntity);
        }
        int baseChance = Integer.parseInt(CampaignMain.cm.getConfig("ArtilleryOffBoardOverRun"));
        int captureChance = Integer.parseInt(CampaignMain.cm.getConfig("OffBoardChanceOfCapture"));
        Iterator<OperationEntity> i = this.livingUnits.values().iterator();
        while (i.hasNext()) {
            OperationEntity currO = i.next();
            if (this.winners.containsKey(currO.getOwnerName().toLowerCase())) continue;
            if (currO.getOffBoardRange() <= 0) {
                return;
            }
            int currOverrunChance = baseChance - currO.getOffBoardRange();
            if (CampaignMain.cm.getR().nextInt(100) > currOverrunChance) continue;
            i.remove();
            if (CampaignMain.cm.getR().nextInt(100) < captureChance) {
                currO.setRemovalReason(512);
                this.salvagableUnits.put(currO.getID(), currO);
                continue;
            }
            if (currO.getType() == 0 || currO.getType() == 5) {
                currO.setCTint(0);
            }
            currO.setSalvage(false);
            this.destroyedUnits.put(currO.getID(), currO);
        }
    }

    public void possibleSalvageFromInProgressInfo(ShortOperation so, SPlayer loser) {
        this.salvagableUnits = new TreeMap();
        this.destroyedUnits = new TreeMap();
        this.livingUnits = new TreeMap();
        this.pilots = new TreeMap();
        for (OperationEntity currEntity : so.getUnitsInProgress().values()) {
            if (CampaignMain.cm.getPlayer(currEntity.getOwnerName()).getUnit(currEntity.getID()) == null) continue;
            if (currEntity.isLiving()) {
                this.livingUnits.put(currEntity.getID(), currEntity);
                continue;
            }
            if (currEntity.isSalvagable()) {
                this.salvagableUnits.put(currEntity.getID(), currEntity);
                continue;
            }
            this.destroyedUnits.put(currEntity.getID(), currEntity);
        }
        for (SArmy currArmy : this.allArmies.values()) {
            for (Unit currUnit : currArmy.getUnits()) {
                int currID = currUnit.getId();
                if (this.livingUnits.get(currID) != null || this.salvagableUnits.get(currID) != null || this.destroyedUnits.get(currID) != null) continue;
                OperationEntity oe = new OperationEntity(currArmy.getPlayerName(), currID, 0, 1, 1, true);
                this.livingUnits.put(currID, oe);
            }
        }
        this.pilots.putAll(so.getPilotsInProgress());
        ArrayList<OperationEntity> dropLivingUnits = new ArrayList<OperationEntity>();
        for (OperationEntity currE : this.livingUnits.values()) {
            if (!currE.getOwnerName().toLowerCase().equals(loser.getName().toLowerCase())) continue;
            dropLivingUnits.add(currE);
        }
        if (dropLivingUnits.size() > 0) {
            int unitsToDestory = Integer.parseInt(CampaignMain.cm.getConfig("DisconnectionAddUnitsDestroyed"));
            int unitsToSalvage = Integer.parseInt(CampaignMain.cm.getConfig("DisconnectionAddUnitsSalvage"));
            for (int unitsDestroyed = 0; unitsDestroyed < unitsToDestory && dropLivingUnits.size() > 0; ++unitsDestroyed) {
                OperationEntity randomEntity = (OperationEntity)dropLivingUnits.get(CampaignMain.cm.getR().nextInt(dropLivingUnits.size()));
                randomEntity.setRemovalReason(1024);
                randomEntity.setSalvage(false);
                this.livingUnits.remove(randomEntity.getID());
                this.destroyedUnits.put(randomEntity.getID(), randomEntity);
                dropLivingUnits.remove(randomEntity);
            }
            for (int unitsSalvaged = 0; unitsSalvaged < unitsToSalvage && dropLivingUnits.size() > 0; ++unitsSalvaged) {
                OperationEntity randomEntity = (OperationEntity)dropLivingUnits.get(CampaignMain.cm.getR().nextInt(dropLivingUnits.size()));
                if (randomEntity.getType() == 0 || randomEntity.getType() == 5) {
                    this.pilots.put(randomEntity.getID(), SPilot.getMekWarrior(randomEntity.getID(), -1));
                }
                randomEntity.setRemovalReason(512);
                randomEntity.setSalvage(true);
                this.livingUnits.remove(randomEntity.getID());
                this.salvagableUnits.put(randomEntity.getID(), randomEntity);
                dropLivingUnits.remove(randomEntity);
            }
        }
    }

    private String handleDeadPilot(SPlayer owner, SUnit unit, OperationEntity entity) {
        boolean isMek;
        String toReturn = "";
        boolean personalQueues = Boolean.valueOf(CampaignMain.cm.getConfig("AllowPersonalPilotQueues"));
        boolean bl = isMek = entity.getType() == 0 || entity.getType() == 5;
        if (isMek && personalQueues) {
            SPilot pilot = new SPilot("Vacant", 99, 99);
            unit.setPilot(pilot, true);
        } else {
            unit.setPilot(owner.getMyHouse().getNewPilot(unit.getType()), true);
            toReturn = toReturn + " New Pilot: " + unit.getPilot().getName() + " " + this.newPilotDescription(unit);
        }
        return toReturn;
    }

    private void handleDispossesedPilot(SPlayer owner, SUnit unit) {
        if (Boolean.valueOf(CampaignMain.cm.getConfig("AllowPersonalPilotQueues")).booleanValue()) {
            owner.getPlayerPersonalPilotQueue().addPilot(unit.getType(), unit.getWeightclass(), unit.getPilot());
            CampaignMain.cm.toUser("PL|PPQ|" + owner.getPlayerPersonalPilotQueue().toString(true), owner.getName(), false);
            unit.setPilot(new SPilot("Vacant", 99, 99), false);
        } else {
            owner.getHouseFightingFor().addDispossessedPilot(unit, true);
        }
    }

    private Object[] setupPilotStringForUnit(OperationEntity currEntity, SUnit currUnit, SPlanet target) {
        int minChance;
        SPilot mw = this.pilots.get(currEntity.getID());
        Object[] toReturn = new Object[]{new Boolean(false), "", "", "", null};
        if (mw != null) {
            int minChance2;
            if (mw.isDead()) {
                toReturn[1] = currUnit.getPilot().getName() + " ejected, but was killed on the ground.";
                toReturn[3] = " The pilot was killed.";
                return toReturn;
            }
            SPlayer pickupPlayer = null;
            OperationEntity pickupEntity = this.livingUnits.get(mw.getPickedUpID());
            if (pickupEntity != null) {
                pickupPlayer = CampaignMain.cm.getPlayer(pickupEntity.getOwnerName());
            }
            if (pickupPlayer != null) {
                if (currEntity.getOwner().getHouseFightingFor().equals(pickupPlayer.getHouseFightingFor())) {
                    toReturn[0] = new Boolean(true);
                    toReturn[1] = currUnit.getPilot().getName() + " ejected and was picked up by a friendly unit.";
                    toReturn[3] = "The pilot survived.";
                    return toReturn;
                }
                toReturn[1] = currUnit.getPilot().getName() + " ejected, but was captured by enemy forces.";
                toReturn[3] = "The pilot was captured.";
                toReturn[4] = pickupPlayer;
                int captureChance = Integer.parseInt(CampaignMain.cm.getConfig("ChanceToConvertCapturedPilots"));
                if (CampaignMain.cm.getR().nextInt(100) < captureChance) {
                    if (Boolean.valueOf(CampaignMain.cm.getConfig("AllowPersonalPilotQueues")).booleanValue()) {
                        pickupPlayer.getPlayerPersonalPilotQueue().addPilot(currUnit.getType(), currUnit.getWeightclass(), currUnit.getPilot());
                        CampaignMain.cm.toUser("PL|PPQ|" + pickupPlayer.getPlayerPersonalPilotQueue().toString(true), pickupPlayer.getName(), false);
                    } else {
                        pickupPlayer.getHouseFightingFor().addDispossessedPilot(currUnit, true);
                    }
                    toReturn[0] = new Boolean(false);
                    toReturn[2] = currUnit.getPilot().getName() + " was captured by your forces and has decided to join " + pickupPlayer.getMyHouse().getColoredNameAsLink() + ".";
                    return toReturn;
                }
                toReturn[2] = currUnit.getPilot().getName() + " was captured by your forces and transferred to HQ for interrogation.";
                return toReturn;
            }
            if (this.winners.containsKey(currEntity.getOwnerName().toLowerCase())) {
                toReturn[0] = new Boolean(true);
                toReturn[1] = currUnit.getPilot().getName() + " was picked up by a recovery team.";
                toReturn[3] = "The pilot survived.";
                return toReturn;
            }
            int survivalChance = target.getInfluence().getInfluence(currEntity.getOwner().getHouseFightingFor().getId());
            if (survivalChance < (minChance2 = Integer.parseInt(CampaignMain.cm.getConfig("BasePilotSurvival")))) {
                survivalChance = minChance2;
            }
            if (currUnit.getPilot().getSkills().has(14)) {
                survivalChance += 20;
            }
            if (CampaignMain.cm.getR().nextInt(100) < survivalChance) {
                toReturn[0] = new Boolean(true);
                toReturn[1] = currUnit.getPilot().getName() + " hiked back to base.";
                toReturn[3] = "The pilot survived";
                return toReturn;
            }
            pickupPlayer = this.selectRandomWinner();
            toReturn[1] = currUnit.getPilot().getName() + " ejected, but was captured by enemy forces while hiking back to base.";
            toReturn[3] = "The pilot was captured.";
            toReturn[4] = pickupPlayer;
            int captureChance = Integer.parseInt(CampaignMain.cm.getConfig("ChanceToConvertCapturedPilots"));
            if (CampaignMain.cm.getR().nextInt(100) < captureChance) {
                if (Boolean.valueOf(CampaignMain.cm.getConfig("AllowPersonalPilotQueues")).booleanValue()) {
                    pickupPlayer.getPlayerPersonalPilotQueue().addPilot(currUnit.getType(), currUnit.getWeightclass(), currUnit.getPilot());
                    CampaignMain.cm.toUser("PL|PPQ|" + pickupPlayer.getPlayerPersonalPilotQueue().toString(true), pickupPlayer.getName(), false);
                } else {
                    pickupPlayer.getHouseFightingFor().addDispossessedPilot(currUnit, true);
                }
                toReturn[0] = new Boolean(false);
                toReturn[2] = currUnit.getPilot().getName() + " was abandoned by his forces and has decided to join " + pickupPlayer.getMyHouse().getColoredNameAsLink() + ".";
                return toReturn;
            }
            toReturn[2] = currUnit.getPilot().getName() + " was captured by your forces and transferred to HQ for interrogation.";
            return toReturn;
        }
        if (currEntity.getType() == 3) {
            toReturn[1] = currUnit.getPilot().getName() + " died when the unit was destroyed.";
            toReturn[3] = "The pilot was killed.";
            return toReturn;
        }
        if (currEntity.getType() == 1) {
            toReturn[1] = "The crew of the " + currUnit.getModelName() + " died when the unit was destroyed.";
            toReturn[3] = "The crew was killed.";
            return toReturn;
        }
        if (currEntity.getType() == 4 || currEntity.getType() == 2) {
            toReturn[1] = "The " + currUnit.getModelName() + " squad has been declared KIA.";
            toReturn[3] = "The squad was killed.";
            return toReturn;
        }
        if (currEntity.getPilothits() >= 6) {
            toReturn[1] = currUnit.getPilot().getName() + " was fatally wounded.";
            toReturn[3] = "The pilot was killed.";
            return toReturn;
        }
        if (currEntity.getHDint() <= 0) {
            toReturn[1] = currUnit.getPilot().getName() + " died when the " + currUnit.getModelName() + "'s head was destroyed.";
            toReturn[3] = "The pilot was killed.";
            return toReturn;
        }
        if (this.winners.containsKey(currEntity.getOwnerName().toLowerCase())) {
            toReturn[0] = new Boolean(true);
            toReturn[1] = currUnit.getPilot().getName() + " was recovered from his unit by a medical team.";
            toReturn[3] = "The pilot survived.";
            return toReturn;
        }
        if (!Boolean.valueOf(CampaignMain.cm.getConfig("DownPilotsMustRollForSurvival")).booleanValue()) {
            toReturn[0] = new Boolean(true);
            toReturn[1] = currUnit.getPilot().getName() + " was recovered from his unit by a medical team.";
            toReturn[3] = "The pilot survived.";
            return toReturn;
        }
        int survivalChance = target.getInfluence().getInfluence(currEntity.getOwner().getHouseFightingFor().getId());
        if (survivalChance < (minChance = Integer.parseInt(CampaignMain.cm.getConfig("BasePilotSurvival")))) {
            survivalChance = minChance;
        }
        if (currUnit.getPilot().getSkills().has(14)) {
            survivalChance += 20;
        }
        if (CampaignMain.cm.getR().nextInt(100) < (survivalChance -= 20)) {
            toReturn[0] = new Boolean(true);
            toReturn[1] = currUnit.getPilot().getName() + " crawled out of his unit and hiked back to base.";
            toReturn[3] = "The pilot survived.";
            return toReturn;
        }
        SPlayer pickupPlayer = this.selectRandomWinner();
        toReturn[1] = currUnit.getPilot().getName() + " was captured by enemy forces after fleeing the " + currUnit.getModelName() + ".";
        toReturn[3] = "The pilot was captured.";
        toReturn[4] = pickupPlayer;
        int captureChance = Integer.parseInt(CampaignMain.cm.getConfig("ChanceToConvertCapturedPilots"));
        if (CampaignMain.cm.getR().nextInt(100) < captureChance) {
            if (Boolean.valueOf(CampaignMain.cm.getConfig("AllowPersonalPilotQueues")).booleanValue()) {
                pickupPlayer.getPlayerPersonalPilotQueue().addPilot(currUnit.getType(), currUnit.getWeightclass(), currUnit.getPilot());
                CampaignMain.cm.toUser("PL|PPQ|" + pickupPlayer.getPlayerPersonalPilotQueue().toString(true), pickupPlayer.getName(), false);
            } else {
                pickupPlayer.getHouseFightingFor().addDispossessedPilot(currUnit, true);
            }
            toReturn[0] = new Boolean(false);
            toReturn[2] = currUnit.getPilot().getName() + " was rescued from his unit by our infantry and has decided to join " + pickupPlayer.getMyHouse().getColoredNameAsLink() + ".";
            return toReturn;
        }
        toReturn[2] = currUnit.getPilot().getName() + " captured by our infantry transferred to HQ for interrogation.";
        return toReturn;
    }

    private int getSalvageCost(SPlayer owner, SUnit u, OperationEntity oe, Operation o, ShortOperation so) {
        double repairCost = 0.0;
        int attackerMod = Integer.parseInt(o.getValue("BVToBoostAttackerSalvageCost"));
        int defenderMod = Integer.parseInt(o.getValue("BVToBoostDefenderSalvageCost"));
        boolean isAttacker = false;
        if (so.getAttackers().containsKey(owner.getName().toLowerCase()) && attackerMod > 0) {
            repairCost = u.getBV() / attackerMod;
            isAttacker = true;
        }
        if (so.getDefenders().containsKey(owner.getName().toLowerCase()) && defenderMod > 0) {
            repairCost = u.getBV() / defenderMod;
        }
        if (oe.getHDint() <= 0) {
            repairCost *= 0.7;
        } else if (oe.getRemovalReason() == 528) {
            repairCost *= 0.6;
        }
        if (oe.getLLint() <= 0 || oe.getRLint() <= 0) {
            repairCost *= 1.2;
        }
        repairCost = oe.getOwnerName().toLowerCase().equals(owner.getName().toLowerCase()) ? (repairCost *= 0.95) : (repairCost *= 1.15);
        double attackerMultiplier = Double.parseDouble(o.getValue("AttackerSalvageCostModifier"));
        double defenderMultiplier = Double.parseDouble(o.getValue("DefenderSalvageCostModifier"));
        repairCost = isAttacker ? (repairCost *= attackerMultiplier) : (repairCost *= defenderMultiplier);
        return (int)repairCost;
    }

    private SPlayer selectRandomWinner() {
        if (this.winners.size() <= 0) {
            return null;
        }
        if (this.winners.size() == 1) {
            String key = this.winners.firstKey();
            return CampaignMain.cm.getPlayer(key);
        }
        int random = CampaignMain.cm.getR().nextInt(this.winners.size());
        int current = 0;
        for (String wn : this.winners.keySet()) {
            if (random == current) {
                return CampaignMain.cm.getPlayer(wn);
            }
            ++current;
        }
        return null;
    }

    private SPlayer selectRandomLoser() {
        if (this.losers.size() <= 0) {
            return null;
        }
        if (this.losers.size() == 1) {
            String key = this.winners.firstKey();
            return CampaignMain.cm.getPlayer(key);
        }
        int random = CampaignMain.cm.getR().nextInt(this.losers.size());
        int current = 0;
        for (String ln : this.losers.keySet()) {
            if (random == current) {
                return CampaignMain.cm.getPlayer(ln);
            }
            ++current;
        }
        return null;
    }

    private String newPilotDescription(SUnit u) {
        String result = u.getPilot().getName() + " ";
        result = u.getType() == 0 || u.getType() == 1 ? "[" + u.getPilot().getGunnery() + "/" + u.getPilot().getPiloting() : u.getModelName() + " [" + u.getPilot().getGunnery();
        if (!u.getPilot().getSkillString(true).equals(" ")) {
            result = result + u.getPilot().getSkillString(true);
        }
        result = result + "]";
        return result;
    }

    private boolean attackerisWinner(ShortOperation so) {
        for (SPlayer currPlayer : this.allPlayers.values()) {
            if (!so.getAttackers().containsKey(currPlayer.getName()) || !this.winners.containsKey(currPlayer.getName())) continue;
            return true;
        }
        return false;
    }
}

