/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.operations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import megamek.common.BattleArmor;
import megamek.common.Protomech;
import server.campaign.CampaignMain;
import server.campaign.NewbiePlanet;
import server.campaign.SArmy;
import server.campaign.SHouse;
import server.campaign.SPlanet;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.operations.Operation;
import server.campaign.operations.OperationManager;
import server.campaign.operations.ShortOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortValidator {
    private OperationManager manager;
    public static final int SFAIL_COMMON_PROTOGROUPS = 1;
    public static final int SFAIL_ATTACK_MAXBV = 200;
    public static final int SFAIL_ATTACK_MINBV = 201;
    public static final int SFAIL_ATTACK_MAXUNITS = 202;
    public static final int SFAIL_ATTACK_MINUNITS = 203;
    public static final int SFAIL_ATTACK_MINSPEED = 204;
    public static final int SFAIL_ATTACK_MAXUNITTON = 205;
    public static final int SFAIL_ATTACK_MINUNITTON = 206;
    public static final int SFAIL_ATTACK_NOMEKS = 207;
    public static final int SFAIL_ATTACK_NOVEHS = 208;
    public static final int SFAIL_ATTACK_NOINF = 209;
    public static final int SFAIL_ATTACK_NONORMINF = 210;
    public static final int SFAIL_ATTACK_MAXARMYTON = 211;
    public static final int SFAIL_ATTACK_MINARMYTON = 212;
    public static final int SFAIL_ATTACK_MONEY = 213;
    public static final int SFAIL_ATTACK_INFLUENCE = 214;
    public static final int SFAIL_ATTACK_REWARD = 215;
    public static final int SFAIL_ATTACK_MAXRATING = 216;
    public static final int SFAIL_ATTACK_MINRATING = 217;
    public static final int SFAIL_ATTACK_MAXXP = 218;
    public static final int SFAIL_ATTACK_MINXP = 219;
    public static final int SFAIL_ATTACK_MAXGAMES = 220;
    public static final int SFAIL_ATTACK_MINGAMES = 221;
    public static final int SFAIL_ATTACK_OUTOFRANGE = 222;
    public static final int SFAIL_ATTACK_NOOPPONENT = 223;
    public static final int SFAIL_ATTACK_NOPLANDEF = 224;
    public static final int SFAIL_ATTACK_NOTYPEDEF = 225;
    public static final int SFAIL_ATTACK_SOLCANTATT = 226;
    public static final int SFAIL_ATTACK_NON_CONQ_A = 227;
    public static final int SFAIL_ATTACK_NEEDSFAC = 228;
    public static final int SFAIL_ATTACK_HASFAC = 229;
    public static final int SFAIL_ATTACK_MINUNITBV = 230;
    public static final int SFAIL_ATTACK_MAXUNITBV = 231;
    public static final int SFAIL_ATTACK_MAXSPREAD = 232;
    public static final int SFAIL_ATTACK_MINSPREAD = 233;
    public static final int SFAIL_ATTACK_FACTION = 234;
    public static final int SFAIL_DEFEND_MAXBV = 400;
    public static final int SFAIL_DEFEND_MINBV = 401;
    public static final int SFAIL_DEFEND_MAXUNITS = 402;
    public static final int SFAIL_DEFEND_MINUNITS = 403;
    public static final int SFAIL_DEFEND_MINSPEED = 404;
    public static final int SFAIL_DEFEND_MAXUNITTON = 405;
    public static final int SFAIL_DEFEND_MINUNITTON = 406;
    public static final int SFAIL_DEFEND_NOMEKS = 407;
    public static final int SFAIL_DEFEND_NOVEHS = 408;
    public static final int SFAIL_DEFEND_NOINF = 409;
    public static final int SFAIL_DEFEND_NONORMINF = 410;
    public static final int SFAIL_DEFEND_MAXARMYTON = 411;
    public static final int SFAIL_DEFEND_MINARMYTON = 412;
    public static final int SFAIL_DEFEND_MONEY = 413;
    public static final int SFAIL_DEFEND_INFLUENCE = 414;
    public static final int SFAIL_DEFEND_REWARD = 415;
    public static final int SFAIL_DEFEND_MAXRATING = 416;
    public static final int SFAIL_DEFEND_MINRATING = 417;
    public static final int SFAIL_DEFEND_MAXXP = 418;
    public static final int SFAIL_DEFEND_MINXP = 419;
    public static final int SFAIL_DEFEND_MAXGAMES = 420;
    public static final int SFAIL_DEFEND_MINGAMES = 421;
    public static final int SFAIL_DEFEND_SOLCANTDEF = 426;
    public static final int SFAIL_DEFEND_NON_CONQ_D = 427;
    public static final int SFAIL_DEFEND_MINUNITBV = 430;
    public static final int SFAIL_DEFEND_MAXUNITBV = 431;
    public static final int SFAIL_DEFEND_MAXSPREAD = 432;
    public static final int SFAIL_DEFEND_MINSPREAD = 433;
    public static final int SFAIL_DEFEND_FACTION = 434;

    public ShortValidator(OperationManager m) {
        this.manager = m;
    }

    public Vector genericAbleToDefend(SArmy checkArmy, SPlayer checkPlayer) {
        Vector<SArmy> result = new Vector<SArmy>();
        if (!checkPlayer.isActive()) {
            return result;
        }
        if (checkPlayer.getImmunetill() > System.currentTimeMillis()) {
            return result;
        }
        if (checkPlayer.getName().equalsIgnoreCase(checkArmy.getPlayerName())) {
            return result;
        }
        Vector<SArmy> possArmies = checkPlayer.getArmies();
        if (possArmies.size() <= 0) {
            return result;
        }
        for (SArmy army : possArmies) {
            if (!army.matches(checkArmy)) continue;
            result.add(army);
        }
        return result;
    }

    public ArrayList validateShortAttacker(SPlayer ap, SArmy aa, Operation o, SPlanet target, int longID) {
        ArrayList<Integer> failureReasons = new ArrayList<Integer>();
        if (target == null) {
            this.checkAttackerMilestones(failureReasons, ap, o);
            this.checkAttackerConstruction(failureReasons, aa, o);
        } else {
            this.checkAttackerRange(failureReasons, ap, o, target);
            this.checkAttackerMilestones(failureReasons, ap, o);
            this.checkAttackerCosts(failureReasons, ap, o);
            this.checkAttackerConstruction(failureReasons, aa, o);
            if (failureReasons.size() > 0) {
                return failureReasons;
            }
            if (aa.getOpponents() == null || aa.getOpponents().size() == 0) {
                failureReasons.add(223);
                return failureReasons;
            }
            ArrayList<SArmy> planetMatches = new ArrayList<SArmy>();
            ArrayList<SArmy> fullMatches = new ArrayList<SArmy>();
            for (SArmy currArmy : aa.getOpponents()) {
                SPlayer currPlayer = CampaignMain.cm.getPlayer(currArmy.getPlayerName());
                SHouse currHouse = currPlayer.getHouseFightingFor();
                if (target.getInfluence().getInfluence(currHouse.getId()) <= 0) continue;
                planetMatches.add(currArmy);
            }
            if (planetMatches.size() == 0) {
                failureReasons.add(224);
                return failureReasons;
            }
            for (SArmy currArmy : planetMatches) {
                SPlayer currPlayer = CampaignMain.cm.getPlayer(currArmy.getPlayerName());
                ArrayList defenderFails = this.validateShortDefender(currPlayer, currArmy, o);
                if (defenderFails.size() != 0) continue;
                fullMatches.add(currArmy);
            }
            if (fullMatches.size() == 0) {
                failureReasons.add(225);
                return failureReasons;
            }
            int freeShortID = this.manager.getFreeShortID();
            ShortOperation newOp = new ShortOperation(o.getName(), target, ap, aa, fullMatches, freeShortID, longID);
            this.manager.addShortOperation(newOp, ap, o);
        }
        return failureReasons;
    }

    private void checkAttackerRange(ArrayList failureReasons, SPlayer ap, Operation o, SPlanet target) {
        if (target instanceof NewbiePlanet) {
            return;
        }
        int ahID = ap.getHouseFightingFor().getId();
        int percToAttackOnWorld = Integer.parseInt(o.getValue("PercentageToAttackOnWorld"));
        if (target.getInfluence().getInfluence(ahID) >= percToAttackOnWorld) {
            return;
        }
        double opRange = Double.parseDouble(o.getValue("OperationRange"));
        double percToAttackOffWorld = Double.parseDouble(o.getValue("PercentageToAttackOffWorld"));
        for (SPlanet currP : CampaignMain.cm.getData().getAllPlanets()) {
            if (!((double)currP.getInfluence().getInfluence(ahID) >= percToAttackOffWorld) || !(currP.getPosition().distanceSq(target.getPosition()) <= opRange)) continue;
            return;
        }
        failureReasons.add(222);
        boolean mustHaveFac = Boolean.valueOf(o.getValue("OnlyAgainstFactoryWorlds"));
        boolean mustNotHaveFac = Boolean.valueOf(o.getValue("OnlyAgainstNonFactoryWorlds"));
        if (mustHaveFac && target.getFactoryCount() <= 0) {
            failureReasons.add(228);
        }
        if (mustNotHaveFac && target.getFactoryCount() >= 0) {
            failureReasons.add(229);
        }
    }

    private void checkAttackerMilestones(ArrayList failureReasons, SPlayer ap, Operation o) {
        boolean solCanAttack = Boolean.valueOf(o.getValue("AllowSOLToUse"));
        boolean nonConqCanAttack = Boolean.valueOf(o.getValue("AllowNonConqToUse"));
        if (ap.getMyHouse().isNewbieHouse() && !solCanAttack) {
            failureReasons.add(226);
        }
        if (!ap.getMyHouse().isConquerable() && !nonConqCanAttack) {
            failureReasons.add(227);
        }
        String allowed = o.getValue("LegalAttackFactions");
        String notAllowed = o.getValue("IllegalAttackFactions");
        if (allowed.trim().length() != 0 && allowed.indexOf(ap.getMyHouse().getName()) == -1) {
            failureReasons.add(234);
        } else if (notAllowed.trim().length() != 0 && allowed.indexOf(ap.getMyHouse().getName()) >= 0) {
            failureReasons.add(234);
        }
        if (ap.getRating() > Double.parseDouble(o.getValue("MaxAttackerRating"))) {
            failureReasons.add(216);
        }
        if (ap.getRating() < Double.parseDouble(o.getValue("MinAttackerRating"))) {
            failureReasons.add(217);
        }
        if (ap.getExperience() > Integer.parseInt(o.getValue("MaxAttackerXP"))) {
            failureReasons.add(218);
        }
        if (ap.getExperience() < Integer.parseInt(o.getValue("MinAttackerXP"))) {
            failureReasons.add(219);
        }
    }

    private void checkAttackerCosts(ArrayList failureReasons, SPlayer ap, Operation o) {
        if (ap.getMoney() < Integer.parseInt(o.getValue("AttackerCostMoney"))) {
            failureReasons.add(213);
        }
        if (ap.getInfluence() < Integer.parseInt(o.getValue("AttackerCostInfluence"))) {
            failureReasons.add(214);
        }
        if (ap.getReward() < Integer.parseInt(o.getValue("AttackerCostReward"))) {
            failureReasons.add(215);
        }
    }

    private void checkAttackerConstruction(ArrayList failureReasons, SArmy aa, Operation o) {
        if (aa.getBV() > Integer.parseInt(o.getValue("MaxAttackerBV"))) {
            failureReasons.add(new Integer(200));
        } else if (aa.getBV() < Integer.parseInt(o.getValue("MinAttackerBV"))) {
            failureReasons.add(new Integer(201));
        }
        if (aa.getUnits().size() > Integer.parseInt(o.getValue("MaxAttackerUnits"))) {
            failureReasons.add(new Integer(202));
        } else if (aa.getUnits().size() < Integer.parseInt(o.getValue("MinAttackerUnits"))) {
            failureReasons.add(new Integer(203));
        }
        int totalWeight = 0;
        int largestWeight = 0;
        int numProtoMeks = 0;
        int lowUnitBV = -1;
        int highUnitBV = -1;
        boolean hasMeks = false;
        boolean hasVehs = false;
        boolean hasInf = false;
        boolean normInf = false;
        boolean speedFail = false;
        boolean maxTonFail = false;
        boolean minTonFail = false;
        boolean maxBVFail = false;
        boolean minBVFail = false;
        for (SUnit sUnit : aa.getUnits()) {
            int type;
            if (sUnit.getType() == 3) {
                ++numProtoMeks;
            }
            int currWeight = (int)sUnit.getEntity().getWeight();
            totalWeight += currWeight;
            if (currWeight > largestWeight) {
                largestWeight = currWeight;
            }
            if (sUnit.getType() == 0) {
                hasMeks = true;
            } else if (sUnit.getType() == 1) {
                hasVehs = true;
            } else if (sUnit.getType() == 2 || sUnit.getType() == 4 || sUnit.getType() == 3) {
                hasInf = true;
                if (!(sUnit.getEntity() instanceof BattleArmor) && !(sUnit.getEntity() instanceof Protomech)) {
                    normInf = true;
                }
            }
            if (!speedFail) {
                int walkMP = sUnit.getEntity().getWalkMP();
                int jumpMP = sUnit.getEntity().getJumpMP();
                if (walkMP < Integer.parseInt(o.getValue("MinAttackerWalk")) && jumpMP < Integer.parseInt(o.getValue("MinAttackerJump"))) {
                    speedFail = true;
                }
            }
            if (currWeight > Integer.parseInt(o.getValue("MaxAttackerUnitTonnage"))) {
                maxTonFail = true;
            } else if (currWeight < Integer.parseInt(o.getValue("MinAttackerUnitTonnage"))) {
                minTonFail = true;
            }
            int currBV = sUnit.getBV();
            if (currBV < Integer.parseInt(o.getValue("MinAttackerUnitBV"))) {
                minBVFail = true;
            } else if (currBV > Integer.parseInt(o.getValue("MaxAttackerUnitBV"))) {
                maxBVFail = true;
            }
            if ((type = sUnit.getType()) == 1 && !Boolean.valueOf(o.getValue("CountVehsForSpread")).booleanValue() || type == 3 && !Boolean.valueOf(o.getValue("CountProtosForSpread")).booleanValue() || (type == 4 || type == 2) && !Boolean.valueOf(o.getValue("CountInfForSpread")).booleanValue()) continue;
            if (currBV < lowUnitBV || lowUnitBV == -1) {
                lowUnitBV = currBV;
                continue;
            }
            if (currBV <= highUnitBV && highUnitBV != -1) continue;
            highUnitBV = currBV;
        }
        if (hasMeks && !Boolean.valueOf(o.getValue("AttackerAllowedMeks")).booleanValue()) {
            failureReasons.add(new Integer(207));
        }
        if (hasVehs && !Boolean.valueOf(o.getValue("AttackerAllowedVehs")).booleanValue()) {
            failureReasons.add(new Integer(208));
        }
        if (hasInf && !Boolean.valueOf(o.getValue("AttackerAllowedInf")).booleanValue()) {
            if (Boolean.valueOf(o.getValue("PoweredInfAllowed")).booleanValue() && normInf) {
                failureReasons.add(new Integer(210));
            } else {
                failureReasons.add(new Integer(209));
            }
        }
        int n = Integer.parseInt(CampaignMain.cm.getConfig("InfProtoClusterCount"));
        if (numProtoMeks > 0 && numProtoMeks % n != 0) {
            failureReasons.add(new Integer(1));
        }
        if (speedFail) {
            failureReasons.add(new Integer(204));
        }
        if (maxTonFail) {
            failureReasons.add(new Integer(205));
        }
        if (minTonFail) {
            failureReasons.add(new Integer(206));
        }
        if (maxBVFail) {
            failureReasons.add(new Integer(231));
        }
        if (minBVFail) {
            failureReasons.add(new Integer(230));
        }
        if (totalWeight > Integer.parseInt(o.getValue("MaxTotalAttackerTonnage"))) {
            failureReasons.add(new Integer(211));
        } else if (totalWeight < Integer.parseInt(o.getValue("MinTotalAttackerTonnage"))) {
            failureReasons.add(new Integer(212));
        }
        int maxAllowedSpread = Integer.parseInt(o.getValue("MaxAttackerUnitBVSpread"));
        int minAllowedSpread = Integer.parseInt(o.getValue("MinAttackerUnitBVSpread"));
        if (maxAllowedSpread > 0 && highUnitBV - lowUnitBV > maxAllowedSpread) {
            failureReasons.add(232);
        }
        if (minAllowedSpread > 0 && highUnitBV - lowUnitBV < minAllowedSpread) {
            failureReasons.add(233);
        }
    }

    public ArrayList validateShortDefender(SPlayer dp, SArmy da, Operation o) {
        ArrayList failureReasons = new ArrayList();
        this.checkDefenderMilestones(failureReasons, dp, o);
        this.checkDefenderCosts(failureReasons, dp, o);
        this.checkDefenderConstruction(failureReasons, da, o);
        return failureReasons;
    }

    private void checkDefenderMilestones(ArrayList failureReasons, SPlayer dp, Operation o) {
        boolean solCanDefend = Boolean.valueOf(o.getValue("AllowAgainstSOL"));
        boolean nonConqCanDefend = Boolean.valueOf(o.getValue("AllowAgainstNonConq"));
        if (dp.getMyHouse().isNewbieHouse() && !solCanDefend) {
            failureReasons.add(426);
        }
        if (!dp.getMyHouse().isConquerable() && !nonConqCanDefend) {
            failureReasons.add(427);
        }
        String allowed = o.getValue("LegalDefendFactions");
        String notAllowed = o.getValue("IllegalDefendFactions");
        if (allowed.trim().length() != 0 && allowed.indexOf(dp.getMyHouse().getName()) == -1) {
            failureReasons.add(434);
        } else if (notAllowed.trim().length() != 0 && allowed.indexOf(dp.getMyHouse().getName()) >= 0) {
            failureReasons.add(434);
        }
        if (dp.getRating() > Double.parseDouble(o.getValue("MaxDefenderRating"))) {
            failureReasons.add(416);
        }
        if (dp.getRating() < Double.parseDouble(o.getValue("MinDefenderRating"))) {
            failureReasons.add(417);
        }
        if (dp.getExperience() > Integer.parseInt(o.getValue("MaxDefenderXP"))) {
            failureReasons.add(418);
        }
        if (dp.getExperience() < Integer.parseInt(o.getValue("MinDefenderXP"))) {
            failureReasons.add(419);
        }
    }

    private void checkDefenderCosts(ArrayList failureReasons, SPlayer dp, Operation o) {
        if (dp.getMoney() < Integer.parseInt(o.getValue("DefenderCostMoney"))) {
            failureReasons.add(413);
        }
        if (dp.getInfluence() < Integer.parseInt(o.getValue("DefenderCostInfluence"))) {
            failureReasons.add(414);
        }
        if (dp.getReward() < Integer.parseInt(o.getValue("DefenderCostReward"))) {
            failureReasons.add(415);
        }
    }

    private void checkDefenderConstruction(ArrayList failureReasons, SArmy da, Operation o) {
        if (da.getBV() > Integer.parseInt(o.getValue("MaxDefenderBV"))) {
            failureReasons.add(new Integer(400));
        } else if (da.getBV() < Integer.parseInt(o.getValue("MinDefenderBV"))) {
            failureReasons.add(new Integer(401));
        }
        if (da.getUnits().size() > Integer.parseInt(o.getValue("MaxDefenderUnits"))) {
            failureReasons.add(new Integer(402));
        } else if (da.getUnits().size() < Integer.parseInt(o.getValue("MinDefenderUnits"))) {
            failureReasons.add(new Integer(403));
        }
        int totalWeight = 0;
        int largestWeight = 0;
        int numProtoMeks = 0;
        int lowUnitBV = -1;
        int highUnitBV = -1;
        boolean hasMeks = false;
        boolean hasVehs = false;
        boolean hasInf = false;
        boolean normInf = false;
        boolean speedFail = false;
        boolean maxTonFail = false;
        boolean minTonFail = false;
        boolean maxBVFail = false;
        boolean minBVFail = false;
        for (SUnit sUnit : da.getUnits()) {
            int type;
            if (sUnit.getType() == 3) {
                ++numProtoMeks;
            }
            int currWeight = (int)sUnit.getEntity().getWeight();
            totalWeight += currWeight;
            if (currWeight > largestWeight) {
                largestWeight = currWeight;
            }
            if (sUnit.getType() == 0) {
                hasMeks = true;
            } else if (sUnit.getType() == 1) {
                hasVehs = true;
            } else if (sUnit.getType() == 2 || sUnit.getType() == 4 || sUnit.getType() == 3) {
                hasInf = true;
                if (!(sUnit.getEntity() instanceof BattleArmor) && !(sUnit.getEntity() instanceof Protomech)) {
                    normInf = true;
                }
            }
            if (!speedFail) {
                int walkMP = sUnit.getEntity().getWalkMP();
                int jumpMP = sUnit.getEntity().getJumpMP();
                if (walkMP < Integer.parseInt(o.getValue("MinDefenderWalk")) && jumpMP < Integer.parseInt(o.getValue("MinDefenderJump"))) {
                    speedFail = true;
                }
            }
            if (currWeight > Integer.parseInt(o.getValue("MaxDefenderUnitTonnage"))) {
                maxTonFail = true;
            } else if (currWeight < Integer.parseInt(o.getValue("MinDefenderUnitTonnage"))) {
                minTonFail = true;
            }
            int currBV = sUnit.getBV();
            if (currBV < Integer.parseInt(o.getValue("MinDefenderUnitBV"))) {
                minBVFail = true;
            } else if (currBV > Integer.parseInt(o.getValue("MaxDefenderUnitBV"))) {
                maxBVFail = true;
            }
            if ((type = sUnit.getType()) == 1 && !Boolean.valueOf(o.getValue("CountVehsForSpread")).booleanValue() || type == 3 && !Boolean.valueOf(o.getValue("CountProtosForSpread")).booleanValue() || (type == 4 || type == 2) && !Boolean.valueOf(o.getValue("CountInfForSpread")).booleanValue()) continue;
            if (currBV < lowUnitBV || lowUnitBV == -1) {
                lowUnitBV = currBV;
                continue;
            }
            if (currBV <= highUnitBV && highUnitBV != -1) continue;
            highUnitBV = currBV;
        }
        if (hasMeks && !Boolean.valueOf(o.getValue("DefenderAllowedMeks")).booleanValue()) {
            failureReasons.add(new Integer(407));
        }
        if (hasVehs && !Boolean.valueOf(o.getValue("DefenderAllowedVehs")).booleanValue()) {
            failureReasons.add(new Integer(408));
        }
        if (hasInf && !Boolean.valueOf(o.getValue("DefenderAllowedInf")).booleanValue()) {
            if (Boolean.valueOf(o.getValue("PoweredInfAllowed")).booleanValue() && normInf) {
                failureReasons.add(new Integer(410));
            } else {
                failureReasons.add(new Integer(409));
            }
        }
        int n = Integer.parseInt(CampaignMain.cm.getConfig("InfProtoClusterCount"));
        if (numProtoMeks > 0 && numProtoMeks % n != 0) {
            failureReasons.add(new Integer(1));
        }
        if (speedFail) {
            failureReasons.add(new Integer(404));
        }
        if (maxTonFail) {
            failureReasons.add(new Integer(405));
        } else if (minTonFail) {
            failureReasons.add(new Integer(406));
        }
        if (maxBVFail) {
            failureReasons.add(new Integer(431));
        } else if (minBVFail) {
            failureReasons.add(new Integer(430));
        }
        if (totalWeight > Integer.parseInt(o.getValue("MaxTotalDefenderTonnage"))) {
            failureReasons.add(new Integer(411));
        } else if (totalWeight < Integer.parseInt(o.getValue("MinTotalDefenderTonnage"))) {
            failureReasons.add(new Integer(412));
        }
        int maxAllowedSpread = Integer.parseInt(o.getValue("MaxDefenderUnitBVSpread"));
        int minAllowedSpread = Integer.parseInt(o.getValue("MinDefenderUnitBVSpread"));
        if (maxAllowedSpread > 0 && highUnitBV - lowUnitBV > maxAllowedSpread) {
            failureReasons.add(432);
        }
        if (minAllowedSpread > 0 && highUnitBV - lowUnitBV < minAllowedSpread) {
            failureReasons.add(433);
        }
    }

    public void checkOperations(SArmy a, boolean display, TreeMap<String, Operation> operations) {
        SPlayer p = CampaignMain.cm.getPlayer(a.getPlayerName());
        if (a == null || p == null) {
            return;
        }
        if (p.getActivityStatus() < 2) {
            return;
        }
        ArrayList<String> addNames = new ArrayList<String>();
        ArrayList<String> removeNames = new ArrayList<String>();
        for (Operation currType : operations.values()) {
            ArrayList failures = this.validateShortAttacker(p, a, currType, null, -1);
            if (failures.size() > 0) {
                String removal = a.getLegalOperations().remove(currType.getName());
                if (removal == null) continue;
                removeNames.add(removal);
                continue;
            }
            if (a.getLegalOperations().put(currType.getName(), currType.getName()) != null) continue;
            addNames.add(currType.getName());
        }
        if (addNames.size() > 0 || removeNames.size() > 0) {
            String toSend = "PL|UOE|" + a.getID() + "*";
            for (String currName : addNames) {
                toSend = toSend + "a*" + currName + "*";
            }
            for (String currName : removeNames) {
                toSend = toSend + "r*" + currName + "*";
            }
            CampaignMain.cm.toUser(toSend, p.getName(), false);
            if (display) {
                String back;
                String front;
                int lastComma;
                Iterator i;
                String addSend = "Army #" + a.getID();
                String removeSend = "Army #" + a.getID();
                if (addNames.size() == 1) {
                    addSend = addSend + " has gained access to an attack: " + (String)addNames.get(0) + ".";
                    CampaignMain.cm.toUser(addSend, p.getName(), true);
                } else if (addNames.size() > 1) {
                    addSend = addSend + " has gained access to the following attacks: ";
                    i = addNames.iterator();
                    while (i.hasNext()) {
                        addSend = addSend + i.next();
                        if (!i.hasNext()) continue;
                        addSend = addSend + ", ";
                    }
                    lastComma = addSend.lastIndexOf(", ");
                    if (lastComma >= 0) {
                        front = addSend.substring(0, lastComma);
                        back = addSend.substring(lastComma + 2, addSend.length());
                        addSend = front + " and " + back + ".";
                    }
                    CampaignMain.cm.toUser(addSend, p.getName(), true);
                }
                if (removeNames.size() == 1) {
                    removeSend = removeSend + " has lost access to an attack: " + (String)removeNames.get(0) + ".";
                    CampaignMain.cm.toUser(removeSend, p.getName(), true);
                } else if (removeNames.size() > 1) {
                    removeSend = removeSend + " has lost access to the following attacks: ";
                    i = removeNames.iterator();
                    while (i.hasNext()) {
                        removeSend = removeSend + i.next();
                        if (!i.hasNext()) continue;
                        removeSend = removeSend + ", ";
                    }
                    lastComma = removeSend.lastIndexOf(", ");
                    if (lastComma >= 0) {
                        front = removeSend.substring(0, lastComma);
                        back = removeSend.substring(lastComma + 2, removeSend.length());
                        removeSend = front + " and " + back + ".";
                    }
                    CampaignMain.cm.toUser(removeSend, p.getName(), true);
                }
            }
        }
    }

    public String failuresToString(ArrayList failList) {
        String s = "";
        if (failList.size() == 1) {
            s = s + " because " + this.decodeFailure((Integer)failList.get(0)) + ".";
            return s;
        }
        s = s + "because:<br>";
        Iterator i = failList.iterator();
        while (i.hasNext()) {
            s = s + "- " + this.decodeFailure((Integer)i.next());
            if (!i.hasNext()) continue;
            s = s + "<br>";
        }
        return s;
    }

    private String decodeFailure(Integer code) {
        int decoded = code;
        switch (decoded) {
            case 1: {
                return " the army does not contain a legal number of protomechs. Protos must be in multiples of " + CampaignMain.cm.getConfig("InfProtoClusterCount");
            }
            case 200: {
                return " the army the army is over the BV limit for this type of attack";
            }
            case 201: {
                return " the army is under the BV limit for this type of attack";
            }
            case 202: {
                return " the army has too many units";
            }
            case 203: {
                return " the army does not have enough units";
            }
            case 204: {
                return " the army contains a unit which is too slow";
            }
            case 205: {
                return " the army contains a unit which is too heavy";
            }
            case 206: {
                return " the army contains a unit which is too light";
            }
            case 207: {
                return " the army contains meks, which may not participate in this type of attack";
            }
            case 208: {
                return " the army contains vehicles, which may not participate in this type of attack";
            }
            case 209: {
                return " the army contains infantry, which may not participate in this type of attack";
            }
            case 210: {
                return " the army contains unarmored infantry, which may not participate in this type of attack";
            }
            case 211: {
                return " the army is over the tonnage maximum for this type of attack";
            }
            case 212: {
                return " the army is under the tonnage minimum for this type of attack";
            }
            case 213: {
                return " you cannot afford the attack";
            }
            case 214: {
                return " you do not have enough influence for this type of attack";
            }
            case 215: {
                return " you do not have enough RP for this type of attack";
            }
            case 216: {
                return " your rating is too high for this type of attack";
            }
            case 217: {
                return " your rating is too low for this type of attack";
            }
            case 218: {
                return " you have too much experience for this type of attack";
            }
            case 219: {
                return " you have too little experience for this type of attack";
            }
            case 220: {
                return " you're played too many games to perform this type of attack";
            }
            case 221: {
                return " you've played too few games to perform this type of attack";
            }
            case 222: {
                return " the target world is out of range";
            }
            case 223: {
                return " no active opponents may fight against this Army";
            }
            case 224: {
                return " no active opponents may defend the target world";
            }
            case 225: {
                return " no active opponents may defend this type of attack";
            }
            case 226: {
                return " players in the training faction are not allowed to use this type of attack";
            }
            case 227: {
                return " players in non-conquer factions are not allowed to use this type of attack";
            }
            case 228: {
                return " the target has no factory";
            }
            case 229: {
                return " this type of attack may only be performed on worlds without factories";
            }
            case 230: {
                return " the army contains a unit with a BV too low for this type of attack";
            }
            case 231: {
                return " the army contains a unit with a BV too high for this type of attack";
            }
            case 232: {
                return " the BV difference between the largest and smallest counted units is too large";
            }
            case 233: {
                return " the BV difference between the largest and smallest counted units is too small";
            }
            case 234: {
                return " your faction may not make this type of attack";
            }
            case 400: {
                return " the army is over the BV limit for this type of defense";
            }
            case 401: {
                return " the army is under the BV limit for this type of defense";
            }
            case 402: {
                return " the army has too many units";
            }
            case 403: {
                return " the army does not have enough units";
            }
            case 404: {
                return " the army contains a unit which is too slow";
            }
            case 405: {
                return " the army contains a unit which is too heavy";
            }
            case 406: {
                return " the army contains a unit which is too light";
            }
            case 407: {
                return " the army contains meks, which may not participate in this type of defense";
            }
            case 408: {
                return " the army contains vehicles, which may not participate in this type of defense";
            }
            case 409: {
                return " the army contains infantry, which may not participate in this type of defense";
            }
            case 410: {
                return " the army contains unarmored infantry, which may not participate in this type of defense";
            }
            case 411: {
                return " the army is over the tonnage maximum for this type of defense";
            }
            case 412: {
                return " the army is under the tonnage minimum for this type of defense";
            }
            case 413: {
                return " you cannot afford the defense";
            }
            case 414: {
                return " you do not have enough influence for this type of defense";
            }
            case 415: {
                return " you do not have enough RP for this type of defense";
            }
            case 416: {
                return " your rating is too high for this type of defense";
            }
            case 417: {
                return " your rating is too low for this type of defense";
            }
            case 418: {
                return " you have too much experience for this type of defense";
            }
            case 419: {
                return " you have too little experience for this type of defense";
            }
            case 420: {
                return " you're played too many games to perform this type of defense";
            }
            case 421: {
                return " you've played too few games to perform this type of defense";
            }
            case 426: {
                return " players in the training faction are not allowed to defend against this type of attack";
            }
            case 427: {
                return " players in non-conquer factions are not allowed to defend against this type of attack";
            }
            case 430: {
                return " the army contains a unit with a BV too low for this type of defense";
            }
            case 431: {
                return " the army contains a unit with a BV too high for this type of defense";
            }
            case 432: {
                return " the BV difference between the largest and smallest counted units is too large";
            }
            case 433: {
                return " the BV difference between the largest and smallest counted units is too small";
            }
            case 434: {
                return " your faction may not defend this type of attack";
            }
        }
        return "";
    }
}

