/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.pilot;

import common.campaign.pilot.Pilot;
import java.util.Iterator;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.pilot.skills.AstechSkill;
import server.campaign.pilot.skills.SPilotSkill;
import server.campaign.pilot.skills.TraitSkill;
import server.campaign.pilot.skills.WeaponSpecialistSkill;

public class SPilot
extends Pilot {
    private int originalID;
    private int pickedUpID;
    private boolean death = false;

    public SPilot(String name, int gunnery, int piloting) {
        super(name, gunnery, piloting);
    }

    public SPilot() {
    }

    public String checkForPilotSkillImprovement(SUnit unit, SPlayer owner) {
        int bestGunnery = Integer.parseInt(CampaignMain.cm.getConfig("BestGunnerySkill"));
        int bestPiloting = Integer.parseInt(CampaignMain.cm.getConfig("BestPilotingSkill"));
        int bestTotal = Integer.parseInt(CampaignMain.cm.getConfig("BestTotalPilot"));
        int startingSkillAmount = 10;
        int currentSkillAmount = this.getGunnery() + this.getPiloting();
        int differential = this.getGunnery() - this.getPiloting();
        if (this.getSkills().has(5)) {
            ++differential;
        }
        if (this.getSkills().has(6)) {
            --differential;
        }
        int oldBV = unit.getBV();
        int baseRollToLevel = Integer.parseInt(CampaignMain.cm.getConfig("BaseRollToLevel"));
        int rollMultiplier = Integer.parseInt(CampaignMain.cm.getConfig("MultiplierPerPreviousLevel"));
        int multiplier = startingSkillAmount - currentSkillAmount;
        if (multiplier < 1) {
            multiplier = 1;
        }
        int dieSize = 0;
        dieSize = rollMultiplier <= 0 ? baseRollToLevel : baseRollToLevel * rollMultiplier * multiplier;
        boolean pilotIsElite = false;
        if (this.getGunnery() <= bestGunnery && this.getPiloting() <= bestPiloting) {
            pilotIsElite = true;
        }
        if (this.getGunnery() + this.getPiloting() <= bestTotal) {
            pilotIsElite = true;
        }
        boolean shouldLevelUp = false;
        if (!pilotIsElite) {
            boolean useRandomLevels = Boolean.valueOf(CampaignMain.cm.getConfig("UseRandomPilotLevelups"));
            if (!useRandomLevels && this.getExperience() >= dieSize) {
                shouldLevelUp = true;
            } else if (this.getExperience() >= CampaignMain.cm.getR().nextInt(dieSize)) {
                shouldLevelUp = true;
            }
        }
        boolean pilotsCanGainSkills = Boolean.valueOf(CampaignMain.cm.getConfig("PilotSkills"));
        boolean shouldGainPilotSkill = false;
        if (!shouldLevelUp && pilotsCanGainSkills) {
            int dieRoll;
            int chanceToGainSkill = Integer.parseInt(CampaignMain.cm.getConfig("SkillLevelChance"));
            if (unit.getPilot().getSkills().has(18)) {
                chanceToGainSkill += 5;
            }
            if ((dieRoll = CampaignMain.cm.getR().nextInt(100) + 1) < chanceToGainSkill) {
                shouldGainPilotSkill = true;
            }
        }
        if (shouldLevelUp || shouldGainPilotSkill && !pilotIsElite) {
            this.setExperience(0);
        }
        if (shouldLevelUp) {
            int random = CampaignMain.cm.getR().nextInt(10);
            boolean levelGunnery = false;
            boolean levelPiloting = false;
            if (differential > 0) {
                levelGunnery = true;
            } else if (differential < 0) {
                levelPiloting = true;
            } else if (random < 3) {
                levelPiloting = true;
            } else {
                levelGunnery = true;
            }
            if (levelGunnery && this.getGunnery() <= bestGunnery) {
                levelGunnery = false;
                if (this.getPiloting() > bestPiloting) {
                    levelPiloting = true;
                } else {
                    pilotIsElite = true;
                }
            }
            if (levelPiloting && this.getPiloting() <= bestPiloting) {
                levelPiloting = false;
                if (this.getGunnery() > bestGunnery) {
                    levelGunnery = true;
                } else {
                    pilotIsElite = true;
                }
            }
            if (levelGunnery) {
                this.setGunnery(this.getGunnery() - 1);
            } else if (levelPiloting) {
                this.setPiloting(this.getPiloting() - 1);
            }
            if (levelGunnery || levelPiloting) {
                unit.setPilot(this, false);
                return " and advanced a level. " + this.getName() + " is now " + this.getGunnery() + "/" + this.getPiloting() + " [Old BV: " + oldBV + "/New BV: " + unit.getBV() + "]";
            }
        }
        if (shouldGainPilotSkill) {
            SPilotSkill skill = CampaignMain.cm.getRandomSkill(this, unit.getType());
            if (skill instanceof WeaponSpecialistSkill) {
                ((WeaponSpecialistSkill)skill).assignWeapon(unit.getEntity(), this);
            } else if (skill instanceof TraitSkill) {
                ((TraitSkill)skill).assignTrait(this);
            }
            skill.addToPilot(this);
            skill.modifyPilot(this);
            unit.setPilot(this, false);
            int newBV = unit.getBV();
            if (skill instanceof AstechSkill) {
                CampaignMain.cm.toUser("PL|SF|" + owner.getFreeBays(), owner.getName(), false);
            }
            String toSend = ". " + this.getName() + " gained the " + skill.getName() + " skill";
            if (newBV != oldBV) {
                toSend = toSend + " [Old BV: " + oldBV + "/New BV: " + newBV + "]";
            }
            return toSend;
        }
        if (pilotIsElite) {
            return " but could not level up because " + this.getName() + " is elite";
        }
        return "";
    }

    public String toFileFormat(String delimiter, boolean toPlayer) {
        StringBuffer result = new StringBuffer();
        result.append(this.getName());
        result.append(delimiter);
        result.append(this.getExperience());
        result.append(delimiter);
        result.append(this.getGunnery());
        result.append(delimiter);
        result.append(this.getPiloting());
        result.append(delimiter);
        result.append(this.getSkills().size());
        result.append(delimiter);
        Iterator it = this.getSkills().getSkillIterator();
        while (it.hasNext()) {
            SPilotSkill sk = (SPilotSkill)it.next();
            result.append(sk.getId());
            result.append(delimiter);
            if (toPlayer) {
                result.append(sk.getName());
                result.append(delimiter);
            }
            result.append(sk.getLevel());
            result.append(delimiter);
            if (sk instanceof WeaponSpecialistSkill) {
                result.append(this.getWeapon());
                result.append(delimiter);
            }
            if (!(sk instanceof TraitSkill)) continue;
            result.append(this.getTraitName());
            result.append(delimiter);
        }
        result.append(this.getKills());
        result.append(delimiter);
        result.append(this.getCurrentFaction());
        result.append(delimiter);
        return result.toString();
    }

    public void fromFileFormat(String s, String delimiter) {
        StringTokenizer ST = new StringTokenizer(s, delimiter);
        if (ST.countTokens() < 1) {
            this.setName("NULL");
            return;
        }
        this.setName(ST.nextToken());
        this.setExperience(Integer.parseInt(ST.nextToken()));
        this.setGunnery(Integer.parseInt(ST.nextToken()));
        this.setPiloting(Integer.parseInt(ST.nextToken()));
        int skills = Integer.parseInt(ST.nextToken());
        for (int i = 0; i < skills; ++i) {
            SPilotSkill skill = CampaignMain.cm.getPilotSkill(Integer.parseInt(ST.nextToken()));
            skill.setLevel(Integer.parseInt(ST.nextToken()));
            if (skill instanceof WeaponSpecialistSkill) {
                this.setWeapon(ST.nextToken());
            }
            if (skill instanceof TraitSkill) {
                String traitName = ST.nextToken();
                if (traitName.equalsIgnoreCase("none")) {
                    ((TraitSkill)skill).assignTrait(this);
                } else {
                    this.setTraitName(traitName);
                }
            }
            skill.addToPilot(this);
            skill.modifyPilot(this);
        }
        if (ST.hasMoreElements()) {
            this.setKills(Integer.parseInt(ST.nextToken()));
        }
        if (ST.hasMoreElements()) {
            this.setCurrentFaction(ST.nextToken());
        }
    }

    public int getOriginalID() {
        return this.originalID;
    }

    public void setOriginalID(int originalID) {
        this.originalID = originalID;
    }

    public int getPickedUpID() {
        return this.pickedUpID;
    }

    public void setPickedUpID(int pickedUpID) {
        this.pickedUpID = pickedUpID;
    }

    public void setDeath(boolean death) {
        this.death = death;
    }

    public boolean isDead() {
        return this.death;
    }

    public static SPilot getMekWarrior(int originalID, int pickedUpId) {
        SPilot mw = new SPilot();
        mw.setOriginalID(originalID);
        mw.setPickedUpID(pickedUpId);
        return mw;
    }
}

