/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.pilot.skills;

import common.MegaMekPilotOption;
import common.Unit;
import common.campaign.pilot.Pilot;
import megamek.common.Entity;
import server.MMServ;
import server.campaign.CampaignMain;
import server.campaign.pilot.skills.SPilotSkill;

public class ManeuveringAceSkill
extends SPilotSkill {
    public ManeuveringAceSkill(int id) {
        super(id, "Maneuvering Ace", "MA");
    }

    public ManeuveringAceSkill() {
    }

    public int getChance(int unitType, Pilot pilot) {
        if (pilot.getSkills().has(this)) {
            return 0;
        }
        String chance = "chancefor" + this.getAbbreviation() + "for" + Unit.getTypeClassDesc(unitType);
        return Integer.parseInt(CampaignMain.cm.getConfig(chance));
    }

    public void modifyPilot(Pilot pilot) {
        pilot.addMegamekOption(new MegaMekPilotOption("maneuvering_ace", true));
    }

    public int getBVMod(Entity unit) {
        double topSpeed = unit.getRunMP();
        double baseBVMod = Double.parseDouble(CampaignMain.cm.getConfig("ManeuveringAceBaseBVMod"));
        double speedRating = Double.parseDouble(CampaignMain.cm.getConfig("ManeuveringAceSpeedRating"));
        try {
            double total = topSpeed / speedRating;
            return (int)(total *= baseBVMod);
        }
        catch (Exception ex) {
            MMServ.mmlog.errLog(ex);
            return 0;
        }
    }
}

