/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.pilot.skills;

import common.MegaMekPilotOption;
import common.Unit;
import common.campaign.pilot.Pilot;
import java.util.Enumeration;
import megamek.common.Entity;
import megamek.common.MiscType;
import megamek.common.Mounted;
import server.campaign.CampaignMain;
import server.campaign.pilot.skills.SPilotSkill;

public class MeleeSpecialistSkill
extends SPilotSkill {
    public MeleeSpecialistSkill(int id) {
        super(id, "Melee Specialist", "MS");
    }

    public MeleeSpecialistSkill() {
    }

    public void modifyPilot(Pilot p) {
        p.addMegamekOption(new MegaMekPilotOption("melee_specialist", true));
    }

    public int getBVMod(Entity unit) {
        double tonnage = unit.getWeight();
        double numberOfHatchets = 0.0;
        double hatchetMod = Double.parseDouble(CampaignMain.cm.getConfig("HatchetRating"));
        double baseBV = Double.parseDouble(CampaignMain.cm.getConfig("MeleeSpecialistBaseBVMod"));
        Enumeration miscList = unit.getMisc();
        while (miscList.hasMoreElements()) {
            Mounted miscItem = (Mounted)miscList.nextElement();
            MiscType misc = (MiscType)miscItem.getType();
            if (!misc.hasFlag(4) && !misc.hasFlag(8)) continue;
            numberOfHatchets += 1.0;
        }
        double total = baseBV * (tonnage / 10.0) + hatchetMod * numberOfHatchets;
        return (int)total;
    }

    public int getChance(int unitType, Pilot p) {
        if (p.getSkills().has(this)) {
            return 0;
        }
        if (unitType != 0) {
            return 0;
        }
        String chance = "chancefor" + this.getAbbreviation() + "for" + Unit.getTypeClassDesc(unitType);
        return Integer.parseInt(CampaignMain.cm.getConfig(chance));
    }
}

