/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.pilot.skills;

import common.MegaMekPilotOption;
import common.Unit;
import common.campaign.pilot.Pilot;
import java.util.Enumeration;
import megamek.common.AmmoType;
import megamek.common.Entity;
import megamek.common.Mounted;
import server.campaign.CampaignMain;
import server.campaign.pilot.skills.SPilotSkill;

public class PainResistanceSkill
extends SPilotSkill {
    public PainResistanceSkill() {
    }

    public PainResistanceSkill(int id) {
        super(id, "Pain Resistance", "PR");
    }

    public void modifyPilot(Pilot p) {
        super.addToPilot(p);
        p.addMegamekOption(new MegaMekPilotOption("pain_resistance", true));
        p.setBvMod(p.getBVMod() + 0.01);
    }

    public int getChance(int unitType, Pilot p) {
        if (p.getSkills().has(this)) {
            return 0;
        }
        if (unitType != 0) {
            return 0;
        }
        String chance = "chancefor" + this.getAbbreviation() + "for" + Unit.getTypeClassDesc(unitType);
        return Integer.parseInt(CampaignMain.cm.getConfig(chance));
    }

    public int getBVMod(Entity unit) {
        int amountOfAmmo = 0;
        int PainResistanceBVBaseMod = Integer.parseInt(CampaignMain.cm.getConfig("PainResistanceBaseBVMod"));
        Enumeration ammoList = unit.getAmmo();
        while (ammoList.hasMoreElements()) {
            Mounted ammoType = (Mounted)ammoList.nextElement();
            AmmoType ammo = (AmmoType)ammoType.getType();
            if (ammo.getAmmoType() == 6 || ammo.getAmmoType() == 22 || ammo.getAmmoType() == 21) continue;
            ++amountOfAmmo;
        }
        Enumeration weaponsList = unit.getWeapons();
        while (weaponsList.hasMoreElements()) {
            Mounted weapon = (Mounted)weaponsList.nextElement();
            if (weapon.getName().indexOf("Gauss Rifle") == -1) continue;
            ++amountOfAmmo;
        }
        return amountOfAmmo * PainResistanceBVBaseMod;
    }
}

