/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.util;

import java.io.File;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import server.MMServ;
import server.campaign.CampaignMain;

public class ExclusionList {
    public static final int NO_EXCLUSION = 0;
    public static final int PLAYER_EXCLUDED = 1;
    public static final int ADMIN_EXCLUDED = 2;
    private int maxSize = Integer.parseInt(CampaignMain.cm.getConfig("NoPlayListSize"));
    private boolean adminListCountsForCap = Boolean.valueOf(CampaignMain.cm.getConfig("NoPlaysFromAdminsCountForMax"));
    private String owner = "";
    private Vector playerExcludes = new Vector(this.maxSize);
    private Vector adminExcludes = new Vector();

    public void setOwnerName(String ownerName) {
        this.owner = ownerName;
    }

    public void addExclude(boolean fromAdmin, String name) {
        MMServ.mmlog.mainLog("** adding exclude: " + fromAdmin + ", " + name);
        if (fromAdmin) {
            this.adminExcludes.add(name.toLowerCase());
        } else {
            this.playerExcludes.add(name.toLowerCase());
        }
    }

    public int checkExclude(String name) {
        if (this.playerExcludes.contains(name.toLowerCase())) {
            return 1;
        }
        if (this.adminExcludes.contains(name.toLowerCase())) {
            return 2;
        }
        return 0;
    }

    public void removeExclude(boolean fromAdmin, String name) {
        if (fromAdmin) {
            this.playerExcludes.remove(name.toLowerCase());
            this.adminExcludes.remove(name.toLowerCase());
        } else {
            this.playerExcludes.remove(name.toLowerCase());
        }
    }

    private void validateExcludes() {
        boolean playerExists;
        String currName;
        Iterator e = this.adminExcludes.iterator();
        while (e.hasNext()) {
            currName = (String)e.next();
            playerExists = new File("./campaign/players/" + currName + ".dat").exists();
            if (playerExists) continue;
            e.remove();
            CampaignMain.cm.toUser(currName + " has left the campaign. No-Play list updated.", this.owner, true);
        }
        e = this.playerExcludes.iterator();
        while (e.hasNext()) {
            currName = (String)e.next();
            playerExists = new File("./campaign/players/" + currName + ".dat").exists();
            if (playerExists) continue;
            e.remove();
            CampaignMain.cm.toUser(currName + " has left the campaign. No-Play list updated.", this.owner, true);
        }
        if (this.playerExcludes.size() > this.maxSize) {
            int excludeSize = 0;
            for (excludeSize = this.adminListCountsForCap ? this.playerExcludes.size() + this.adminExcludes.size() : this.playerExcludes.size(); excludeSize > this.maxSize && this.playerExcludes.size() > 0; --excludeSize) {
                String currName2 = (String)this.playerExcludes.get(this.playerExcludes.size() - 1);
                this.playerExcludes.remove(currName2);
                CampaignMain.cm.toUser("Your No-Play list was too long. " + currName2 + " was removed.", this.owner, true);
            }
        }
    }

    public Vector getPlayerExcludes() {
        return this.playerExcludes;
    }

    public Vector getAdminExcludes() {
        return this.adminExcludes;
    }

    public void adminExcludeFromString(String buffer, String delimiter) {
        StringTokenizer ST = new StringTokenizer(buffer, delimiter);
        while (ST.hasMoreElements()) {
            String curr = ST.nextToken();
            if (curr.equals("0")) {
                return;
            }
            this.addExclude(true, curr);
        }
    }

    public void playerExcludeFromString(String buffer, String delimiter) {
        StringTokenizer ST = new StringTokenizer(buffer, delimiter);
        while (ST.hasMoreElements()) {
            String curr = ST.nextToken();
            if (curr.equals("0")) {
                return;
            }
            this.addExclude(false, curr);
        }
        this.validateExcludes();
    }

    public String adminExcludeToString(String token) {
        StringBuffer result = new StringBuffer();
        if (this.adminExcludes.size() == 0) {
            result.append("0");
            result.append(token);
        } else {
            Enumeration e = this.adminExcludes.elements();
            while (e.hasMoreElements()) {
                result.append(e.nextElement());
                result.append(token);
            }
        }
        return result.toString();
    }

    public String playerExcludeToString(String token) {
        StringBuffer result = new StringBuffer();
        if (this.playerExcludes.size() == 0) {
            result.append("0");
            result.append(token);
        } else {
            Enumeration e = this.playerExcludes.elements();
            while (e.hasMoreElements()) {
                result.append(e.nextElement());
                result.append(token);
            }
        }
        return result.toString();
    }
}

