/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.util;

import common.util.AorAn;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import server.campaign.CampaignMain;
import server.campaign.SArmy;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.operations.ShortValidator;

public class OpponentListHelper {
    private SPlayer searchPlayer;
    private TreeMap potentialOpponents;
    private ShortValidator sv;
    private int currentMode = -1;
    public static final int MODE_ADD = 0;
    public static final int MODE_REMOVE = 1;

    public OpponentListHelper(SPlayer p, int mode) {
        this.searchPlayer = p;
        this.potentialOpponents = new TreeMap();
        this.currentMode = mode;
        this.sv = CampaignMain.cm.getOpsManager().getShortValidator();
        if (mode == 0) {
            this.getOpponentsForAll();
        }
        if (mode == 1) {
            this.removeOpponentsForAll();
        }
    }

    public OpponentListHelper(SPlayer p, SArmy a, int mode) {
        this.searchPlayer = p;
        this.potentialOpponents = new TreeMap();
        this.currentMode = mode;
        if (mode == 0) {
            this.getOpponentsForOne(a);
        }
        if (mode == 1) {
            this.removeOpponentsForOne(a);
        }
    }

    private void getOpponentsForAll() {
        Vector allPotentialDefenders = this.getAllPotentialDefenders();
        Enumeration<SArmy> searchArmies = this.searchPlayer.getArmies().elements();
        while (searchArmies.hasMoreElements()) {
            SArmy searchArmy = searchArmies.nextElement();
            for (int i = 0; i < allPotentialDefenders.size(); ++i) {
                SPlayer possOpponent = (SPlayer)allPotentialDefenders.get(i);
                if (possOpponent.equals(this.searchPlayer)) continue;
                this.matchArmy(searchArmy, possOpponent);
            }
        }
    }

    private void removeOpponentsForAll() {
        Enumeration<SArmy> e = this.searchPlayer.getArmies().elements();
        while (e.hasMoreElements()) {
            SArmy currArmy = e.nextElement();
            Enumeration<SArmy> j = currArmy.getOpponents().elements();
            while (j.hasMoreElements()) {
                SArmy oppArmy = j.nextElement();
                oppArmy.removeOpponent(currArmy);
                String currName = oppArmy.getPlayerName().toLowerCase();
                if (this.potentialOpponents.get(currName) != null) continue;
                this.potentialOpponents.put(currName, "filler");
            }
            currArmy.setOpponents(new Vector<SArmy>());
        }
    }

    private void getOpponentsForOne(SArmy searchArmy) {
        Vector allPotentialDefenders = this.getAllPotentialDefenders();
        for (int i = 0; i < allPotentialDefenders.size(); ++i) {
            SPlayer possOpponent = (SPlayer)allPotentialDefenders.get(i);
            this.matchArmy(searchArmy, possOpponent);
        }
    }

    private void removeOpponentsForOne(SArmy searchArmy) {
        Enumeration<SArmy> j = searchArmy.getOpponents().elements();
        while (j.hasMoreElements()) {
            SArmy oppArmy = j.nextElement();
            oppArmy.removeOpponent(searchArmy);
            String currName = oppArmy.getPlayerName().toLowerCase();
            if (this.potentialOpponents.get(currName) != null) continue;
            this.potentialOpponents.put(currName, "filler");
        }
        searchArmy.setOpponents(new Vector<SArmy>());
    }

    private Vector getAllPotentialDefenders() {
        Vector<SPlayer> allPotentialDefenders = new Vector<SPlayer>();
        for (SHouse sHouse : CampaignMain.cm.getData().getAllHouses()) {
            boolean ownHouse = sHouse.equals(this.searchPlayer.getHouseFightingFor());
            boolean inHouseAttacksOk = sHouse.isInHouseAttacks();
            if (ownHouse && !inHouseAttacksOk) continue;
            Enumeration players = sHouse.getActMembers().elements();
            while (players.hasMoreElements()) {
                SPlayer currPlayer = (SPlayer)players.nextElement();
                boolean canPlay = true;
                if (currPlayer.getExclusionList().checkExclude(this.searchPlayer.getName()) != 0) {
                    canPlay = false;
                }
                if (this.searchPlayer.getExclusionList().checkExclude(currPlayer.getName()) != 0) {
                    canPlay = false;
                }
                if (!canPlay || currPlayer.getActivityStatus() != 3 || currPlayer.getImmunetill() > System.currentTimeMillis()) continue;
                allPotentialDefenders.add(currPlayer);
            }
        }
        return allPotentialDefenders;
    }

    private void matchArmy(SArmy a, SPlayer possOpponent) {
        int maxdiff = Integer.parseInt(CampaignMain.cm.getConfig("MaxBVDifference"));
        SArmy searchArmy = a;
        Vector possDefendArmies = this.sv.genericAbleToDefend(a, possOpponent);
        if (possDefendArmies.size() > 0) {
            for (int i = 0; i < possDefendArmies.size(); ++i) {
                SArmy tmp = (SArmy)possDefendArmies.get(i);
                searchArmy.addOpponent(tmp);
                tmp.addOpponent(searchArmy);
            }
            String key = possOpponent.getName().toLowerCase();
            Vector opponentArmies = (Vector)this.potentialOpponents.get(key);
            if (opponentArmies == null) {
                this.potentialOpponents.put(key, possDefendArmies);
            } else {
                for (SArmy currArmy : possDefendArmies) {
                    if (opponentArmies.contains(currArmy)) continue;
                    boolean unadded = true;
                    for (int j = 0; j < opponentArmies.size(); ++j) {
                        SArmy sortA = (SArmy)opponentArmies.get(j);
                        if (sortA.getID() <= currArmy.getID() || !unadded) continue;
                        opponentArmies.add(j, currArmy);
                        unadded = false;
                    }
                }
            }
        }
    }

    public void sendInfoToOpponents(String s) {
        Iterator keyI = this.potentialOpponents.keySet().iterator();
        while (keyI.hasNext()) {
            long minActiveTime;
            long activeSince;
            boolean minActiveMet;
            String output = "<font color=\"black\">[!] ";
            String currOppName = (String)keyI.next();
            SPlayer currOpp = CampaignMain.cm.getPlayer(currOppName);
            if (currOpp == null) continue;
            long currTime = System.currentTimeMillis();
            boolean bl = minActiveMet = currTime - (activeSince = currOpp.getActiveSince()) >= (minActiveTime = Long.parseLong(CampaignMain.cm.getConfig("MinActiveTime")) * 1000L);
            if (!minActiveMet) {
                return;
            }
            SHouse searchHouse = this.searchPlayer.getHouseFightingFor();
            String colHouseName = searchHouse.getColoredNameAsLink();
            output = output + AorAn.check(searchHouse.getName(), false) + " " + colHouseName + " unit " + s;
            if (this.currentMode == 0) {
                Vector currOppArmies = (Vector)this.potentialOpponents.get(currOppName);
                if (currOppArmies.size() > 1) {
                    output = output + "Armies ";
                    int size = currOppArmies.size();
                    for (int j = 0; j < size; ++j) {
                        SArmy currArmy = (SArmy)currOppArmies.get(j);
                        output = output + currArmy.getID();
                        if (j + 2 < size) {
                            output = output + ", ";
                            continue;
                        }
                        if (j + 2 != size) continue;
                        output = output + " and ";
                    }
                } else {
                    SArmy currArmy = (SArmy)currOppArmies.get(0);
                    output = output + "Army " + currArmy.getID();
                }
            }
            output = output + ". [<a href=\"MEKWARS/c checkattack\">Report</a>]";
            CampaignMain.cm.toUser(output + "</font>", currOppName, true);
        }
    }
}

