/*
 * Decompiled with CFR 0.152.
 */
package server.comm;

import com.lyrisoft.chat.ICommands;
import com.lyrisoft.chat.Translator;
import com.lyrisoft.chat.server.remote.AccessDenied;
import com.lyrisoft.chat.server.remote.AccessException;
import com.lyrisoft.chat.server.remote.ChatClient;
import com.lyrisoft.chat.server.remote.ChatServer;
import com.lyrisoft.chat.server.remote.command.CommandBase;
import server.MMServ;
import server.ServerWrapper;
import server.campaign.CampaignMain;

public class SignOn
extends CommandBase
implements ICommands {
    public static int nobody_id = 0;

    public boolean process(ChatClient client, String[] args) {
        args[1] = args[1].trim();
        if (args[1].equals("S")) {
            client.sendRaw("ServerDescription#" + CampaignMain.cm.serverExchangeConnect(args.length > 2 ? args[2] : ""));
            return false;
        }
        if (args[1].length() < 2) {
            client.generalError("No single-char names allowed. Go away...");
            return false;
        }
        args[2] = args[2].trim();
        if (args.length < 2) {
            client.generalError(this.getUsage(args[0]));
            return false;
        }
        if (client.getUserId() != null) {
            client.generalError(Translator.getMessage("already_on"));
            return false;
        }
        client.setUserId(args[1]);
        try {
            if (args.length < 3) {
                client.getServer().signOn(client, null);
            } else {
                client.getServer().signOn(client, args[2]);
            }
            String username = client.getUserId();
            if (args.length > 3) {
                String ProtocolVersion = args[3];
                String UserColor = "black";
                if (args.length > 4) {
                    UserColor = args[4];
                }
                MMServ server = ((ServerWrapper)client.getServer()).getMMServ();
                if (!ProtocolVersion.trim().equalsIgnoreCase(MMServ.getProtocolVersion())) {
                    client.generalError("Incompatable Version");
                }
                server.getUser(username).setColor(UserColor);
                server.sendNewUser(username);
            }
            if (client.getAccessLevel() <= 1 && !client.getUserId().startsWith("Nobody") && !client.getUserId().startsWith("[Dedicated]")) {
                CampaignMain.cm.toUser("Warning: Your account won't be protected until you register your nickname.", username, true);
            }
            if (CampaignMain.cm.getPlayer(username) != null) {
                CampaignMain.cm.doLoginPlayer(username);
                CampaignMain.cm.doReconnectCheckOnPlayer(username);
            } else {
                CampaignMain.cm.toUser("<font color=\"navy\"><br>---<br>It appears that you haven't signed up for this server's campaign.<br><a href=\"MEKWARS/c enroll\">Click here to get started.</a><br>---<br></font>", username, true);
            }
            return true;
        }
        catch (AccessException e) {
            String userId = client.getUserId();
            client.setUserId(null);
            client.signOnError(e.getMessage(), userId);
        }
        catch (AccessDenied e) {
            String key;
            client.setUserId(null);
            client.error("/denied", e.getMessage());
            do {
                key = "Nobody (" + ++nobody_id + ")";
            } while (client.getServer().userExists(key));
            args[1] = key;
            return this.process(client, args);
        }
        return false;
    }

    public void processDistributed(String client, String origin, String[] args, ChatServer server) {
        server.remoteSignOn(origin, client);
    }
}

