/*
 * Decompiled with CFR 0.152.
 */
package server.dataProvider;

import common.CampaignData;
import common.util.BinReader;
import common.util.BinWriter;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;
import server.MMServ;
import server.dataProvider.ServerCommand;

public class CommandTaskThread
extends Thread {
    private Socket client;
    private CampaignData data;

    public void run() {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            MMServ.mmlog.infoLog("DataProvider call accepted from " + this.client.getInetAddress());
            BinReader in = new BinReader(new InputStreamReader(this.client.getInputStream()));
            String cmdStr = in.readLine("cmd");
            BinWriter out = new BinWriter(new PrintWriter(this.client.getOutputStream()));
            MMServ.mmlog.infoLog("DataProvider: request '" + cmdStr + "'");
            String timeStr = in.readLine("lasttimestamp");
            MMServ.mmlog.infoLog("DataProvider: reading timestamp '" + timeStr + "'");
            Class<?> cmdClass = Class.forName("server.dataProvider.commands." + cmdStr);
            ServerCommand cmd = (ServerCommand)cmdClass.newInstance();
            MMServ.mmlog.infoLog("DataProvider: writing time answer time '" + sdf.format(new Date()) + "'");
            out.println(sdf.format(new Date()), "lasttimestamp");
            cmd.execute(timeStr.equals("") ? null : sdf.parse(timeStr), out, this.data);
            out.close();
            this.client.close();
        }
        catch (Throwable e) {
            MMServ.mmlog.errLog(e.getMessage());
        }
    }

    public CommandTaskThread(Socket client, CampaignData data) {
        this.client = client;
        this.data = data;
    }
}

