/*
 * Decompiled with CFR 0.152.
 */
package server.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import server.MMServ;
import server.campaign.CampaignMain;

public class AutomaticBackup
implements Runnable {
    String dateTime = "";
    String campaignZipFileName = "";
    String playerZipFileName = "";
    String dateTimeFormat = "yyyy.MM.dd.HH.mm";
    FileOutputStream out;
    ZipOutputStream zipFile;
    long time;

    public AutomaticBackup(long time) {
        this.time = time;
    }

    public void run() {
        long backupHours = Long.parseLong(CampaignMain.cm.getConfig("AutomaticBackupHours")) * 3600000L;
        long lastBackup = Long.parseLong(CampaignMain.cm.getConfig("LastAutomatedBackup"));
        if (lastBackup > this.time - backupHours) {
            return;
        }
        MMServ.mmlog.mainLog("Arching Started at " + this.time);
        CampaignMain.cm.setArchiving(true);
        SimpleDateFormat sDF = new SimpleDateFormat(this.dateTimeFormat);
        Date date = new Date(this.time);
        File folder = new File("./campaign/backup");
        if (!folder.exists()) {
            folder.mkdir();
        }
        this.dateTime = sDF.format(date);
        this.campaignZipFileName = "./campaign/backup/campaign" + this.dateTime + ".zip";
        this.playerZipFileName = "./campaign/backup/players" + this.dateTime + ".zip";
        try {
            this.out = new FileOutputStream(this.campaignZipFileName);
            this.zipFile = new ZipOutputStream(this.out);
            this.zipBackupCampaign("houses.dat");
            this.zipBackupCampaign("planets.dat");
            this.zipFile.close();
        }
        catch (Exception ex) {
            MMServ.mmlog.errLog("Unable to create campaign zip file");
            MMServ.mmlog.errLog(ex);
        }
        try {
            this.out = new FileOutputStream(this.playerZipFileName);
            this.zipFile = new ZipOutputStream(this.out);
            this.zipBackupPlayers();
            this.zipFile.close();
        }
        catch (Exception ex) {
            MMServ.mmlog.errLog("Unable to create player zip file");
            MMServ.mmlog.errLog(ex);
        }
        CampaignMain.cm.getConfig().setProperty("LastAutomatedBackup", Long.toString(this.time));
        CampaignMain.dso.createConfig();
        CampaignMain.cm.setArchiving(false);
        MMServ.mmlog.mainLog("Arching Ended.");
    }

    private void zipBackupCampaign(String filename) {
        try {
            int c;
            FileInputStream in = new FileInputStream("./campaign/" + filename);
            ZipEntry entry = new ZipEntry(filename);
            this.zipFile.putNextEntry(entry);
            while ((c = in.read()) != -1) {
                this.zipFile.write(c);
            }
            this.zipFile.closeEntry();
            in.close();
        }
        catch (Exception ex) {
            MMServ.mmlog.errLog(ex);
        }
    }

    public void zipBackupPlayers() {
        File folder = new File("./campaign/players");
        File[] files = folder.listFiles();
        try {
            for (int i = 0; i < files.length; ++i) {
                int c;
                FileInputStream in = new FileInputStream(files[i]);
                ZipEntry entry = new ZipEntry(files[i].getName());
                this.zipFile.putNextEntry(entry);
                while ((c = in.read()) != -1) {
                    this.zipFile.write(c);
                }
                this.zipFile.closeEntry();
                in.close();
            }
        }
        catch (Exception ex) {
            MMServ.mmlog.errLog("Unable to backup player files");
            MMServ.mmlog.errLog(ex);
        }
    }
}

