/*
 * Decompiled with CFR 0.152.
 */
package server.util;

import com.lyrisoft.chat.server.remote.AccessDenied;
import com.lyrisoft.chat.server.remote.ChatServer;
import com.lyrisoft.util.io.ResourceException;
import com.lyrisoft.util.io.ResourceLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import jfd.jcrypt;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import net.sf.hibernate.Transaction;
import server.MMServ;
import server.campaign.CampaignMain;
import server.util.MMNetPasswdRecord;

public class MMNetPasswd {
    private static Hashtable records = null;
    private static boolean _warned = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final MMNetPasswdRecord getRecord(String userId) {
        userId = userId.toLowerCase();
        if (CampaignMain.cm.useHibernate()) {
            MMServ.mmlog.mainLog("Get record for " + userId);
            MMNetPasswdRecord result = null;
            Session session = CampaignMain.cm.getSession();
            Transaction tx = null;
            try {
                tx = session.beginTransaction();
                Query q = session.createQuery("FROM MMNetPasswdRecord where Name=:uname");
                q.setParameter("uname", (Object)userId);
                if (q.list().size() == 0) {
                    tx.commit();
                    MMNetPasswdRecord mMNetPasswdRecord = null;
                    return mMNetPasswdRecord;
                }
                result = (MMNetPasswdRecord)q.list().get(0);
                tx.commit();
                session.close();
            }
            catch (Exception e) {
                try {
                    tx.rollback();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                MMServ.mmlog.errLog(e);
            }
            finally {
                try {
                    session.close();
                }
                catch (Exception e) {}
            }
            return result;
        }
        MMNetPasswdRecord r = (MMNetPasswdRecord)records.get(userId.toLowerCase());
        return r;
    }

    public static final MMNetPasswdRecord getRecord(String userId, String password) throws IOException, AccessDenied {
        MMNetPasswdRecord r = MMNetPasswd.getRecord(userId.toLowerCase());
        if (r == null) {
            return null;
        }
        if (password == null) {
            password = "";
        }
        if (password.length() < 2) {
            ChatServer.log("Access denied: " + userId);
            throw new AccessDenied(userId);
        }
        String salt = r.passwd.substring(0, 2);
        if (jcrypt.crypt(salt, password).equals(r.passwd)) {
            r.setTime(System.currentTimeMillis());
            MMNetPasswd.writeRecord(r);
            return r;
        }
        ChatServer.log("Access denied: " + userId);
        throw new AccessDenied(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeRecord(MMNetPasswdRecord r) throws IOException {
        if (CampaignMain.cm.useHibernate()) {
            Session session = CampaignMain.cm.getSession();
            Transaction tx = null;
            try {
                session = CampaignMain.cm.getFactory().openSession();
                tx = session.beginTransaction();
                session.saveOrUpdate((Object)r);
                session.flush();
                tx.commit();
                session.close();
            }
            catch (Exception e) {
                MMServ.mmlog.mainLog("Error in first try");
                MMServ.mmlog.errLog(e);
            }
            finally {
                try {
                    session.close();
                }
                catch (Exception exception) {}
            }
        } else {
            records.put(r.userId.toLowerCase(), r);
            MMNetPasswd.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void removeRecord(String userid) {
        MMNetPasswdRecord r = MMNetPasswd.getRecord(userid);
        if (CampaignMain.cm.useHibernate()) {
            Session session = CampaignMain.cm.getSession();
            Transaction tx = null;
            try {
                session = CampaignMain.cm.getFactory().openSession();
                tx = session.beginTransaction();
                session.delete((Object)r);
                session.flush();
                tx.commit();
                session.close();
            }
            catch (Exception e) {
                MMServ.mmlog.mainLog("Error in first try");
                MMServ.mmlog.errLog(e);
            }
            finally {
                try {
                    session.close();
                }
                catch (Exception e) {}
            }
        } else {
            records.remove(userid.toLowerCase());
        }
    }

    public static final void writeRecord(String userId, int access, String passwd) throws IOException {
        MMNetPasswdRecord r = new MMNetPasswdRecord(userId, access, passwd, System.currentTimeMillis(), "");
        String salt = String.valueOf(System.currentTimeMillis());
        int len = salt.length();
        salt = salt.substring(len - 2, len);
        r.passwd = jcrypt.crypt(salt, passwd);
        MMNetPasswd.writeRecord(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final synchronized void save() throws IOException {
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(MMNetPasswd.getPasswdFileName()));
            Enumeration e = records.elements();
            while (e.hasMoreElements()) {
                MMNetPasswd.saveRecord(out, (MMNetPasswdRecord)e.nextElement());
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reloadFile() {
        records = new Hashtable();
        BufferedReader reader = null;
        int lineno = 1;
        try {
            String s;
            InputStream is = ResourceLoader.getResource("conf/nfc.passwd");
            reader = new BufferedReader(new InputStreamReader(is));
            while ((s = reader.readLine()) != null) {
                MMNetPasswdRecord r = MMNetPasswd.parseRecord(s);
                records.put(r.userId.toLowerCase(), r);
            }
            ++lineno;
        }
        catch (ResourceException e) {
            if (!_warned) {
                ChatServer.logError("Warning: passwd file not found.");
                _warned = true;
            }
        }
        catch (Exception e) {
            ChatServer.logError("Error reading passwd file, line " + lineno);
            ChatServer.log(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    ChatServer.log(e);
                }
            }
        }
    }

    private static final MMNetPasswdRecord parseRecord(String line) throws Exception {
        StringTokenizer st = new StringTokenizer(line, ":");
        if (st.countTokens() < 3) {
            throw new Exception("Not enough tokens");
        }
        if (st.countTokens() == 3) {
            return new MMNetPasswdRecord(st.nextToken(), Integer.parseInt(st.nextToken()), st.nextToken(), 0L, "");
        }
        if (st.countTokens() == 4) {
            return new MMNetPasswdRecord(st.nextToken(), Integer.parseInt(st.nextToken()), st.nextToken(), Long.parseLong(st.nextToken()), "");
        }
        return new MMNetPasswdRecord(st.nextToken(), Integer.parseInt(st.nextToken()), st.nextToken(), Long.parseLong(st.nextToken()), st.nextToken());
    }

    private static final void saveRecord(PrintWriter writer, MMNetPasswdRecord record) throws IOException {
        writer.println(record.userId + ":" + record.access + ":" + record.passwd + ":" + record.time + ":" + record.getPlayerLogo());
    }

    private static final String getPasswdFileName() {
        StringBuffer sb = new StringBuffer();
        String NFC_HOME = System.getProperty("NFC_HOME");
        if (NFC_HOME == null) {
            MMServ.mmlog.errLog("Passwd: Warning! Property NFC_HOME not set.");
            return "";
        }
        sb.append(NFC_HOME);
        if (NFC_HOME.charAt(NFC_HOME.length() - 1) != File.separatorChar) {
            sb.append(File.separator);
        }
        sb.append("conf");
        sb.append(File.separator);
        sb.append("nfc.passwd");
        return sb.toString();
    }

    public static void main(String[] args) {
        try {
            MMNetPasswd.writeRecord(args[0], Integer.parseInt(args[1]), args[2]);
        }
        catch (IOException e) {
            MMServ.mmlog.errLog("An I/O error occurred: " + e.getMessage());
        }
        catch (Exception e) {
            MMNetPasswd.showUsageAndExit();
        }
    }

    private static final void showUsageAndExit() {
        MMServ.mmlog.errLog("Passwd Program.  Adds new line to the passwd file, encrypting the password.");
        MMServ.mmlog.errLog("usage: java com.lyrisoft.chat.server.remote.auth.Passwd [user id] [access level] [password] [timeoflastuse]");
        System.exit(1);
    }

    static {
        MMNetPasswd.reloadFile();
    }
}

