/*
 * Decompiled with CFR 0.152.
 */
package server.util;

import java.io.PrintWriter;
import java.net.Socket;
import server.MMServ;
import server.campaign.CampaignMain;

public class TrackerThread
extends Thread {
    MMServ serv;

    public TrackerThread(MMServ s) {
        this.serv = s;
        MMServ.mmlog.infoLog("Created TrackerThread");
    }

    public void ExtendedWait(int time) {
        try {
            this.wait(time);
        }
        catch (Exception ex) {
            MMServ.mmlog.errLog(ex);
        }
    }

    public synchronized void run() {
        Socket sock;
        MMServ.mmlog.infoLog("TrackerThread running.");
        String name = this.serv.getConfigParam("SERVERNAME");
        String link = this.serv.getConfigParam("TRACKERLINK");
        String vers = this.serv.getVersion();
        String desc = this.serv.getConfigParam("TRACKERDESC");
        String trackerAddress = this.serv.getConfigParam("TRACKERADDRESS");
        try {
            MMServ.mmlog.infoLog("TrackerThread attempting to send ServerStart information.");
            sock = new Socket(trackerAddress, 13731);
            PrintWriter pw = new PrintWriter(sock.getOutputStream());
            pw.println("SS%" + name + "%" + link + "%" + vers + "%" + desc);
            pw.flush();
            pw.close();
            MMServ.mmlog.infoLog("TrackerThread sent server start information.");
        }
        catch (Exception e) {
            MMServ.mmlog.infoLog("TrackerThread could not contact tracker. Shutting down.");
            MMServ.mmlog.errLog("Could not contact tracker. Shutting down trackerthread.");
            MMServ.mmlog.errLog(e);
            return;
        }
        block6: while (true) {
            try {
                while (true) {
                    this.ExtendedWait(600000);
                    int playersOnline = this.serv.userCount(false);
                    int gamesInProgress = 0;
                    int gamesCompleted = 0;
                    CampaignMain campaign = this.serv.getCampaign();
                    if (campaign != null) {
                        gamesInProgress = campaign.getOpsManager().getRunningOps().size();
                        gamesCompleted = campaign.getGamesCompleted();
                        campaign.setGamesCompleted(0);
                    }
                    String toSend = "PH%" + name + "%" + playersOnline + "%" + gamesInProgress + "%" + gamesCompleted;
                    try {
                        MMServ.mmlog.infoLog("TrackerThread attempting to send PhoneHome information.");
                        sock = new Socket(trackerAddress, 13731);
                        PrintWriter pw = new PrintWriter(sock.getOutputStream());
                        pw.println(toSend);
                        pw.flush();
                        pw.close();
                        MMServ.mmlog.infoLog("TrackerThread sent PH% information.");
                        continue block6;
                    }
                    catch (Exception e) {
                        MMServ.mmlog.infoLog("TrackerThread could not reach tracker for PH%.");
                        MMServ.mmlog.errLog("Could not contact tracker.");
                        MMServ.mmlog.errLog(e);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                MMServ.addToErrorLog(ex);
                return;
            }
        }
    }
}

