/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.gnutella;

import com.echomine.util.HexDec;
import com.echomine.util.RandomGUID;
import java.io.Serializable;

public class GUID
implements Serializable {
    public static final int sDataLength = 16;
    private String mStr;
    private byte[] mBytes = new byte[16];
    private int mHashCode = 0;

    public GUID() {
        this(true);
    }

    public GUID(boolean generate) {
        if (generate) {
            RandomGUID guid = new RandomGUID();
            this.mBytes = guid.getGUIDBytes();
            this.mBytes[8] = -1;
            this.mBytes[15] = 0;
            this.mStr = HexDec.convertBytesToHexString(this.mBytes);
            this.computeHashCode();
        }
    }

    public int hashCode() {
        return this.mHashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GUID)) {
            return false;
        }
        GUID guid = (GUID)obj;
        return this.mStr.equals(guid.mStr);
    }

    public int getSize() {
        return 16;
    }

    public int serialize(byte[] outbuf, int offset) {
        System.arraycopy(this.mBytes, 0, outbuf, offset, 16);
        return offset + 16;
    }

    public int deserialize(byte[] inbuf, int offset) {
        System.arraycopy(inbuf, offset, this.mBytes, 0, 16);
        this.mStr = HexDec.convertBytesToHexString(this.mBytes);
        this.computeHashCode();
        return offset + 16;
    }

    public String toString() {
        return this.mStr;
    }

    public String getHexString() {
        return this.mStr;
    }

    public byte[] getGUIDBytes() {
        byte[] temp = new byte[this.mBytes.length];
        System.arraycopy(this.mBytes, 0, temp, 0, temp.length);
        return temp;
    }

    private void computeHashCode() {
        int v1 = this.mBytes[0] < 0 ? this.mBytes[0] + 256 : this.mBytes[0];
        int v2 = this.mBytes[1] < 0 ? this.mBytes[1] + 256 : this.mBytes[1];
        int v3 = this.mBytes[2] < 0 ? this.mBytes[2] + 256 : this.mBytes[2];
        int v4 = this.mBytes[3] < 0 ? this.mBytes[3] + 256 : this.mBytes[3];
        int hashedValue = v1 << 24 | v2 << 16 | v3 << 8 | v4;
        for (int i = 4; i < 16; i += 4) {
            v1 = this.mBytes[i + 0] < 0 ? this.mBytes[i + 0] + 256 : this.mBytes[i + 0];
            v2 = this.mBytes[i + 1] < 0 ? this.mBytes[i + 1] + 256 : this.mBytes[i + 1];
            v3 = this.mBytes[i + 2] < 0 ? this.mBytes[i + 2] + 256 : this.mBytes[i + 2];
            v4 = this.mBytes[i + 3] < 0 ? this.mBytes[i + 3] + 256 : this.mBytes[i + 3];
            int value = v1 << 24 | v2 << 16 | v3 << 8 | v4;
            hashedValue ^= value;
        }
        this.mHashCode = hashedValue;
    }
}

