/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.gnutella;

import com.echomine.net.ConnectionModel;
import com.echomine.util.HTTPHeader;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class GnutellaConnectionModel
extends ConnectionModel {
    public static final int OUTGOING = 1;
    public static final int INCOMING = 2;
    public static final String INCOMING_STRING = "Incoming";
    public static final String OUTGOING_STRING = "Outgoing";
    public static final String UNKNOWN_STRING = "Unknown";
    private int connectionType;
    private HTTPHeader connectionHeaders = null;

    public GnutellaConnectionModel(int port) {
        this(port, 1);
    }

    public GnutellaConnectionModel(InetAddress host, int port) {
        this(host, port, 1);
    }

    public GnutellaConnectionModel(String hostname, int port) throws UnknownHostException {
        this(hostname, port, 1);
    }

    public GnutellaConnectionModel(int port, int connectionType) {
        super(port);
        this.connectionType = connectionType;
    }

    public GnutellaConnectionModel(InetAddress host, int port, int connectionType) {
        super(host, port);
        this.connectionType = connectionType;
    }

    public GnutellaConnectionModel(String hostname, int port, int connectionType) throws UnknownHostException {
        super(hostname, port);
        this.connectionType = connectionType;
    }

    public int getConnectionType() {
        return this.connectionType;
    }

    public HTTPHeader getConnectionHeaders() {
        return this.connectionHeaders;
    }

    public void setConnectionHeader(String headerName, String headerValue) {
        if (this.connectionHeaders == null) {
            this.connectionHeaders = new HTTPHeader();
        }
        this.connectionHeaders.setHeader(headerName, headerValue);
    }

    public String getConnectionTypeString() {
        switch (this.connectionType) {
            case 2: {
                return INCOMING_STRING;
            }
            case 1: {
                return OUTGOING_STRING;
            }
        }
        return UNKNOWN_STRING;
    }
}

