/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.gnutella;

import com.echomine.gnutella.GUID;
import com.echomine.gnutella.GnutellaConnectionManager;
import com.echomine.gnutella.GnutellaConnectionModel;
import com.echomine.gnutella.GnutellaContext;
import com.echomine.gnutella.GnutellaDownloadInfo;
import com.echomine.gnutella.GnutellaFileListener;
import com.echomine.gnutella.GnutellaFileModel;
import com.echomine.gnutella.GnutellaFirewalledDownloadInfo;
import com.echomine.gnutella.GnutellaListenerRouter;
import com.echomine.gnutella.MsgPushRequest;
import com.echomine.gnutella.impl.GivRequestHandler;
import com.echomine.gnutella.impl.GnutellaDirectDownloadHandler;
import com.echomine.net.BaseFileHandler;
import com.echomine.net.Connection;
import com.echomine.net.ConnectionEvent;
import com.echomine.net.ConnectionFailedException;
import com.echomine.net.ConnectionListener;
import com.echomine.net.ConnectionModel;
import com.echomine.net.ConnectionVetoException;
import com.echomine.net.FileEvent;
import com.echomine.net.FileModel;
import com.echomine.net.SocketConnector;
import com.echomine.net.SocketHandler;
import com.echomine.net.TransferRateThrottler;
import com.echomine.net.TransferVetoException;
import com.echomine.util.IOUtil;
import com.echomine.util.IPUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class GnutellaDownloadService
extends Connection {
    private GnutellaConnectionManager cmanager;
    private GnutellaContext context;
    private DownloadConnectionListener clistener;
    private DownloadFileListener flistener;
    private GivRequestHandler givHandler;

    public GnutellaDownloadService(GnutellaContext context, GnutellaConnectionManager cmanager, GnutellaListenerRouter listenerRouter) {
        this.cmanager = cmanager;
        this.context = context;
        this.clistener = new DownloadConnectionListener();
        this.flistener = new DownloadFileListener();
        this.givHandler = new GivRequestHandler(context, this.clistener, this.flistener);
        listenerRouter.addRequestHandler(this.givHandler);
    }

    public GnutellaDownloadInfo getFile(GUID guid, String IP, int port, GnutellaFileModel filemodel, ConnectionListener cl, GnutellaFileListener fl) throws UnknownHostException {
        GnutellaDownloadInfo info = null;
        if (port == 0 || IPUtil.isHostIPPrivate(IP)) {
            info = this.getFileThroughFirewall(guid, filemodel, cl, fl);
        } else {
            GnutellaConnectionModel cmodel = new GnutellaConnectionModel(IP, port, 2);
            info = new GnutellaDownloadInfo(cmodel, filemodel, cl, fl);
            filemodel.setConnectionModel(cmodel);
            GnutellaDirectDownloadHandler handler = new GnutellaDirectDownloadHandler(this.context, filemodel);
            DirectDownloadConnector connector = new DirectDownloadConnector(handler, guid, filemodel, cl, fl);
            connector.addConnectionListener(this.clistener);
            handler.addFileListener(this.flistener);
            if (info.cl != null) {
                connector.addConnectionListener(cl);
            }
            if (info.fl != null) {
                handler.addFileListener(fl);
            }
            connector.aconnect(cmodel);
        }
        return info;
    }

    public GnutellaDownloadInfo getFileThroughFirewall(GUID guid, GnutellaFileModel filemodel, ConnectionListener cl, GnutellaFileListener fl) throws UnknownHostException {
        InetAddress ip = this.context.getInterfaceIP();
        if (ip == null) {
            ip = InetAddress.getLocalHost();
        }
        GnutellaFirewalledDownloadInfo info = new GnutellaFirewalledDownloadInfo(new GnutellaConnectionModel(ip, (int)this.context.getPort()), filemodel, cl, fl, guid);
        this.givHandler.addRequest(info);
        MsgPushRequest msg = new MsgPushRequest(guid, ip, this.context.getPort(), filemodel.getFileIndex());
        this.cmanager.send(msg);
        return info;
    }

    public void addFileListener(GnutellaFileListener l) {
        this.flistener.addFileListener(l);
    }

    public void removeFileListener(GnutellaFileListener l) {
        this.flistener.removeFileListener(l);
    }

    class DirectDownloadConnector
    extends SocketConnector {
        GUID guid;
        GnutellaFileModel filemodel;
        ConnectionListener cl;
        GnutellaFileListener fl;

        public DirectDownloadConnector(SocketHandler socketHandler, GUID guid, GnutellaFileModel filemodel, ConnectionListener cl, GnutellaFileListener fl) {
            super(socketHandler);
            this.guid = guid;
            this.filemodel = filemodel;
            this.cl = cl;
            this.fl = fl;
        }

        public void connect(SocketHandler socketHandler, ConnectionModel connectionModel) throws ConnectionFailedException {
            try {
                super.connect(socketHandler, connectionModel);
            }
            catch (ConnectionFailedException ex) {
                try {
                    GnutellaDownloadService.this.getFileThroughFirewall(this.guid, this.filemodel, this.cl, this.fl);
                }
                catch (UnknownHostException ex1) {
                    // empty catch block
                }
                throw ex;
            }
        }

        public void aconnect(SocketHandler socketHandler, ConnectionModel connectionModel) {
            Thread thread = new Thread(new Runnable(this, connectionModel, socketHandler){
                private final /* synthetic */ ConnectionModel val$connectionModel;
                private final /* synthetic */ SocketHandler val$socketHandler;
                private final /* synthetic */ DirectDownloadConnector this$1;
                {
                    this.this$1 = this$1;
                    this.val$connectionModel = val$connectionModel;
                    this.val$socketHandler = val$socketHandler;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Socket socket = null;
                    try {
                        ConnectionEvent event = new ConnectionEvent(this.val$connectionModel, 4);
                        ConnectionEvent vetoEvent = new ConnectionEvent(this.val$connectionModel, 5);
                        this.val$socketHandler.start();
                        DirectDownloadConnector.access$300(this.this$1, event, vetoEvent);
                        socket = new Socket(this.val$connectionModel.getHost(), this.val$connectionModel.getPort());
                        try {
                            event = new ConnectionEvent(this.val$connectionModel, 1);
                            DirectDownloadConnector.access$400(this.this$1, event);
                            this.val$socketHandler.handle(socket);
                            event = new ConnectionEvent(this.val$connectionModel, 2);
                            DirectDownloadConnector.access$500(this.this$1, event);
                        }
                        catch (IOException ex) {
                            event = new ConnectionEvent(this.val$connectionModel, 3, "Error while handling connection: " + ex.getMessage());
                            DirectDownloadConnector.access$600(this.this$1, event);
                        }
                        finally {
                            IOUtil.closeSocket(socket);
                        }
                    }
                    catch (IOException ex) {
                        try {
                            DirectDownloadConnector.access$700(this.this$1).getFileThroughFirewall(this.this$1.guid, this.this$1.filemodel, this.this$1.cl, this.this$1.fl);
                        }
                        catch (UnknownHostException ex1) {
                            // empty catch block
                        }
                        ConnectionEvent event = new ConnectionEvent(this.val$connectionModel, 3, "Error..." + ex.getMessage());
                        DirectDownloadConnector.access$800(this.this$1, event);
                    }
                    catch (ConnectionVetoException connectionVetoException) {
                        // empty catch block
                    }
                }
            });
            thread.start();
        }

        static /* synthetic */ void access$300(DirectDownloadConnector x0, ConnectionEvent x1, ConnectionEvent x2) throws ConnectionVetoException {
            x0.fireConnectionStarting(x1, x2);
        }

        static /* synthetic */ void access$400(DirectDownloadConnector x0, ConnectionEvent x1) {
            x0.fireConnectionEstablished(x1);
        }

        static /* synthetic */ void access$500(DirectDownloadConnector x0, ConnectionEvent x1) {
            x0.fireConnectionClosed(x1);
        }

        static /* synthetic */ void access$600(DirectDownloadConnector x0, ConnectionEvent x1) {
            x0.fireConnectionClosed(x1);
        }

        static /* synthetic */ GnutellaDownloadService access$700(DirectDownloadConnector x0) {
            return x0.GnutellaDownloadService.this;
        }

        static /* synthetic */ void access$800(DirectDownloadConnector x0, ConnectionEvent x1) {
            x0.fireConnectionClosed(x1);
        }
    }

    class DownloadFileListener
    extends BaseFileHandler
    implements GnutellaFileListener {
        DownloadFileListener() {
        }

        public FileModel getModel() {
            return null;
        }

        public void start() {
        }

        public void handle(Socket socket) throws IOException {
        }

        public TransferRateThrottler getTransferRateThrottler() {
            return null;
        }

        public void shutdown() {
        }

        public void filesizeChanged(FileEvent e) {
            this.fireFilesizeChanged(e);
        }

        public void fileInfoChanged(FileEvent e) {
            this.fireFileInfoChanged(e);
        }

        public void fileTransferFinished(FileEvent e) {
            this.fireFileTransferFinished(e);
        }

        public void fileTransferStarting(FileEvent e) throws TransferVetoException {
            this.fireFileTransferStartingWithoutVeto(e);
        }
    }

    class DownloadConnectionListener
    implements ConnectionListener {
        DownloadConnectionListener() {
        }

        public void connectionStarting(ConnectionEvent e) throws ConnectionVetoException {
            GnutellaDownloadService.this.fireConnectionStartingWithoutVeto(e);
        }

        public void connectionEstablished(ConnectionEvent e) {
            GnutellaDownloadService.this.fireConnectionEstablished(e);
        }

        public void connectionClosed(ConnectionEvent e) {
            GnutellaDownloadService.this.fireConnectionClosed(e);
        }
    }
}

