/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.gnutella;

import com.echomine.gnutella.GnutellaContext;
import com.echomine.gnutella.GnutellaFileModel;
import com.echomine.net.AbstractFileHandler;
import com.echomine.net.FileEvent;
import com.echomine.net.FileModel;
import com.echomine.util.HTTPHeader;
import com.echomine.util.HTTPResponseHeader;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class GnutellaFileHandler
extends AbstractFileHandler {
    private static Log dllogger = LogFactory.getLog((String)"gnutella/file/download");
    private static Log ullogger = LogFactory.getLog((String)"gnutella/file/upload");
    private GnutellaContext context;
    private HTTPHeader response;

    public GnutellaFileHandler(GnutellaContext context, FileModel model) {
        super(model);
        this.context = context;
    }

    protected String createErrorHeader(int code, String msg) {
        HTTPResponseHeader response = new HTTPResponseHeader();
        response.setStatus(code, msg);
        response.setHeader("Server", this.context.getSupportedFeatureHeaders().getHeader("User-Agent"));
        return response.toString();
    }

    public HTTPHeader getResponseHeaders() {
        return this.response;
    }

    protected void setResponseHeaders(HTTPHeader header) {
        this.response = header;
    }

    protected GnutellaContext getContext() {
        return this.context;
    }

    protected void logTransferStarting() {
        GnutellaFileModel fmodel = (GnutellaFileModel)this.getModel();
        if (fmodel.getConnectionModel().getConnectionType() == 2) {
            if (dllogger.isInfoEnabled()) {
                dllogger.info((Object)("Initiating file transfer with " + fmodel.getConnectionModel() + " for /" + fmodel.getFileIndex() + "/" + fmodel.getFilename()));
            } else if (ullogger.isInfoEnabled()) {
                ullogger.info((Object)("Initiating file transfer with " + fmodel.getConnectionModel() + " for /" + fmodel.getFileIndex() + "/" + fmodel.getFilename()));
            }
        }
    }

    protected void logTransferFinished(FileEvent event) {
        GnutellaFileModel fmodel = (GnutellaFileModel)this.getModel();
        Log logger = fmodel.getConnectionModel().getConnectionType() == 2 ? dllogger : ullogger;
        if (logger.isInfoEnabled()) {
            HTTPHeader headers;
            StringBuffer buf = new StringBuffer(100);
            buf.append("File transfer ");
            switch (event.getStatus()) {
                case 4: {
                    buf.append("finished ");
                    break;
                }
                case 5: {
                    buf.append("errored ");
                    break;
                }
                case 6: {
                    buf.append("cancelled ");
                    break;
                }
                case 7: {
                    buf.append("vetoed ");
                    break;
                }
                case 8: {
                    buf.append("queued ");
                    break;
                }
                default: {
                    buf.append("finished (status " + event.getStatus() + ") ");
                }
            }
            buf.append("with " + fmodel.getConnectionModel() + " for /" + fmodel.getFileIndex() + "/" + fmodel.getFilename());
            if (event.getErrorMessage() != null) {
                buf.append(" (" + event.getErrorMessage() + ")");
            }
            logger.info((Object)buf.toString());
            if (logger.isDebugEnabled() && (headers = this.getResponseHeaders()) != null) {
                Iterator iter = headers.getHeaderNames().iterator();
                while (iter.hasNext()) {
                    String header = (String)iter.next();
                    String value = headers.getHeader(header);
                    logger.debug((Object)("Header " + header + ": " + value));
                }
            }
        }
    }
}

