/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.gnutella;

import com.echomine.gnutella.GUID;
import com.echomine.gnutella.GnutellaConnection;
import com.echomine.gnutella.GnutellaMessage;
import java.util.HashMap;
import java.util.LinkedList;

public class GnutellaMessageModel {
    protected final int MESSAGE_MAX = 10000;
    protected HashMap msgSeen = new HashMap(10000);
    protected HashMap msgOwn = new HashMap(10000);
    protected HashMap msgRoutingTable = new HashMap(10000);
    protected HashMap msgPushRoutingTable = new HashMap(10000);
    protected LinkedList msgLRU = new LinkedList();
    protected LinkedList msgOwnLRU = new LinkedList();
    protected LinkedList routingLRU = new LinkedList();
    protected LinkedList pushRoutingLRU = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean checkAndAddMsgSeen(GnutellaMessage msg) {
        GUID msgID = msg.getHeader().getMsgID();
        HashMap hashMap = this.msgSeen;
        synchronized (hashMap) {
            if (this.msgSeen.get(msgID) != null) {
                return true;
            }
            this.msgSeen.put(msgID, msg.getHeader());
            this.msgLRU.addLast(msgID);
            if (this.msgLRU.size() > 10000) {
                GUID guid = (GUID)this.msgLRU.removeFirst();
                this.msgSeen.remove(guid);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToRoutingTable(GUID msgID, GnutellaConnection sender) {
        HashMap hashMap = this.msgRoutingTable;
        synchronized (hashMap) {
            this.msgRoutingTable.put(msgID, sender);
            this.routingLRU.addLast(msgID);
            if (this.routingLRU.size() > 10000) {
                GUID guid = (GUID)this.routingLRU.removeFirst();
                this.msgRoutingTable.remove(guid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToPushRoutingTable(GUID clientID, GnutellaConnection sender) {
        HashMap hashMap = this.msgPushRoutingTable;
        synchronized (hashMap) {
            this.msgPushRoutingTable.put(clientID, sender);
            this.pushRoutingLRU.addLast(clientID);
            if (this.pushRoutingLRU.size() > 10000) {
                GUID guid = (GUID)this.pushRoutingLRU.removeFirst();
                this.msgPushRoutingTable.remove(guid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToOwnMsg(GnutellaMessage msg) {
        HashMap hashMap = this.msgOwn;
        synchronized (hashMap) {
            this.msgOwn.put(msg.getHeader().getMsgID(), msg);
            this.msgOwnLRU.addLast(msg);
            if (this.msgOwnLRU.size() > 10000) {
                GnutellaMessage kmsg = (GnutellaMessage)this.msgOwnLRU.removeFirst();
                this.msgOwn.remove(kmsg.getHeader().getMsgID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GnutellaConnection getRouting(GUID msgID) {
        HashMap hashMap = this.msgRoutingTable;
        synchronized (hashMap) {
            return (GnutellaConnection)this.msgRoutingTable.get(msgID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GnutellaConnection getPushRouting(GUID clientID) {
        HashMap hashMap = this.msgPushRoutingTable;
        synchronized (hashMap) {
            return (GnutellaConnection)this.msgPushRoutingTable.get(clientID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMsgOwner(GnutellaMessage msg) {
        HashMap hashMap = this.msgOwn;
        synchronized (hashMap) {
            return this.msgOwn.containsKey(msg.getHeader().getMsgID());
        }
    }
}

