/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.gnutella;

import com.echomine.gnutella.GnutellaConnection;
import com.echomine.gnutella.GnutellaProtocolSocketHandler;
import com.echomine.gnutella.GnutellaProtocolType;
import com.echomine.gnutella.RawDataReceivable;
import com.echomine.gnutella.impl.GnutellaAcceptorProtocolV04;
import com.echomine.gnutella.impl.GnutellaAcceptorProtocolV06;
import com.echomine.gnutella.impl.GnutellaBusyAcceptorProtocolV04;
import com.echomine.gnutella.impl.GnutellaBusyAcceptorProtocolV06;
import com.echomine.gnutella.impl.GnutellaConnectorProtocolV04;
import com.echomine.gnutella.impl.GnutellaConnectorProtocolV06;
import com.echomine.gnutella.impl.GnutellaRejectedAcceptorProtocolV04;
import com.echomine.gnutella.impl.GnutellaRejectedAcceptorProtocolV06;

public class GnutellaProtocolFactory
implements GnutellaProtocolType {
    public static GnutellaProtocolSocketHandler createHandlerFor(int protocolType, GnutellaConnection conn, RawDataReceivable router) {
        switch (protocolType) {
            case 1: {
                return new GnutellaAcceptorProtocolV04(conn, router);
            }
            case 2: {
                return new GnutellaAcceptorProtocolV06(conn, router);
            }
            case 3: {
                return new GnutellaBusyAcceptorProtocolV04(conn, router);
            }
            case 4: {
                return new GnutellaBusyAcceptorProtocolV06(conn, router);
            }
            case 5: {
                return new GnutellaRejectedAcceptorProtocolV04(conn, router);
            }
            case 6: {
                return new GnutellaRejectedAcceptorProtocolV06(conn, router);
            }
            case 7: {
                return new GnutellaConnectorProtocolV04(conn, router);
            }
            case 8: {
                return new GnutellaConnectorProtocolV06(conn, router);
            }
        }
        throw new IllegalStateException("Unable to find a Protocol Handler for the specified protocol type");
    }
}

