/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.gnutella;

import com.echomine.gnutella.GnutellaConnectionManager;
import com.echomine.gnutella.GnutellaContext;
import com.echomine.gnutella.GnutellaListenerRouter;
import com.echomine.gnutella.GnutellaMessage;
import com.echomine.gnutella.GnutellaMessageEvent;
import com.echomine.gnutella.GnutellaMessageListener;
import com.echomine.gnutella.GnutellaSearchEvent;
import com.echomine.gnutella.GnutellaSearchListener;
import com.echomine.gnutella.MsgQuery;
import com.echomine.gnutella.MsgQueryResponse;
import java.util.HashMap;
import javax.swing.event.EventListenerList;

public class GnutellaSearchService {
    protected EventListenerList listenerList = new EventListenerList();
    protected HashMap queryListeners = new HashMap();
    private GnutellaConnectionManager cmanager;
    private GnutellaContext context;
    private GnutellaListenerRouter listenerRouter;
    private SearchResultMessageListener mlistener;
    static /* synthetic */ Class class$com$echomine$gnutella$GnutellaSearchListener;

    public GnutellaSearchService(GnutellaContext context, GnutellaConnectionManager cmanager, GnutellaListenerRouter listenerRouter) {
        this.context = context;
        this.cmanager = cmanager;
        this.listenerRouter = listenerRouter;
        this.mlistener = new SearchResultMessageListener();
        cmanager.addMessageListener(this.mlistener);
    }

    public MsgQuery search(String keyword, short minSpeed, GnutellaSearchListener l) {
        MsgQuery query = new MsgQuery(keyword, minSpeed);
        this.search(query, l);
        return query;
    }

    public void search(MsgQuery query) {
        this.cmanager.send(query);
    }

    public void search(MsgQuery query, GnutellaSearchListener l) {
        if (l != null) {
            this.queryListeners.put(query.getHeader().getMsgID(), l);
        }
        this.cmanager.send(query);
    }

    public void addSearchListener(GnutellaSearchListener l) {
        this.listenerList.add(class$com$echomine$gnutella$GnutellaSearchListener == null ? (class$com$echomine$gnutella$GnutellaSearchListener = GnutellaSearchService.class$("com.echomine.gnutella.GnutellaSearchListener")) : class$com$echomine$gnutella$GnutellaSearchListener, l);
    }

    public void removeSearchListener(GnutellaSearchListener l) {
        this.listenerList.remove(class$com$echomine$gnutella$GnutellaSearchListener == null ? (class$com$echomine$gnutella$GnutellaSearchListener = GnutellaSearchService.class$("com.echomine.gnutella.GnutellaSearchListener")) : class$com$echomine$gnutella$GnutellaSearchListener, l);
    }

    protected void fireSearchResultForListener(MsgQueryResponse msg) {
        GnutellaSearchListener l = (GnutellaSearchListener)this.queryListeners.get(msg.getHeader().getMsgID());
        if (l == null) {
            return;
        }
        GnutellaSearchEvent evt = new GnutellaSearchEvent(this, msg);
        l.searchResultReceived(evt, msg);
    }

    protected void fireSearchResultReceived(MsgQueryResponse msg) {
        Object[] listeners = this.listenerList.getListenerList();
        GnutellaSearchEvent evt = new GnutellaSearchEvent(this, msg);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$com$echomine$gnutella$GnutellaSearchListener == null ? GnutellaSearchService.class$("com.echomine.gnutella.GnutellaSearchListener") : class$com$echomine$gnutella$GnutellaSearchListener)) continue;
            ((GnutellaSearchListener)listeners[i + 1]).searchResultReceived(evt, msg);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class SearchResultMessageListener
    implements GnutellaMessageListener {
        SearchResultMessageListener() {
        }

        public void messageReceived(GnutellaMessageEvent event) {
            GnutellaMessage msg = event.getMessage();
            if (msg.getType() == 129) {
                MsgQueryResponse response = (MsgQueryResponse)msg;
                GnutellaSearchService.this.fireSearchResultForListener(response);
                GnutellaSearchService.this.fireSearchResultReceived(response);
            }
        }
    }
}

