/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.gnutella;

import com.echomine.common.SendMessageFailedException;
import com.echomine.gnutella.GnutellaConnectionManager;
import com.echomine.gnutella.GnutellaConnectionModel;
import com.echomine.gnutella.GnutellaContext;
import com.echomine.gnutella.GnutellaFileListener;
import com.echomine.gnutella.GnutellaFileModel;
import com.echomine.gnutella.GnutellaListenerRouter;
import com.echomine.gnutella.GnutellaMessage;
import com.echomine.gnutella.GnutellaMessageEvent;
import com.echomine.gnutella.GnutellaMessageHeader;
import com.echomine.gnutella.GnutellaMessageListener;
import com.echomine.gnutella.MsgPushRequest;
import com.echomine.gnutella.MsgQuery;
import com.echomine.gnutella.MsgQueryResponse;
import com.echomine.gnutella.MsgResRecord;
import com.echomine.gnutella.ShareInfo;
import com.echomine.gnutella.impl.GetRequestHandler;
import com.echomine.gnutella.impl.GnutellaFirewalledUploadHandler;
import com.echomine.net.BaseFileHandler;
import com.echomine.net.Connection;
import com.echomine.net.ConnectionEvent;
import com.echomine.net.ConnectionListener;
import com.echomine.net.ConnectionVetoException;
import com.echomine.net.FileEvent;
import com.echomine.net.FileModel;
import com.echomine.net.SocketConnector;
import com.echomine.net.TransferRateThrottler;
import com.echomine.net.TransferVetoException;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.util.Collection;
import java.util.Iterator;

public class GnutellaShareService
extends Connection {
    private GnutellaContext context;
    private GetRequestHandler getRequestHandler;
    private ShareInfo info;
    private ShareFileListener fl;

    public GnutellaShareService(GnutellaContext context, GnutellaConnectionManager cmanager, GnutellaListenerRouter listenerRouter) {
        this.context = context;
        cmanager.addMessageListener(new SearchMessageListener());
        cmanager.addMessageListener(new FirewalledUploadMessageListener());
        ShareConnectionListener cl = new ShareConnectionListener();
        this.fl = new ShareFileListener();
        this.info = new ShareInfo(context.getShareFileController(), cl, this.fl);
        this.getRequestHandler = new GetRequestHandler(context, this.info);
        listenerRouter.addRequestHandler(this.getRequestHandler);
    }

    public void addFileListener(GnutellaFileListener l) {
        this.fl.addFileListener(l);
    }

    public void removeFileListener(GnutellaFileListener l) {
        this.fl.removeFileListener(l);
    }

    public int getCurrentUploads() {
        return this.info.getCurrentUploads();
    }

    class ShareConnectionListener
    implements ConnectionListener {
        ShareConnectionListener() {
        }

        public void connectionStarting(ConnectionEvent e) throws ConnectionVetoException {
            GnutellaShareService.this.fireConnectionStartingWithoutVeto(e);
        }

        public void connectionEstablished(ConnectionEvent e) {
            GnutellaShareService.this.fireConnectionEstablished(e);
        }

        public void connectionClosed(ConnectionEvent e) {
            GnutellaShareService.this.fireConnectionClosed(e);
        }
    }

    class ShareFileListener
    extends BaseFileHandler
    implements GnutellaFileListener {
        ShareFileListener() {
        }

        public FileModel getModel() {
            return null;
        }

        public void start() {
        }

        public void handle(Socket socket) throws IOException {
        }

        public TransferRateThrottler getTransferRateThrottler() {
            return null;
        }

        public void shutdown() {
        }

        public void filesizeChanged(FileEvent e) {
            this.fireFilesizeChanged(e);
        }

        public void fileInfoChanged(FileEvent e) {
            this.fireFileInfoChanged(e);
        }

        public void fileTransferFinished(FileEvent e) {
            this.fireFileTransferFinished(e);
        }

        public void fileTransferStarting(FileEvent e) throws TransferVetoException {
            this.fireFileTransferStartingWithoutVeto(e);
        }
    }

    class SearchMessageListener
    implements GnutellaMessageListener {
        SearchMessageListener() {
        }

        public void messageReceived(GnutellaMessageEvent event) {
            GnutellaMessage msg = event.getMessage();
            if (msg.getType() == 128) {
                MsgQuery query = (MsgQuery)msg;
                Collection files = GnutellaShareService.this.info.getShareFileController().getFiles(query);
                if (files == null) {
                    return;
                }
                GnutellaMessageHeader newHeader = new GnutellaMessageHeader(129, msg.getHeader().getMsgID());
                newHeader.setTTL(msg.getHeader().getHopsTaken() + 1);
                MsgQueryResponse response = new MsgQueryResponse(newHeader, GnutellaShareService.this.context);
                Iterator iter = files.iterator();
                try {
                    while (iter.hasNext()) {
                        response.addMsgRecord((MsgResRecord)iter.next());
                        if (response.getNumRecords() < 255 || !iter.hasNext()) continue;
                        event.getConnection().send(response);
                        response = new MsgQueryResponse(newHeader, GnutellaShareService.this.context);
                    }
                    event.getConnection().send(response);
                }
                catch (SendMessageFailedException ex) {
                    // empty catch block
                }
            }
        }
    }

    class FirewalledUploadMessageListener
    implements GnutellaMessageListener {
        FirewalledUploadMessageListener() {
        }

        public void messageReceived(GnutellaMessageEvent event) {
            GnutellaMessage msg = event.getMessage();
            if (msg.getType() == 64) {
                MsgPushRequest push = (MsgPushRequest)msg;
                int fileidx = push.getFileIndex();
                String path = GnutellaShareService.this.info.getShareFileController().getFilePath(fileidx);
                String filename = GnutellaShareService.this.info.getShareFileController().getFilename(fileidx);
                if (path == null || filename == null) {
                    return;
                }
                if (!GnutellaShareService.this.info.incrementCurrentUploads()) {
                    return;
                }
                GnutellaFileModel filemodel = new GnutellaFileModel(filename, path, fileidx);
                File file = new File(path);
                if (!file.exists()) {
                    return;
                }
                filemodel.setFilesize(file.length());
                GnutellaConnectionModel cmodel = new GnutellaConnectionModel(push.getRemoteHost(), (int)push.getRemotePort(), 1);
                filemodel.setConnectionModel(cmodel);
                GnutellaFirewalledUploadHandler handler = new GnutellaFirewalledUploadHandler(GnutellaShareService.this.context, filemodel, GnutellaShareService.this.context.getClientID());
                SocketConnector connector = new SocketConnector(handler);
                handler.addFileListener(GnutellaShareService.this.info.getFileListener());
                connector.addConnectionListener(new ShareConnectionListener(this){
                    private final /* synthetic */ FirewalledUploadMessageListener this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void connectionClosed(ConnectionEvent e) {
                        GnutellaShareService.access$000(FirewalledUploadMessageListener.access$200(this.this$1)).decrementCurrentUploads();
                        super.connectionClosed(e);
                    }
                });
                connector.aconnect(cmodel);
            }
        }

        static /* synthetic */ GnutellaShareService access$200(FirewalledUploadMessageListener x0) {
            return x0.GnutellaShareService.this;
        }
    }
}

