/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.gnutella;

import com.echomine.common.ParseException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;

public class Host {
    private InetAddress host;
    private int port;

    public Host() {
    }

    public Host(String host, int port) throws UnknownHostException {
        this.host = InetAddress.getByName(host);
        this.port = port;
    }

    public Host(InetAddress host, int port) {
        this.host = host;
        this.port = port;
    }

    public void deserialize(String hostport) throws ParseException {
        StringTokenizer tokens = new StringTokenizer(hostport, ":");
        try {
            this.host = InetAddress.getByName(tokens.nextToken());
            this.port = Integer.parseInt(tokens.nextToken());
        }
        catch (Exception ex) {
            throw new ParseException("Error Parsing String");
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public InetAddress getHost() {
        return this.host;
    }

    public void setHost(InetAddress host) {
        this.host = host;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Host)) {
            return false;
        }
        Host h = (Host)obj;
        if (this.port != h.getPort()) {
            return false;
        }
        return this.host.getHostAddress().equals(h.getHost().getHostAddress());
    }

    public boolean isPortValid() {
        return this.port > 0;
    }

    public String toString() {
        return this.host.getHostAddress() + ":" + this.port;
    }
}

