/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.gnutella;

import com.echomine.common.ParseException;
import com.echomine.gnutella.GnutellaConnection;
import com.echomine.gnutella.GnutellaMessage;
import com.echomine.gnutella.GnutellaMessageHeader;
import com.echomine.gnutella.MessageRouterController;
import com.echomine.util.IPUtil;
import com.echomine.util.ParseUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class MsgInitResponse
extends GnutellaMessage {
    private static final int sDataLength = 14;
    private short port = 0;
    private InetAddress IP = null;
    private int fileCount = 0;
    private int totalSize = 0;

    public MsgInitResponse(GnutellaMessageHeader header) {
        super(header);
    }

    public void setPort(short port) {
        this.port = port;
    }

    public short getPort() {
        return this.port;
    }

    public void setIP(InetAddress IP) {
        this.IP = IP;
    }

    public InetAddress getIP() {
        return this.IP;
    }

    public void setFileCount(int fileCount) {
        this.fileCount = fileCount;
    }

    public int getFileCount() {
        return this.fileCount;
    }

    public void setTotalSize(int totalSize) {
        this.totalSize = totalSize;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public int getSize() {
        return super.getSize() + 14;
    }

    public void copy(MsgInitResponse b) {
        super.copy(b);
        this.port = b.port;
        this.IP = b.IP;
        this.fileCount = b.fileCount;
        this.totalSize = b.totalSize;
    }

    public int serialize(byte[] outbuf, int offset) throws ParseException {
        offset = super.serialize(outbuf, offset);
        offset = ParseUtil.serializeShortLE(this.port, outbuf, offset);
        System.arraycopy(this.IP.getAddress(), 0, outbuf, offset, 4);
        offset += 4;
        offset = ParseUtil.serializeIntLE(this.fileCount, outbuf, offset);
        offset = ParseUtil.serializeIntLE(this.totalSize, outbuf, offset);
        return offset;
    }

    public int deserialize(byte[] inbuf, int offset, int length) throws ParseException {
        try {
            if (length != 14) {
                throw new ParseException("Invalid Pong Message");
            }
            offset = super.deserialize(inbuf, offset, length);
            this.port = ParseUtil.deserializeShortLE(inbuf, offset);
            offset += 2;
            StringBuffer strBuf = new StringBuffer();
            offset = IPUtil.deserializeIP(inbuf, offset, strBuf);
            this.IP = InetAddress.getByName(strBuf.toString());
            this.fileCount = ParseUtil.deserializeIntLE(inbuf, offset);
            this.totalSize = ParseUtil.deserializeIntLE(inbuf, offset += 4);
        }
        catch (UnknownHostException ex) {
            throw new ParseException(ex.getMessage());
        }
        return offset += 4;
    }

    public String toString() {
        return "[" + this.header + " " + "Port=" + this.port + ", " + "IP=" + this.IP.getHostAddress() + ", " + "FileCount=" + this.fileCount + ", " + "TotalSize=" + this.totalSize + "]";
    }

    public void route(GnutellaConnection connection, MessageRouterController controller) {
        GnutellaConnection receiver = controller.getMessageRouting(this);
        if (receiver == null) {
            return;
        }
        controller.routeMessage(receiver, this);
    }
}

