/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.gnutella;

import com.echomine.common.ParseException;
import com.echomine.gnutella.GnutellaConnection;
import com.echomine.gnutella.GnutellaMessage;
import com.echomine.gnutella.GnutellaMessageHeader;
import com.echomine.gnutella.MessageRouterController;
import com.echomine.util.ParseUtil;

public class MsgQuery
extends GnutellaMessage {
    private short minSpeed = Short.MAX_VALUE;
    private String searchString;
    private String extendedQueryBlock = "";

    public MsgQuery() {
        this(new GnutellaMessageHeader(128));
    }

    public MsgQuery(GnutellaMessageHeader header) {
        super(header);
        this.minSpeed = 0;
        this.searchString = "";
    }

    public MsgQuery(String searchString) {
        this(searchString, 0);
    }

    public MsgQuery(String searchString, short minSpeed) {
        super(new GnutellaMessageHeader(128));
        this.minSpeed = minSpeed;
        this.searchString = searchString;
    }

    public void setSourceFirewalled(boolean sourceBehindFW) {
        this.minSpeed = sourceBehindFW ? (short)(this.minSpeed | 0x4000) : (short)(this.minSpeed & 0xFFFFBFFF);
    }

    public void setAcceptMetadata(boolean acceptMD) {
        this.minSpeed = acceptMD ? (short)(this.minSpeed | 0x2000) : (short)(this.minSpeed & 0xFFFFDFFF);
    }

    public void setMinSpeed(short minSpeed) {
        this.minSpeed = minSpeed;
    }

    public short getMinSpeed() {
        return this.minSpeed;
    }

    public boolean isSourceFirewalled() {
        return (this.minSpeed & 0x4000) != 0;
    }

    public boolean acceptsMetadata() {
        return (this.minSpeed & 0x2000) != 0;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public int getSize() {
        return super.getSize() + 2 + this.searchString.length() + this.extendedQueryBlock.length() + 2;
    }

    public void copy(MsgQuery b) {
        super.copy(b);
        this.minSpeed = b.minSpeed;
        this.searchString = b.searchString;
    }

    public void setExtensionBlock(String extBlock) {
        this.extendedQueryBlock = extBlock == null ? "" : extBlock;
    }

    public String getExtensionBlock() {
        return this.extendedQueryBlock;
    }

    public int serialize(byte[] outbuf, int offset) throws ParseException {
        offset = super.serialize(outbuf, offset);
        offset = ParseUtil.serializeShortLE(this.minSpeed, outbuf, offset);
        offset = ParseUtil.serializeString(this.searchString, outbuf, offset);
        outbuf[offset++] = 0;
        if (this.extendedQueryBlock != null && this.extendedQueryBlock.length() > 0) {
            offset = ParseUtil.serializeString(this.extendedQueryBlock, outbuf, offset);
        }
        outbuf[offset++] = 0;
        return offset;
    }

    public int deserialize(byte[] inbuf, int offset, int length) throws ParseException {
        if (length <= 2) {
            throw new ParseException("Invalid Query Message");
        }
        offset = super.deserialize(inbuf, offset, length);
        this.minSpeed = ParseUtil.deserializeShortLE(inbuf, offset);
        offset += 2;
        StringBuffer buf = new StringBuffer();
        if ((offset = ParseUtil.deserializeString(inbuf, offset, buf)) < inbuf.length && inbuf[offset] == 0) {
            ++offset;
        }
        this.searchString = buf.toString();
        if (offset < inbuf.length && inbuf[offset] == 0) {
            return offset;
        }
        buf = new StringBuffer();
        if ((offset = ParseUtil.deserializeString(inbuf, offset, buf)) < inbuf.length && inbuf[offset] == 0) {
            ++offset;
        }
        this.extendedQueryBlock = buf.toString();
        return offset;
    }

    public String toString() {
        return "[" + this.header + " " + "MinSpeed=" + this.minSpeed + ", " + "SearchString=" + this.searchString + ", Extended=" + this.extendedQueryBlock + "]";
    }

    public void route(GnutellaConnection connection, MessageRouterController controller) {
        if (controller.checkAndAddMsgSeen(this) || controller.isMsgOwner(this)) {
            return;
        }
        controller.enableMessageRouting(this, connection);
        controller.routeMessageToAllExcept(connection, this);
    }
}

