/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.gnutella;

import com.echomine.common.ParseException;
import com.echomine.gnutella.GUID;
import com.echomine.gnutella.GnutellaConnection;
import com.echomine.gnutella.GnutellaContext;
import com.echomine.gnutella.GnutellaMessage;
import com.echomine.gnutella.GnutellaMessageHeader;
import com.echomine.gnutella.MessageRouterController;
import com.echomine.gnutella.MsgResRecord;
import com.echomine.util.IPUtil;
import com.echomine.util.ParseUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;

public class MsgQueryResponse
extends GnutellaMessage {
    private short remotePort;
    private int numRecords = 0;
    private InetAddress remoteHost;
    private int remoteHostSpeed;
    private GUID remoteClientID;
    private Vector records;

    public MsgQueryResponse(GnutellaMessageHeader header) {
        super(header);
        this.remotePort = 0;
        this.remoteHost = null;
        this.remoteHostSpeed = 0;
        this.remoteClientID = null;
        this.records = new Vector();
    }

    public MsgQueryResponse(GnutellaMessageHeader header, GnutellaContext context) {
        super(header);
        this.remotePort = context.getPort();
        try {
            this.remoteHost = context.getInterfaceIP();
            if (this.remoteHost == null) {
                this.remoteHost = InetAddress.getLocalHost();
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.remoteHostSpeed = context.getLineSpeed();
        this.remoteClientID = context.getClientID();
        this.records = new Vector();
    }

    public int getNumRecords() {
        return this.numRecords;
    }

    public short getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(short remotePort) {
        this.remotePort = remotePort;
    }

    public InetAddress getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(InetAddress remoteHost) {
        this.remoteHost = remoteHost;
    }

    public int getRemoteHostSpeed() {
        return this.remoteHostSpeed;
    }

    public void setRemoteHostSpeed(int remoteHostSpeed) {
        this.remoteHostSpeed = remoteHostSpeed;
    }

    public GUID getRemoteClientID() {
        return this.remoteClientID;
    }

    public void setRemoteClientID(GUID remoteClientID) {
        this.remoteClientID = remoteClientID;
    }

    public void addMsgRecord(MsgResRecord record) {
        this.records.addElement(record);
        this.numRecords = this.records.size();
    }

    public MsgResRecord getMsgRecord(int i) {
        return (MsgResRecord)this.records.elementAt(i);
    }

    public int getSize() {
        int size = super.getSize() + 4 + 2 + 4 + 4 + this.remoteClientID.getSize();
        for (int i = 0; i < this.numRecords; ++i) {
            MsgResRecord rec = (MsgResRecord)this.records.elementAt(i);
            size += rec.getSize();
        }
        return size;
    }

    public void copy(MsgQueryResponse b) {
        super.copy(b);
        this.numRecords = b.numRecords;
        this.remotePort = b.remotePort;
        this.remoteHost = b.remoteHost;
        this.remoteHostSpeed = b.remoteHostSpeed;
        this.remoteClientID = b.remoteClientID;
        int size = b.getNumRecords();
        for (int i = 0; i < size; ++i) {
            MsgResRecord rec = new MsgResRecord();
            rec.copy(b.getMsgRecord(i));
            this.addMsgRecord(rec);
        }
    }

    public int serialize(byte[] outbuf, int offset) throws ParseException {
        offset = super.serialize(outbuf, offset);
        outbuf[offset++] = (byte)this.numRecords;
        offset = ParseUtil.serializeShortLE(this.remotePort, outbuf, offset);
        System.arraycopy(this.remoteHost.getAddress(), 0, outbuf, offset, 4);
        offset += 4;
        offset = ParseUtil.serializeIntLE(this.remoteHostSpeed, outbuf, offset);
        for (int i = 0; i < this.numRecords; ++i) {
            offset = this.getMsgRecord(i).serialize(outbuf, offset);
        }
        offset = this.remoteClientID.serialize(outbuf, offset);
        return offset;
    }

    public int deserialize(byte[] inbuf, int offset, int length) throws ParseException {
        try {
            int n;
            if (length <= 11) {
                throw new ParseException("Invalid Query Response Message");
            }
            int end = length + offset;
            offset = super.deserialize(inbuf, offset, length);
            this.numRecords = (n = inbuf[offset++]) < 0 ? 256 + n : n;
            this.remotePort = ParseUtil.deserializeShortLE(inbuf, offset);
            offset += 2;
            StringBuffer strBuf = new StringBuffer();
            offset = IPUtil.deserializeIP(inbuf, offset, strBuf);
            this.remoteHost = InetAddress.getByName(strBuf.toString());
            this.remoteHostSpeed = ParseUtil.deserializeIntLE(inbuf, offset);
            offset += 4;
            for (int i = 0; i < this.numRecords; ++i) {
                MsgResRecord rec = new MsgResRecord();
                offset = rec.deserialize(inbuf, offset);
                this.records.addElement(rec);
            }
            if (this.remoteClientID == null) {
                this.remoteClientID = new GUID();
            }
            try {
                offset = this.remoteClientID.deserialize(inbuf, end - 16);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                System.out.println("ArrayIndexOutOfBounds: buflen=" + inbuf.length + ",end=" + end + ",length=" + length);
            }
        }
        catch (UnknownHostException ex) {
            throw new ParseException(ex.getMessage());
        }
        return offset;
    }

    public String getRemoteHostStr() {
        return this.remoteHost.getHostAddress() + ":" + this.remotePort;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(256);
        buf.append("[" + this.header + " " + "NumRecords=" + this.numRecords + ", " + "RemotePort=" + this.remotePort + ", " + "RemoteHost=" + this.remoteHost.getHostAddress() + ", " + "RemoteHostSpeed=" + this.remoteHostSpeed + ", " + "RemoteClientID=" + this.remoteClientID + ", " + "Records=");
        for (int i = 0; i < this.numRecords; ++i) {
            buf.append(this.getMsgRecord(i)).append(" ");
        }
        buf.append("]");
        return buf.toString();
    }

    public void route(GnutellaConnection connection, MessageRouterController controller) {
        if (controller.isMsgOwner(this)) {
            return;
        }
        GnutellaConnection receiver = controller.getMessageRouting(this);
        if (receiver == null) {
            return;
        }
        controller.enablePushRequestRouting(this.getRemoteClientID(), connection);
        controller.routeMessage(receiver, this);
    }
}

