/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.gnutella;

import com.echomine.common.ParseException;
import com.echomine.util.ParseUtil;

public class MsgResRecord {
    private int fileIndex = 0;
    private String filename = "";
    private int filesize = 0;
    private String extensionBlock = "";

    public MsgResRecord() {
    }

    public MsgResRecord(int fileIndex, int filesize, String fileName) {
        this.fileIndex = fileIndex;
        this.filesize = filesize;
        this.filename = fileName;
    }

    public MsgResRecord(int fileIndex, int filesize, String fileName, String extensionBlock) {
        this.fileIndex = fileIndex;
        this.filesize = filesize;
        this.filename = fileName;
        this.extensionBlock = extensionBlock;
    }

    public void setFileIndex(int fileIndex) {
        this.fileIndex = fileIndex;
    }

    public int getFileIndex() {
        return this.fileIndex;
    }

    public int getFilesize() {
        return this.filesize;
    }

    public void setFilesize(int filesize) {
        this.filesize = filesize;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getExtensionblock() {
        return this.extensionBlock;
    }

    public void setExtensionblock(String extensionBlock) {
        this.extensionBlock = extensionBlock;
    }

    public int getSize() {
        return 8 + this.filename.length() + (this.extensionBlock == null ? 0 : this.extensionBlock.length()) + 2;
    }

    public void copy(MsgResRecord b) {
        this.fileIndex = b.fileIndex;
        this.filesize = b.filesize;
        this.filename = b.filename;
    }

    public int serialize(byte[] outbuf, int offset) throws ParseException {
        offset = ParseUtil.serializeIntLE(this.fileIndex, outbuf, offset);
        offset = ParseUtil.serializeIntLE(this.filesize, outbuf, offset);
        offset = ParseUtil.serializeString(this.filename, outbuf, offset);
        outbuf[offset++] = 0;
        if (this.extensionBlock != null && this.extensionBlock.length() > 0) {
            offset = ParseUtil.serializeString(this.extensionBlock, outbuf, offset);
        }
        outbuf[offset++] = 0;
        return offset;
    }

    public int deserialize(byte[] inbuf, int offset) throws ParseException {
        this.fileIndex = ParseUtil.deserializeIntLE(inbuf, offset);
        this.filesize = ParseUtil.deserializeIntLE(inbuf, offset += 4);
        offset += 4;
        StringBuffer buf = new StringBuffer();
        offset = ParseUtil.deserializeString(inbuf, offset, buf);
        this.filename = buf.toString();
        if (inbuf[offset] == 0 && offset < inbuf.length) {
            ++offset;
        }
        buf = new StringBuffer();
        offset = ParseUtil.deserializeString(inbuf, offset, buf);
        this.extensionBlock = buf.toString();
        if (inbuf[offset] == 0 && offset < inbuf.length) {
            ++offset;
        }
        return offset;
    }

    public String toString() {
        return "[FileIndex=" + this.fileIndex + ", " + "FileSize=" + this.filesize + ", " + "Filename=" + this.filename + ", " + "ExtensionBlock=" + this.extensionBlock + "]";
    }
}

