/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.gnutella.impl;

import com.echomine.common.SendMessageFailedException;
import com.echomine.gnutella.GUID;
import com.echomine.gnutella.GnutellaConnection;
import com.echomine.gnutella.GnutellaConnectionModel;
import com.echomine.gnutella.GnutellaConnectionStatisticsListener;
import com.echomine.gnutella.GnutellaContext;
import com.echomine.gnutella.GnutellaMessage;
import com.echomine.gnutella.GnutellaMessageEvent;
import com.echomine.gnutella.GnutellaMessageListener;
import com.echomine.gnutella.GnutellaProtocolFactory;
import com.echomine.gnutella.GnutellaProtocolSocketHandler;
import com.echomine.gnutella.IConnectionList;
import com.echomine.gnutella.MsgInit;
import com.echomine.gnutella.MsgInitResponse;
import com.echomine.gnutella.RawDataReceivable;
import com.echomine.gnutella.impl.GnutellaMessageReceiver;
import com.echomine.net.TimeableConnection;
import com.echomine.util.HTTPHeader;

public abstract class AbstractGnutellaConnection
extends TimeableConnection
implements GnutellaConnection {
    private MsgInit pingMsg;
    protected RawDataReceivable router;
    protected GnutellaProtocolSocketHandler gnutellaHandler;
    protected GnutellaConnectionModel cmodel;
    protected boolean connected = false;
    protected long messages = 0L;
    protected long files = 0L;
    protected long size = 0L;
    protected int hosts = 0;
    protected GnutellaContext context;
    protected IConnectionList clist;
    static /* synthetic */ Class class$com$echomine$gnutella$GnutellaConnectionStatisticsListener;

    public AbstractGnutellaConnection(GnutellaContext context, int protocolType) {
        this.context = context;
        this.router = new GnutellaMessageReceiver(context.getMessageFactory());
        this.gnutellaHandler = GnutellaProtocolFactory.createHandlerFor(protocolType, this, this.router);
        this.addMessageListener(new StatMessageListener());
    }

    public void send(GnutellaMessage msg) throws SendMessageFailedException {
        if (!this.connected) {
            throw new SendMessageFailedException("Cannot send message...not connected to server");
        }
        this.gnutellaHandler.send(msg);
    }

    public GnutellaConnectionModel getConnectionModel() {
        return this.cmodel;
    }

    public void disconnect() {
        this.gnutellaHandler.shutdown();
    }

    public boolean isConnected() {
        return this.connected;
    }

    public int getProtocolType() {
        return this.gnutellaHandler.getProtocolType();
    }

    public HTTPHeader getSupportedFeatureHeaders() {
        return this.gnutellaHandler.getSupportedFeatureHeaders();
    }

    public HTTPHeader getVendorFeartureHeaders() {
        return this.gnutellaHandler.getVendorFeatureHeaders();
    }

    public void addMessageListener(GnutellaMessageListener l) {
        this.router.addMessageListener(l);
    }

    public void removeMessageListener(GnutellaMessageListener l) {
        this.router.removeMessageListener(l);
    }

    public void addStatisticsListener(GnutellaConnectionStatisticsListener l) {
        this.listenerList.add(class$com$echomine$gnutella$GnutellaConnectionStatisticsListener == null ? (class$com$echomine$gnutella$GnutellaConnectionStatisticsListener = AbstractGnutellaConnection.class$("com.echomine.gnutella.GnutellaConnectionStatisticsListener")) : class$com$echomine$gnutella$GnutellaConnectionStatisticsListener, l);
    }

    public void removeStatisticsListener(GnutellaConnectionStatisticsListener l) {
        this.listenerList.remove(class$com$echomine$gnutella$GnutellaConnectionStatisticsListener == null ? (class$com$echomine$gnutella$GnutellaConnectionStatisticsListener = AbstractGnutellaConnection.class$("com.echomine.gnutella.GnutellaConnectionStatisticsListener")) : class$com$echomine$gnutella$GnutellaConnectionStatisticsListener, l);
    }

    public int getHosts() {
        return this.hosts;
    }

    public long getMessages() {
        return this.messages;
    }

    public long getFiles() {
        return this.files;
    }

    public long getSize() {
        return this.size;
    }

    public void resetStats() {
        this.messages = 0L;
        this.files = 0L;
        this.size = 0L;
        this.hosts = 0;
        this.pingMsg = new MsgInit();
        this.fireConnectionStatsUpdated();
        this.sendPingMsg();
    }

    public GnutellaContext getContext() {
        return this.context;
    }

    void sendPingMsg() {
        this.pingMsg.getHeader().setTTL(5);
        this.gnutellaHandler.send(this.pingMsg);
    }

    void parseStatResponse(MsgInitResponse msgr) {
        GUID pingGUID = this.pingMsg.getHeader().getMsgID();
        if (pingGUID != null && msgr.getHeader().getMsgID().equals(pingGUID)) {
            this.files += (long)msgr.getFileCount();
            this.size += (long)msgr.getTotalSize();
            ++this.hosts;
        }
    }

    protected void fireConnectionStatsUpdated() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$com$echomine$gnutella$GnutellaConnectionStatisticsListener == null ? AbstractGnutellaConnection.class$("com.echomine.gnutella.GnutellaConnectionStatisticsListener") : class$com$echomine$gnutella$GnutellaConnectionStatisticsListener)) continue;
            ((GnutellaConnectionStatisticsListener)listeners[i + 1]).connectionStatsUpdated(this);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class StatMessageListener
    implements GnutellaMessageListener {
        StatMessageListener() {
        }

        public void messageReceived(GnutellaMessageEvent event) {
            ++AbstractGnutellaConnection.this.messages;
            AbstractGnutellaConnection.this.fireConnectionStatsUpdated();
        }
    }
}

