/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.gnutella.impl;

import com.echomine.common.ParseException;
import com.echomine.gnutella.GnutellaConnection;
import com.echomine.gnutella.GnutellaConnectionModel;
import com.echomine.gnutella.GnutellaMessage;
import com.echomine.gnutella.GnutellaMessageHeader;
import com.echomine.gnutella.GnutellaProtocolSocketHandler;
import com.echomine.gnutella.RawDataReceivable;
import com.echomine.gnutella.impl.MessageRequestQueue;
import com.echomine.net.ConnectionThrottler;
import com.echomine.net.HandshakeFailedException;
import com.echomine.util.HTTPHeader;
import com.echomine.util.HTTPResponseHeader;
import com.echomine.util.IOUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractGnutellaProtocol
implements GnutellaProtocolSocketHandler {
    private static Log logger = LogFactory.getLog((Class)(class$com$echomine$gnutella$impl$AbstractGnutellaProtocol == null ? (class$com$echomine$gnutella$impl$AbstractGnutellaProtocol = AbstractGnutellaProtocol.class$("com.echomine.gnutella.impl.AbstractGnutellaProtocol")) : class$com$echomine$gnutella$impl$AbstractGnutellaProtocol));
    private static Log hlogger = LogFactory.getLog((String)"gnutella/protocol/handshake");
    private static Log pingologger = LogFactory.getLog((String)"gnutella/msg/outgoing/ping");
    private static Log pongologger = LogFactory.getLog((String)"gnutella/msg/outgoing/pong");
    private static Log pushologger = LogFactory.getLog((String)"gnutella/msg/outgoing/push");
    private static Log queryologger = LogFactory.getLog((String)"gnutella/msg/outgoing/query");
    private static Log hitologger = LogFactory.getLog((String)"gnutella/msg/outgoing/hit");
    private static Log unknownologger = LogFactory.getLog((String)"gnutella/msg/outgoing/unknown");
    protected static final int SOCKETBUF = 8192;
    boolean shutdown;
    RawDataReceivable receiver;
    GnutellaConnection connection;
    IncomingReaderThread reader;
    HTTPHeader remoteVendorFeatures;
    HTTPHeader remoteSupportedFeatures;
    protected MessageRequestQueue queue = new MessageRequestQueue();
    Socket socket;
    static /* synthetic */ Class class$com$echomine$gnutella$impl$AbstractGnutellaProtocol;

    public AbstractGnutellaProtocol(GnutellaConnection connection, RawDataReceivable receiver) {
        if (connection == null || receiver == null) {
            throw new IllegalArgumentException("GnutellaConnection and RawDataReceivable cannot be null");
        }
        this.receiver = receiver;
        this.connection = connection;
        this.shutdown = false;
    }

    public void handshake(Socket socket) throws HandshakeFailedException {
        this.socket = socket;
        if (hlogger.isInfoEnabled()) {
            hlogger.info((Object)("Initiating handshake with " + socket.getInetAddress().getHostAddress() + ":" + socket.getPort()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Socket socket) throws IOException {
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        try {
            bis = new BufferedInputStream(socket.getInputStream(), 8192);
            bos = new BufferedOutputStream(socket.getOutputStream(), 8192);
            this.reader = new IncomingReaderThread(bis);
            this.reader.start();
            GnutellaConnectionModel cmodel = this.connection.getConnectionModel();
            ConnectionThrottler throttler = cmodel.getThrottler();
            while (!this.shutdown) {
                block7: {
                    GnutellaMessage msg = this.queue.waitForMessage();
                    if (msg != null) {
                        try {
                            this.logOutgoingMessage(msg);
                            byte[] serializedData = msg.serialize();
                            bos.write(serializedData);
                            bos.flush();
                            cmodel.incrementBytesTransferred(serializedData.length);
                        }
                        catch (ParseException ex) {
                            if (!logger.isWarnEnabled()) break block7;
                            logger.warn((Object)"parse error occurred while serializing outgoing message", (Throwable)ex);
                        }
                    }
                }
                if (throttler != null && !this.shutdown) {
                    throttler.throttle(cmodel);
                    continue;
                }
                Thread.currentThread();
                Thread.yield();
            }
            this.shutdown();
        }
        catch (Throwable throwable) {
            this.shutdown();
            IOUtil.closeStream(bos);
            IOUtil.closeStream(bis);
            throw throwable;
        }
        IOUtil.closeStream(bos);
        IOUtil.closeStream(bis);
    }

    public void shutdown() {
        this.shutdown = true;
        this.queue.shutdown();
        IOUtil.closeSocket(this.socket);
    }

    public void start() {
        this.shutdown = false;
        this.queue.clear();
        this.queue.start();
    }

    public void send(GnutellaMessage msg) {
        this.queue.addMessage(msg);
    }

    protected void setSupportedFeatureHeaders(HTTPHeader features) {
        this.remoteSupportedFeatures = features;
    }

    protected void setVendorFeatureHeaders(HTTPHeader features) {
        this.remoteVendorFeatures = features;
    }

    public HTTPHeader getSupportedFeatureHeaders() {
        return this.remoteSupportedFeatures;
    }

    public HTTPHeader getVendorFeatureHeaders() {
        return this.remoteVendorFeatures;
    }

    public GnutellaConnection getConnection() {
        return this.connection;
    }

    protected void logHandshakeHeaders() {
        HTTPResponseHeader headers;
        if (hlogger.isInfoEnabled() && (headers = (HTTPResponseHeader)this.getSupportedFeatureHeaders()) != null) {
            hlogger.info((Object)(this.socket.getInetAddress().getHostAddress() + " Status: " + headers.getStatusMessage() + " (" + headers.getStatusCode() + ")"));
            if (hlogger.isDebugEnabled()) {
                Iterator iter = headers.getHeaderNames().iterator();
                while (iter.hasNext()) {
                    String header = (String)iter.next();
                    String value = headers.getHeader(header);
                    hlogger.debug((Object)("Header " + header + ": " + value));
                }
            }
        }
    }

    protected void logOutgoingMessage(GnutellaMessage msg) {
        switch (msg.getType()) {
            case 0: {
                if (!pingologger.isDebugEnabled()) break;
                pingologger.debug((Object)msg);
                break;
            }
            case 1: {
                if (!pongologger.isDebugEnabled()) break;
                pongologger.debug((Object)msg);
                break;
            }
            case 64: {
                if (!pushologger.isDebugEnabled()) break;
                pushologger.debug((Object)msg);
                break;
            }
            case 128: {
                if (!queryologger.isDebugEnabled()) break;
                queryologger.debug((Object)msg);
                break;
            }
            case 129: {
                if (!hitologger.isDebugEnabled()) break;
                hitologger.debug((Object)msg);
                break;
            }
            default: {
                if (!unknownologger.isDebugEnabled()) break;
                unknownologger.debug((Object)msg);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class IncomingReaderThread
    extends Thread {
        private InputStream is;

        public IncomingReaderThread(InputStream is) {
            this.is = is;
        }

        public void run() {
            byte[] header_data = new byte[23];
            byte[] data = new byte[64];
            int headerCount = 0;
            int dataLength = 0;
            int amountRead = 0;
            int currentRead = 0;
            while (!AbstractGnutellaProtocol.this.shutdown) {
                try {
                    if (AbstractGnutellaProtocol.this.shutdown || (headerCount = this.is.read(header_data, 0, 23)) == -1) {
                        AbstractGnutellaProtocol.this.shutdown();
                        break;
                    }
                    if (headerCount != 23) continue;
                    GnutellaMessageHeader header = new GnutellaMessageHeader();
                    header.deserialize(header_data, 0);
                    dataLength = header.getDataLen();
                    if (dataLength > 32768) {
                        AbstractGnutellaProtocol.this.shutdown();
                        break;
                    }
                    if (dataLength > data.length) {
                        data = new byte[dataLength];
                    }
                    amountRead = 0;
                    currentRead = 0;
                    GnutellaConnectionModel cmodel = AbstractGnutellaProtocol.this.connection.getConnectionModel();
                    ConnectionThrottler throttler = cmodel.getThrottler();
                    while (amountRead < dataLength && currentRead != -1 && !AbstractGnutellaProtocol.this.shutdown) {
                        currentRead = this.is.read(data, amountRead, dataLength - amountRead);
                        if (currentRead != -1) {
                            amountRead += currentRead;
                        }
                        cmodel.incrementBytesTransferred(amountRead);
                        Thread.currentThread();
                        Thread.yield();
                    }
                    if (!AbstractGnutellaProtocol.this.shutdown) {
                        AbstractGnutellaProtocol.this.receiver.receive(AbstractGnutellaProtocol.this.connection, header, data);
                    }
                    if (throttler != null && !AbstractGnutellaProtocol.this.shutdown) {
                        throttler.throttle(AbstractGnutellaProtocol.this.connection.getConnectionModel());
                        continue;
                    }
                    Thread.currentThread();
                    Thread.yield();
                }
                catch (Exception ex) {
                    AbstractGnutellaProtocol.this.shutdown();
                }
            }
        }
    }
}

