/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.gnutella.impl;

import com.echomine.common.SendMessageFailedException;
import com.echomine.gnutella.GnutellaConnection;
import com.echomine.gnutella.GnutellaConnectionEvent;
import com.echomine.gnutella.GnutellaConnectionModel;
import com.echomine.gnutella.GnutellaMessage;
import com.echomine.gnutella.GnutellaMessageEvent;
import com.echomine.gnutella.GnutellaMessageListener;
import com.echomine.gnutella.IConnectionList;
import com.echomine.gnutella.IRestrictedHostCallback;
import com.echomine.net.Connection;
import com.echomine.net.ConnectionEvent;
import com.echomine.net.ConnectionListener;
import com.echomine.net.ConnectionModel;
import com.echomine.net.ConnectionVetoException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.EventListenerList;

public class ConnectionListImpl
extends Connection
implements IConnectionList {
    boolean shutdown;
    ArrayList activeConnections;
    ArrayList establishedConnections;
    ConnectionListener listConnListener;
    GnutellaMessageListener listMsgListener;
    HashMap ipList;
    int maxIncomingConnections = 2;
    int maxOutgoingConnections = 10;
    int currentIncomingConnections;
    int currentOutgoingConnections;
    IRestrictedHostCallback restrictedHostCallback;
    EventListenerList msglistenerlist = new EventListenerList();
    static /* synthetic */ Class class$com$echomine$gnutella$GnutellaMessageListener;

    public ConnectionListImpl() {
        this.activeConnections = new ArrayList(30);
        this.establishedConnections = new ArrayList(30);
        this.ipList = new HashMap();
        this.listConnListener = new ListConnectionListener();
        this.listMsgListener = new ListMessageListener();
    }

    public int getActiveConnectionsCount() {
        return this.activeConnections.size();
    }

    public int getEstablishedConnectionsCount() {
        return this.establishedConnections.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GnutellaConnection getActiveConnection(ConnectionModel model) {
        GnutellaConnection connection = null;
        ArrayList arrayList = this.activeConnections;
        synchronized (arrayList) {
            int size = this.activeConnections.size();
            for (int i = 0; i < size && !model.equals((connection = (GnutellaConnection)this.activeConnections.get(i)).getConnectionModel()); ++i) {
            }
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GnutellaConnection getEstablishedConnection(ConnectionModel model) {
        GnutellaConnection connection = null;
        ArrayList arrayList = this.establishedConnections;
        synchronized (arrayList) {
            int size = this.establishedConnections.size();
            for (int i = 0; i < size && !model.equals((connection = (GnutellaConnection)this.establishedConnections.get(i)).getConnectionModel()); ++i) {
            }
        }
        return connection;
    }

    public List getActiveConnections() {
        return (ArrayList)this.activeConnections.clone();
    }

    public List getEstablishedConnections() {
        return (ArrayList)this.establishedConnections.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessageToAll(GnutellaMessage msg) {
        ArrayList arrayList = this.establishedConnections;
        synchronized (arrayList) {
            int size = this.establishedConnections.size();
            for (int i = 0; i < size; ++i) {
                GnutellaConnection connection = (GnutellaConnection)this.establishedConnections.get(i);
                try {
                    connection.send(msg);
                    continue;
                }
                catch (SendMessageFailedException ex) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessageToAllExcept(GnutellaMessage msg, GnutellaConnection exceptConn) {
        ArrayList arrayList = this.establishedConnections;
        synchronized (arrayList) {
            int size = this.establishedConnections.size();
            for (int i = 0; i < size; ++i) {
                GnutellaConnection connection = (GnutellaConnection)this.establishedConnections.get(i);
                if (connection == exceptConn) continue;
                try {
                    connection.send(msg);
                    continue;
                }
                catch (SendMessageFailedException ex) {
                    // empty catch block
                }
            }
        }
    }

    public void setRestrictedHostCallback(IRestrictedHostCallback callback) {
        this.restrictedHostCallback = callback;
    }

    public boolean isHostRestricted(InetAddress host) {
        if (this.restrictedHostCallback == null) {
            return false;
        }
        return this.restrictedHostCallback.isHostRestricted(host);
    }

    public void setMaxOutgoingConnections(int maxOutgoingConnections) {
        this.maxOutgoingConnections = maxOutgoingConnections;
    }

    public int getMaxOutgoingConnections() {
        return this.maxOutgoingConnections;
    }

    public void setMaxIncomingConnections(int maxIncomingConnections) {
        this.maxIncomingConnections = maxIncomingConnections;
    }

    public int getMaxIncomingConnections() {
        return this.maxIncomingConnections;
    }

    public boolean isMaxOutgoingReached() {
        return this.currentOutgoingConnections >= this.maxOutgoingConnections;
    }

    public boolean isMaxIncomingReached() {
        return this.currentIncomingConnections >= this.maxIncomingConnections;
    }

    public boolean addConnection(GnutellaConnection conn, GnutellaConnectionModel cmodel) {
        if (this.shutdown) {
            return false;
        }
        if (this.activeConnections.contains(conn)) {
            return false;
        }
        if (this.ipList.containsKey(cmodel.getHostAddress())) {
            return false;
        }
        conn.addConnectionListener(this.listConnListener);
        return true;
    }

    public void start() {
        this.shutdown = false;
        this.ipList.clear();
        this.activeConnections.clear();
        this.establishedConnections.clear();
    }

    public void shutdown() {
        this.shutdown = true;
        Iterator iter = this.getActiveConnections().iterator();
        while (iter.hasNext()) {
            GnutellaConnection conn = (GnutellaConnection)iter.next();
            conn.disconnect();
        }
    }

    public void addMessageListener(GnutellaMessageListener l) {
        this.msglistenerlist.add(class$com$echomine$gnutella$GnutellaMessageListener == null ? (class$com$echomine$gnutella$GnutellaMessageListener = ConnectionListImpl.class$("com.echomine.gnutella.GnutellaMessageListener")) : class$com$echomine$gnutella$GnutellaMessageListener, l);
    }

    public void removeMessageListener(GnutellaMessageListener l) {
        this.msglistenerlist.remove(class$com$echomine$gnutella$GnutellaMessageListener == null ? (class$com$echomine$gnutella$GnutellaMessageListener = ConnectionListImpl.class$("com.echomine.gnutella.GnutellaMessageListener")) : class$com$echomine$gnutella$GnutellaMessageListener, l);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ListConnectionListener
    implements ConnectionListener {
        ListConnectionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connectionStarting(ConnectionEvent e) throws ConnectionVetoException {
            Object object;
            ConnectionListImpl.this.ipList.put(e.getConnectionModel().getHostAddress(), null);
            GnutellaConnection conn = ((GnutellaConnectionEvent)e).getConnection();
            GnutellaConnectionModel model = (GnutellaConnectionModel)e.getConnectionModel();
            boolean maxReached = false;
            switch (model.getConnectionType()) {
                case 2: {
                    object = this;
                    synchronized (object) {
                        if (ConnectionListImpl.this.currentIncomingConnections >= ConnectionListImpl.this.maxIncomingConnections) {
                            maxReached = true;
                        }
                        ++ConnectionListImpl.this.currentIncomingConnections;
                        break;
                    }
                }
                case 1: {
                    object = this;
                    synchronized (object) {
                        if (ConnectionListImpl.this.currentOutgoingConnections >= ConnectionListImpl.this.maxOutgoingConnections) {
                            maxReached = true;
                        }
                        ++ConnectionListImpl.this.currentOutgoingConnections;
                        break;
                    }
                }
            }
            object = ConnectionListImpl.this.activeConnections;
            synchronized (object) {
                ConnectionListImpl.this.activeConnections.add(conn);
            }
            conn.addMessageListener(ConnectionListImpl.this.listMsgListener);
            ConnectionListImpl.this.fireConnectionStartingWithoutVeto(e);
            if (maxReached) {
                throw new ConnectionVetoException("Max Connection Reached!");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connectionEstablished(ConnectionEvent e) {
            GnutellaConnection conn = ((GnutellaConnectionEvent)e).getConnection();
            ArrayList arrayList = ConnectionListImpl.this.establishedConnections;
            synchronized (arrayList) {
                ConnectionListImpl.this.establishedConnections.add(conn);
            }
            ConnectionListImpl.this.fireConnectionEstablished(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connectionClosed(ConnectionEvent e) {
            GnutellaConnection conn = ((GnutellaConnectionEvent)e).getConnection();
            conn.removeConnectionListener(this);
            ArrayList arrayList = ConnectionListImpl.this.activeConnections;
            synchronized (arrayList) {
                ConnectionListImpl.this.activeConnections.remove(conn);
            }
            arrayList = ConnectionListImpl.this.establishedConnections;
            synchronized (arrayList) {
                ConnectionListImpl.this.establishedConnections.remove(conn);
            }
            ConnectionListImpl.this.fireConnectionClosed(e);
            GnutellaConnectionModel model = (GnutellaConnectionModel)e.getConnectionModel();
            switch (model.getConnectionType()) {
                case 2: {
                    --ConnectionListImpl.this.currentIncomingConnections;
                    break;
                }
                case 1: {
                    --ConnectionListImpl.this.currentOutgoingConnections;
                }
            }
            conn.removeMessageListener(ConnectionListImpl.this.listMsgListener);
            ConnectionListImpl.this.ipList.remove(e.getConnectionModel().getHostAddress());
        }
    }

    class ListMessageListener
    implements GnutellaMessageListener {
        ListMessageListener() {
        }

        protected void fireMessageReceived(GnutellaMessageEvent event) {
            Object[] listeners = ConnectionListImpl.this.msglistenerlist.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != (class$com$echomine$gnutella$GnutellaMessageListener == null ? ConnectionListImpl.class$("com.echomine.gnutella.GnutellaMessageListener") : class$com$echomine$gnutella$GnutellaMessageListener)) continue;
                ((GnutellaMessageListener)listeners[i + 1]).messageReceived(event);
            }
        }

        public void messageReceived(GnutellaMessageEvent event) {
            this.fireMessageReceived(event);
        }
    }
}

