/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.gnutella.impl;

import com.echomine.gnutella.GnutellaConnection;
import com.echomine.gnutella.GnutellaContext;
import com.echomine.gnutella.RawDataReceivable;
import com.echomine.gnutella.impl.AbstractGnutellaProtocol;
import com.echomine.net.HandshakeFailedException;
import com.echomine.util.HTTPHeader;
import com.echomine.util.HTTPResponseHeader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class GnutellaAcceptorProtocolV06
extends AbstractGnutellaProtocol {
    protected static final byte[] RESPONSE_STRING = "GNUTELLA/0.6 200 OK\r\n".getBytes();

    public GnutellaAcceptorProtocolV06(GnutellaConnection connection, RawDataReceivable receiver) {
        super(connection, receiver);
    }

    public void handshake(Socket socket) throws HandshakeFailedException {
        super.handshake(socket);
        try {
            GnutellaContext context = this.getConnection().getContext();
            OutputStream os = socket.getOutputStream();
            InputStream is = socket.getInputStream();
            HTTPHeader supportedFeatures = new HTTPHeader();
            supportedFeatures.parseHeaders(is);
            this.setSupportedFeatureHeaders(supportedFeatures);
            os.write(RESPONSE_STRING);
            if (context.getSupportedFeatureHeaders() != null) {
                os.write(context.getSupportedFeatureHeaders().getHeadersAsString().getBytes());
            }
            if (context.getVendorFeatureHeaders() != null) {
                os.write(context.getVendorFeatureHeaders().getHeadersAsString().getBytes());
            }
            os.write("\r\n".getBytes());
            HTTPResponseHeader vendorFeatures = new HTTPResponseHeader();
            vendorFeatures.parse(is);
            this.setVendorFeatureHeaders(vendorFeatures);
            if (vendorFeatures.getStatusCode() != 200) {
                throw new HandshakeFailedException("Bad Status Code During Handshake");
            }
        }
        catch (IOException ex) {
            throw new HandshakeFailedException(ex.getMessage());
        }
        this.logHandshakeHeaders();
    }

    public int getProtocolType() {
        return 2;
    }
}

