/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.gnutella.impl;

import com.echomine.gnutella.GnutellaConnectionEvent;
import com.echomine.gnutella.GnutellaConnectionModel;
import com.echomine.gnutella.GnutellaContext;
import com.echomine.gnutella.impl.AbstractGnutellaConnection;
import com.echomine.net.ConnectionEvent;
import com.echomine.net.ConnectionFailedException;
import com.echomine.net.ConnectionListener;
import com.echomine.net.ConnectionModel;
import com.echomine.net.ConnectionVetoException;
import com.echomine.net.HandshakeableSocketConnector;

public class GnutellaConnectorConnection
extends AbstractGnutellaConnection {
    private HandshakeableSocketConnector gnutellaConnector;

    public GnutellaConnectorConnection(GnutellaContext context, int protocolType) {
        super(context, protocolType);
        this.gnutellaConnector = new HandshakeableSocketConnector(this.gnutellaHandler);
        this.gnutellaConnector.addConnectionListener(new GnutellaConnectionListener());
    }

    public void connect(GnutellaConnectionModel cmodel) throws ConnectionFailedException {
        if (this.connected) {
            return;
        }
        this.cmodel = cmodel;
        this.gnutellaConnector.connect(cmodel);
    }

    class GnutellaConnectionListener
    implements ConnectionListener {
        GnutellaConnectionListener() {
        }

        public void connectionStarting(ConnectionEvent e) throws ConnectionVetoException {
            GnutellaConnectionEvent vetoEvent = new GnutellaConnectionEvent((ConnectionModel)GnutellaConnectorConnection.this.cmodel, 5, GnutellaConnectorConnection.this);
            GnutellaConnectorConnection.this.fireConnectionStarting(new GnutellaConnectionEvent(e, GnutellaConnectorConnection.this), vetoEvent);
        }

        public void connectionEstablished(ConnectionEvent e) {
            GnutellaConnectorConnection.this.connected = true;
            GnutellaConnectorConnection.this.fireConnectionEstablished(new GnutellaConnectionEvent(e, GnutellaConnectorConnection.this));
            GnutellaConnectorConnection.this.resetStats();
        }

        public void connectionClosed(ConnectionEvent e) {
            GnutellaConnectorConnection.this.connected = false;
            GnutellaConnectorConnection.this.fireConnectionClosed(new GnutellaConnectionEvent(e, GnutellaConnectorConnection.this));
        }
    }
}

