/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.gnutella.impl;

import com.echomine.gnutella.GnutellaContext;
import com.echomine.gnutella.GnutellaFileHandler;
import com.echomine.gnutella.GnutellaFileModel;
import com.echomine.net.FileEvent;
import com.echomine.net.TransferRateThrottler;
import com.echomine.net.TransferVetoException;
import com.echomine.util.HTTPRequestHeader;
import com.echomine.util.HTTPResponseHeader;
import com.echomine.util.IOUtil;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.net.Socket;
import org.apache.oro.text.perl.Perl5Util;

public class GnutellaDirectDownloadHandler
extends GnutellaFileHandler {
    protected static final int SOCKETBUF = 8192;
    private boolean shutdown = false;
    private Perl5Util httpContentRangeHeaderRE = new Perl5Util();

    public GnutellaDirectDownloadHandler(GnutellaContext context, GnutellaFileModel model) {
        super(context, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void handle(Socket socket) throws IOException {
        block21: {
            FileEvent e;
            GnutellaFileModel filemodel;
            BufferedWriter bw;
            BufferedInputStream bis;
            block20: {
                int bytesread;
                block19: {
                    HTTPResponseHeader response;
                    block18: {
                        block17: {
                            bis = null;
                            bw = null;
                            filemodel = (GnutellaFileModel)this.model;
                            bis = new BufferedInputStream(socket.getInputStream(), 8192);
                            bw = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
                            this.fireFileTransferStarting(new FileEvent(this, filemodel, 3), new FileEvent(this, filemodel, 7));
                            this.logTransferStarting();
                            HTTPRequestHeader request = new HTTPRequestHeader();
                            request.setRequest("/get/" + filemodel.getFileIndex() + "/" + filemodel.getFilename());
                            request.setHeader("User-Agent", this.getContext().getSupportedFeatureHeaders().getHeader("User-Agent"));
                            request.setHeader("Connection", "Keep-Alive");
                            request.setHeader("Range", "bytes=" + filemodel.getCurrentFilesize() + "-");
                            bw.write(request.toString());
                            bw.flush();
                            if (!this.shutdown) break block17;
                            FileEvent e22 = new FileEvent(this, filemodel, 6);
                            this.fireFileTransferFinished(e22);
                            this.logTransferFinished(e22);
                            IOUtil.closeStream(bis);
                            IOUtil.closeStream(bw);
                            return;
                        }
                        response = new HTTPResponseHeader();
                        response.parse(bis);
                        this.setResponseHeaders(response);
                        if (response.getStatusCode() == 200) break block18;
                        FileEvent e32 = response.getStatusCode() == 503 ? new FileEvent(this, filemodel, 5, "Busy") : (response.getStatusCode() == 403 ? new FileEvent(this, filemodel, 5, "Forbidden") : (response.getStatusMessage() != null ? new FileEvent(this, filemodel, 5, response.getStatusMessage()) : new FileEvent(this, filemodel, 5, "Status " + response.getStatusCode())));
                        this.fireFileTransferFinished(e32);
                        this.logTransferFinished(e32);
                        IOUtil.closeStream(bis);
                        IOUtil.closeStream(bw);
                        return;
                    }
                    boolean contentHeaderFound = false;
                    String contentLength = response.getHeader("Content-Length");
                    String contentRange = response.getHeader("Content-Range");
                    if (contentLength == null) {
                        contentLength = response.getHeader("Content-length");
                    }
                    if (contentRange == null) {
                        contentRange = response.getHeader("Content-range");
                    }
                    if (contentLength != null) {
                        filemodel.setFilesize(Integer.parseInt(contentLength));
                        contentHeaderFound = true;
                    } else if (contentRange != null && this.httpContentRangeHeaderRE.match("m#^bytes=(\\d+)-(\\d+)/(\\d+)#i", contentRange)) {
                        filemodel.setFilesize(Integer.parseInt(this.httpContentRangeHeaderRE.group(3)));
                        contentHeaderFound = true;
                    }
                    if (contentHeaderFound) break block19;
                    FileEvent e4 = new FileEvent(this, filemodel, 5, "Invalid Response: No Content Length/Range Header Found!");
                    this.fireFileTransferFinished(e4);
                    this.logTransferFinished(e4);
                    IOUtil.closeStream(bis);
                    IOUtil.closeStream(bw);
                    return;
                }
                this.fireFileInfoChanged(new FileEvent(this, filemodel, 2));
                RandomAccessFile fileout = new RandomAccessFile(filemodel.getSaveLocation(), "rw");
                fileout.seek(filemodel.getCurrentFilesize());
                filemodel.setStartTime(System.currentTimeMillis());
                byte[] bytebuf = new byte[8192];
                TransferRateThrottler throttler = filemodel.getThrottler();
                while ((bytesread = bis.read(bytebuf, 0, 8192)) != -1) {
                    fileout.write(bytebuf, 0, bytesread);
                    filemodel.incrementCurrentFilesize(bytesread);
                    this.fireFilesizeChanged(new FileEvent(this, filemodel, 1));
                    if (filemodel.getCurrentFilesize() >= filemodel.getFilesize() || this.shutdown) break;
                    if (throttler != null) {
                        throttler.throttle(filemodel);
                        continue;
                    }
                    Thread.currentThread();
                    Thread.yield();
                }
                fileout.close();
                filemodel.setEndTime(System.currentTimeMillis());
                if (!this.shutdown) break block20;
                FileEvent e5 = new FileEvent(this, filemodel, 6);
                this.fireFileTransferFinished(e5);
                this.logTransferFinished(e5);
                IOUtil.closeStream(bis);
                IOUtil.closeStream(bw);
                return;
            }
            try {
                FileEvent e6 = new FileEvent(this, filemodel, 4);
                this.fireFileTransferFinished(e6);
                this.logTransferFinished(e6);
            }
            catch (IOException ex) {
                e = new FileEvent(this, filemodel, 5, ex.getMessage());
                this.fireFileTransferFinished(e);
                this.logTransferFinished(e);
                IOUtil.closeStream(bis);
                IOUtil.closeStream(bw);
                break block21;
            }
            catch (TransferVetoException ex2) {
                e = new FileEvent(this, filemodel, 7, ex2.getMessage());
                this.fireFileTransferFinished(e);
                this.logTransferFinished(e);
                {
                    catch (Throwable throwable) {
                        IOUtil.closeStream(bis);
                        IOUtil.closeStream(bw);
                        throw throwable;
                    }
                }
                IOUtil.closeStream(bis);
                IOUtil.closeStream(bw);
            }
            IOUtil.closeStream(bis);
            IOUtil.closeStream(bw);
        }
    }

    public void start() {
        this.shutdown = false;
    }

    public void shutdown() {
        this.shutdown = true;
        Thread.currentThread().interrupt();
    }
}

