/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.gnutella.impl;

import com.echomine.gnutella.GnutellaConnection;
import com.echomine.gnutella.GnutellaConnectionEvent;
import com.echomine.gnutella.GnutellaConnectionManager;
import com.echomine.gnutella.GnutellaConnectionStatisticsListener;
import com.echomine.gnutella.GnutellaStatistics;
import com.echomine.gnutella.GnutellaStatisticsListener;
import com.echomine.net.ConnectionEvent;
import com.echomine.net.ConnectionListener;
import com.echomine.net.ConnectionModel;
import com.echomine.net.ConnectionVetoException;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.event.EventListenerList;

public class GnutellaStatisticsImpl
implements GnutellaStatistics {
    EventListenerList listenerList = new EventListenerList();
    long totalMessages;
    long totalFiles;
    long totalSize;
    int totalHosts;
    GnutellaConnectionManager cmanager;
    HashMap connStats;
    static /* synthetic */ Class class$com$echomine$gnutella$GnutellaStatisticsListener;

    public GnutellaStatisticsImpl(GnutellaConnectionManager cman) {
        this.cmanager = cman;
        this.connStats = new HashMap();
        this.cmanager.addConnectionListener(new StatsConnectionListener());
    }

    public long getTotalMessages() {
        return this.totalMessages;
    }

    public long getTotalFiles() {
        return this.totalFiles;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public int getTotalHosts() {
        return this.totalHosts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetHostStats() {
        this.totalHosts = 0;
        this.totalSize = 0L;
        this.totalFiles = 0L;
        HashMap hashMap = this.connStats;
        synchronized (hashMap) {
            Iterator iter = this.connStats.values().iterator();
            while (iter.hasNext()) {
                GnutellaConnection conn = (GnutellaConnection)iter.next();
                conn.resetStats();
            }
        }
    }

    public void resetTotalMessages() {
        this.totalMessages = 0L;
        this.fireGlobalStatsUpdated();
    }

    public int getEstablishedConnectionsCount() {
        return this.connStats.size();
    }

    public GnutellaConnection getConnection(ConnectionModel model) {
        return (GnutellaConnection)this.connStats.get(model.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getConnections() {
        HashMap statsClone = null;
        HashMap hashMap = this.connStats;
        synchronized (hashMap) {
            statsClone = (HashMap)this.connStats.clone();
        }
        return statsClone.values().iterator();
    }

    public void addStatisticsListener(GnutellaStatisticsListener l) {
        this.listenerList.add(class$com$echomine$gnutella$GnutellaStatisticsListener == null ? (class$com$echomine$gnutella$GnutellaStatisticsListener = GnutellaStatisticsImpl.class$("com.echomine.gnutella.GnutellaStatisticsListener")) : class$com$echomine$gnutella$GnutellaStatisticsListener, l);
    }

    public void removeStatisticsListener(GnutellaStatisticsListener l) {
        this.listenerList.remove(class$com$echomine$gnutella$GnutellaStatisticsListener == null ? (class$com$echomine$gnutella$GnutellaStatisticsListener = GnutellaStatisticsImpl.class$("com.echomine.gnutella.GnutellaStatisticsListener")) : class$com$echomine$gnutella$GnutellaStatisticsListener, l);
    }

    protected void fireGlobalStatsUpdated() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$com$echomine$gnutella$GnutellaStatisticsListener == null ? GnutellaStatisticsImpl.class$("com.echomine.gnutella.GnutellaStatisticsListener") : class$com$echomine$gnutella$GnutellaStatisticsListener)) continue;
            ((GnutellaStatisticsListener)listeners[i + 1]).globalStatsUpdated(this);
        }
    }

    protected void fireConnectionStatsUpdated(GnutellaConnection conn) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$com$echomine$gnutella$GnutellaStatisticsListener == null ? GnutellaStatisticsImpl.class$("com.echomine.gnutella.GnutellaStatisticsListener") : class$com$echomine$gnutella$GnutellaStatisticsListener)) continue;
            ((GnutellaStatisticsListener)listeners[i + 1]).connectionStatsUpdated(conn);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class StatsConnectionListener
    implements ConnectionListener {
        GnutellaConnectionStatisticsListener cStatListener;

        StatsConnectionListener() {
        }

        public void connectionStarting(ConnectionEvent event) throws ConnectionVetoException {
            this.cStatListener = new GnutellaConnectionStatisticsListener(this){
                private final /* synthetic */ StatsConnectionListener this$1;
                {
                    this.this$1 = this$1;
                }

                public void connectionStatsUpdated(GnutellaConnection conn) {
                    StatsConnectionListener.access$000(this.this$1).fireConnectionStatsUpdated(conn);
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connectionEstablished(ConnectionEvent event) {
            GnutellaConnection conn = ((GnutellaConnectionEvent)event).getConnection();
            ConnectionModel model = event.getConnectionModel();
            HashMap hashMap = GnutellaStatisticsImpl.this.connStats;
            synchronized (hashMap) {
                if (!GnutellaStatisticsImpl.this.connStats.containsKey(model.toString())) {
                    GnutellaStatisticsImpl.this.connStats.put(model.toString(), conn);
                    conn.addStatisticsListener(this.cStatListener);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connectionClosed(ConnectionEvent event) {
            ConnectionModel model = event.getConnectionModel();
            GnutellaConnection conn = null;
            HashMap hashMap = GnutellaStatisticsImpl.this.connStats;
            synchronized (hashMap) {
                conn = (GnutellaConnection)GnutellaStatisticsImpl.this.connStats.get(model.toString());
                if (conn != null) {
                    conn.removeStatisticsListener(this.cStatListener);
                    GnutellaStatisticsImpl.this.connStats.remove(model.toString());
                    StatsConnectionListener statsConnectionListener = this;
                    synchronized (statsConnectionListener) {
                        GnutellaStatisticsImpl.this.totalFiles -= conn.getFiles();
                        GnutellaStatisticsImpl.this.totalSize -= conn.getSize();
                        GnutellaStatisticsImpl.this.totalHosts -= conn.getHosts();
                    }
                }
            }
            if (conn != null) {
                GnutellaStatisticsImpl.this.fireGlobalStatsUpdated();
            }
        }

        static /* synthetic */ GnutellaStatisticsImpl access$000(StatsConnectionListener x0) {
            return x0.GnutellaStatisticsImpl.this;
        }
    }
}

