/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber;

import com.echomine.common.ParseException;
import com.echomine.jabber.JabberCode;
import com.echomine.jabber.JabberMessage;
import com.echomine.jabber.JabberMessageParsable;
import com.echomine.jabber.JabberMessageParser;
import com.echomine.jabber.MessageNotSupportedException;
import java.util.HashMap;
import org.jdom.Element;
import org.jdom.Namespace;

public class DefaultMessageParser
implements JabberMessageParser {
    private HashMap msgParsers = new HashMap();
    private HashMap msgClasses = new HashMap();

    public DefaultMessageParser() {
        try {
            this.setParser("presence", JabberCode.XMLNS_PRESENCE, "com.echomine.jabber.JabberPresenceMessage");
            this.setParser("message", JabberCode.XMLNS_CHAT, "com.echomine.jabber.JabberChatMessage");
            this.setParser("iq", JabberCode.XMLNS_IQ, "com.echomine.jabber.JabberIQMessageParser");
            this.setParser("query", JabberCode.XMLNS_IQ_AUTH, "com.echomine.jabber.msg.AuthIQMessage");
            this.setParser("query", JabberCode.XMLNS_IQ_ROSTER, "com.echomine.jabber.msg.RosterIQMessage");
            this.setParser("query", JabberCode.XMLNS_IQ_REGISTER, "com.echomine.jabber.msg.RegisterIQMessage");
            this.setParser("query", JabberCode.XMLNS_IQ_XMLRPC, "com.echomine.jabber.msg.XMLRPCMessage");
            this.setParser("query", JabberCode.XMLNS_IQ_TIME, "com.echomine.jabber.msg.TimeIQMessage");
            this.setParser("query", JabberCode.XMLNS_IQ_VERSION, "com.echomine.jabber.msg.VersionIQMessage");
            this.setParser("query", JabberCode.XMLNS_IQ_LAST, "com.echomine.jabber.msg.LastIQMessage");
            this.setParser("query", JabberCode.XMLNS_IQ_GATEWAY, "com.echomine.jabber.msg.GatewayIQMessage");
            this.setParser("query", JabberCode.XMLNS_IQ_AGENTS, "com.echomine.jabber.msg.AgentsIQMessage");
            this.setParser("query", JabberCode.XMLNS_IQ_PRIVATE, "com.echomine.jabber.msg.PrivateXmlIQMessage");
            this.setParser("query", JabberCode.XMLNS_IQ_SEARCH, "com.echomine.jabber.msg.SearchIQMessage");
            this.setParser("query", JabberCode.XMLNS_IQ_OOB, "com.echomine.jabber.msg.OOBIQMessage");
            this.setParser("query", JabberCode.XMLNS_IQ_VACATION, "com.echomine.jabber.msg.VacationIQMessage");
            this.setParser("query", JabberCode.XMLNS_IQ_DISCO_INFO, "com.echomine.jabber.msg.ServiceInfoIQMessage");
            this.setParser("query", JabberCode.XMLNS_IQ_DISCO_ITEMS, "com.echomine.jabber.msg.ServiceItemsIQMessage");
            this.setParser("vCard", JabberCode.XMLNS_IQ_VCARD, "com.echomine.jabber.msg.JabberVCardMessage");
            this.setParser("service", JabberCode.XMLNS_IQ, "com.echomine.jabber.msg.BrowseIQMessage");
            this.setParser("service", JabberCode.XMLNS_IQ_BROWSE, "com.echomine.jabber.msg.BrowseIQMessage");
            this.setParser("conference", JabberCode.XMLNS_IQ_BROWSE, "com.echomine.jabber.msg.BrowseIQMessage");
            this.setParser("user", JabberCode.XMLNS_IQ_BROWSE, "com.echomine.jabber.msg.BrowseIQMessage");
            this.setParser("application", JabberCode.XMLNS_IQ_BROWSE, "com.echomine.jabber.msg.BrowseIQMessage");
            this.setParser("headline", JabberCode.XMLNS_IQ_BROWSE, "com.echomine.jabber.msg.BrowseIQMessage");
            this.setParser("render", JabberCode.XMLNS_IQ_BROWSE, "com.echomine.jabber.msg.BrowseIQMessage");
            this.setParser("keyword", JabberCode.XMLNS_IQ_BROWSE, "com.echomine.jabber.msg.BrowseIQMessage");
            this.setParser("x", JabberCode.XMLNS_X_DELAY, "com.echomine.jabber.msg.DelayXMessage");
            this.setParser("x", JabberCode.XMLNS_X_ROSTER, "com.echomine.jabber.msg.RosterXMessage");
            this.setParser("x", JabberCode.XMLNS_X_EVENT, "com.echomine.jabber.msg.EventXMessage");
            this.setParser("x", JabberCode.XMLNS_X_EXPIRE, "com.echomine.jabber.msg.ExpireXMessage");
            this.setParser("x", JabberCode.XMLNS_X_PGP_ENCRYPTED, "com.echomine.jabber.msg.PGPEncryptedXMessage");
            this.setParser("x", JabberCode.XMLNS_X_DATA, "com.echomine.jabber.msg.DataXMessage");
            this.setParser("x", JabberCode.XMLNS_X_OOB, "com.echomine.jabber.msg.OOBXMessage");
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
    }

    public boolean supportsParsingFor(String qName, Namespace ns) {
        return this.msgParsers.containsKey(ns.getURI() + ":" + qName);
    }

    public void removeParser(String qName, Namespace ns) {
        Object clsName = this.msgParsers.remove(ns.getURI() + ":" + qName);
        this.msgClasses.remove(clsName);
    }

    public void setParser(String qName, Namespace ns, String msgClass) throws ParseException {
        try {
            Class<?> cls = Class.forName(msgClass);
            JabberMessageParsable parser = (JabberMessageParsable)cls.newInstance();
            this.msgClasses.put(msgClass, cls);
            this.msgParsers.put(ns.getURI() + ":" + qName, msgClass);
        }
        catch (ClassNotFoundException ex) {
            throw new ParseException("Parser class not found");
        }
        catch (ClassCastException ex) {
            throw new ParseException("Parser is not of type JabberMessageParsable");
        }
        catch (InstantiationException ex) {
            throw new ParseException("Parser cannot be initialized to check for validity: " + ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new ParseException("Illegal access while checking for validity: " + ex.getMessage());
        }
    }

    public JabberMessage createMessage(String qName, Namespace ns, Element msgTree) throws MessageNotSupportedException {
        String msgClassName = (String)this.msgParsers.get(ns.getURI() + ":" + qName);
        if (msgClassName == null) {
            throw new MessageNotSupportedException("Parser does not exist for the message");
        }
        JabberMessage msg = null;
        Class msgClass = (Class)this.msgClasses.get(msgClassName);
        if (msgClass != null) {
            try {
                JabberMessageParsable parser = (JabberMessageParsable)msgClass.newInstance();
                msg = parser.parse(this, msgTree);
            }
            catch (InstantiationException ex) {
                throw new MessageNotSupportedException("Error while instantiating message");
            }
            catch (IllegalAccessException ex) {
                throw new MessageNotSupportedException("Illegal access to message");
            }
            catch (ParseException ex) {
                throw new MessageNotSupportedException("Message cannot be properly parsed");
            }
        }
        if (msg == null) {
            throw new MessageNotSupportedException("Parser does not exist for the message");
        }
        return msg;
    }
}

