/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber;

import com.echomine.common.ParseException;
import com.echomine.jabber.JID;
import com.echomine.jabber.JabberCode;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.XMLOutputter;

public class JIDType {
    private static Pattern cattypePat;
    private static Log log;
    private String category;
    private String subtype;
    private JID jid;
    private String name;
    private ArrayList children;
    private ArrayList nsList;
    static /* synthetic */ Class class$com$echomine$jabber$JID;

    public JIDType(String type) throws ParseException {
        Perl5Matcher matcher = new Perl5Matcher();
        if (!matcher.matches(type, cattypePat)) {
            throw new ParseException("Unable to parse the category/subtype combination: " + type);
        }
        MatchResult result = matcher.getMatch();
        this.category = result.group(1);
        this.subtype = result.group(2);
    }

    public JIDType(String category, String subtype) {
        this.category = category;
        this.subtype = subtype;
    }

    public String getJIDType() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.category).append("/");
        if (this.subtype != null) {
            buf.append(this.subtype);
        }
        return buf.toString();
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public void setSubtype(String subtype) {
        this.subtype = subtype;
    }

    public JID getJID() {
        return this.jid;
    }

    public void setJID(JID jid) {
        this.jid = jid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addChild(JIDType child) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(child);
    }

    public void addNS(Namespace ns) {
        if (this.nsList == null) {
            this.nsList = new ArrayList();
        }
        this.nsList.add(ns);
    }

    public List getChildren() {
        return this.children;
    }

    public List getNSList() {
        return this.nsList;
    }

    public void parse(Element browse) throws ParseException {
        if (this.children == null) {
            this.children = new ArrayList();
        } else {
            this.children.clear();
        }
        if (this.nsList == null) {
            this.children = new ArrayList();
        } else {
            this.nsList.clear();
        }
        this.name = null;
        this.jid = null;
        this.setName(browse.getAttributeValue("name"));
        this.setJID(new JID(browse.getAttributeValue("jid")));
        List bchildren = browse.getChildren();
        int size = bchildren.size();
        for (int i = 0; i < size; ++i) {
            Element child = (Element)bchildren.get(i);
            if (child.getName().equals("ns")) {
                this.addNS(Namespace.getNamespace((String)child.getText()));
                continue;
            }
            JIDType subChild = new JIDType(child.getName(), child.getAttributeValue("type"));
            subChild.parse(child);
            this.addChild(subChild);
        }
    }

    public Element getDOM() throws ParseException {
        int size;
        if (this.category == null) {
            throw new ParseException("JIDType category must be set");
        }
        if (this.jid == null) {
            throw new ParseException("JIDType JID must be set");
        }
        Element browse = new Element(this.category, JabberCode.XMLNS_IQ_BROWSE);
        if (this.jid != null) {
            browse.setAttribute("jid", this.jid.toString());
        }
        if (this.subtype != null) {
            browse.setAttribute("type", this.subtype);
        }
        if (this.name != null) {
            browse.setAttribute("name", this.name);
        }
        if (this.nsList != null) {
            size = this.nsList.size();
            for (int i = 0; i < size; ++i) {
                Namespace ns = (Namespace)this.nsList.get(i);
                Element elem = new Element("ns", JabberCode.XMLNS_IQ_BROWSE);
                elem.setText(ns.getURI());
                browse.addContent(elem);
            }
        }
        if (this.children != null) {
            size = this.children.size();
            for (int i = 0; i < size; ++i) {
                JIDType jidtype = (JIDType)this.children.get(i);
                browse.addContent(jidtype.getDOM());
            }
        }
        return browse;
    }

    public String toString() {
        XMLOutputter os = new XMLOutputter();
        String temp = "";
        try {
            temp = os.outputString(this.getDOM());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return temp;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        block2: {
            log = LogFactory.getLog((Class)(class$com$echomine$jabber$JID == null ? (class$com$echomine$jabber$JID = JIDType.class$("com.echomine.jabber.JID")) : class$com$echomine$jabber$JID));
            Perl5Compiler compiler = new Perl5Compiler();
            try {
                cattypePat = compiler.compile("(\\S+)/(\\S+)");
            }
            catch (MalformedPatternException ex) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)"JID Regular Expression did not compile properly", (Throwable)ex);
            }
        }
    }
}

