/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber;

import com.echomine.common.SendMessageFailedException;
import com.echomine.jabber.JID;
import com.echomine.jabber.JabberChatMessage;
import com.echomine.jabber.JabberPresenceMessage;
import com.echomine.jabber.JabberSession;

public class JabberChatService {
    private JabberSession session;

    public JabberChatService(JabberSession session) {
        this.session = session;
    }

    public void sendPrivateMessage(JID toJID, String body, boolean wait) throws SendMessageFailedException {
        JabberChatMessage msg = new JabberChatMessage("chat");
        msg.setTo(toJID);
        msg.setBody(body);
        msg.setSynchronized(wait);
        this.session.sendMessage(msg);
    }

    public void replyToPrivateMessage(JID toJID, String threadID, String body, boolean wait) throws SendMessageFailedException {
        JabberChatMessage msg = new JabberChatMessage("chat");
        msg.setTo(toJID);
        msg.setBody(body);
        msg.setThreadID(threadID);
        msg.setSynchronized(wait);
        this.session.sendMessage(msg);
    }

    public void joinChatRoom(JID roomJID, String nick, boolean wait) throws SendMessageFailedException {
        JabberPresenceMessage msg = new JabberPresenceMessage();
        JID roomnickJID = new JID(roomJID.getNode(), roomJID.getHost(), nick);
        msg.setTo(roomnickJID);
        msg.setSynchronized(wait);
        this.session.sendMessage(msg);
    }

    public void leaveChatRoom(JID roomJID, boolean wait) throws SendMessageFailedException {
        JabberPresenceMessage msg = new JabberPresenceMessage("unavailable");
        msg.setTo(roomJID);
        msg.setSynchronized(wait);
        this.session.sendMessage(msg);
    }

    public void sendChatMessage(JID roomJID, String body, boolean wait) throws SendMessageFailedException {
        JabberChatMessage msg = new JabberChatMessage("groupchat");
        msg.setTo(roomJID);
        msg.setBody(body);
        msg.setSynchronized(wait);
        this.session.sendMessage(msg);
    }

    public void setChatAvailable(JID roomJID, String showState, String status, boolean wait) throws SendMessageFailedException {
        JabberPresenceMessage msg = new JabberPresenceMessage("available");
        msg.setTo(roomJID);
        msg.setSynchronized(wait);
        if (showState != null) {
            msg.setShowState(showState);
        }
        if (status != null) {
            msg.setStatus(status);
        } else {
            msg.setStatus("Online");
        }
        this.session.sendMessage(msg);
    }
}

