/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber;

import com.echomine.common.SendMessageFailedException;
import com.echomine.jabber.JDOMXMessageHandler;
import com.echomine.jabber.JabberContentHandler;
import com.echomine.jabber.JabberContext;
import com.echomine.jabber.JabberMessage;
import com.echomine.jabber.JabberMessageEvent;
import com.echomine.jabber.JabberMessageListener;
import com.echomine.jabber.JabberMessageReceiver;
import com.echomine.jabber.JabberProtocol;
import com.echomine.jabber.JabberSession;
import com.echomine.jabber.MessageRequestQueue;
import com.echomine.jabber.MsgSessionInit;
import com.echomine.net.ConnectionEvent;
import com.echomine.net.ConnectionFailedException;
import com.echomine.net.ConnectionListener;
import com.echomine.net.ConnectionModel;
import com.echomine.net.ConnectionVetoException;
import com.echomine.net.SocketConnector;
import com.echomine.net.TimeableConnection;
import com.echomine.util.Semaphore;

public class JabberConnection
extends TimeableConnection
implements JabberMessageListener {
    private boolean connected;
    private SocketConnector connector;
    private JabberProtocol handler;
    private ConnectionModel cmodel;
    private Semaphore sem;
    private JabberMessageReceiver receiver;
    private JabberContext context;
    private MessageRequestQueue queue = new MessageRequestQueue();
    static /* synthetic */ Class class$com$echomine$net$ConnectionListener;

    public JabberConnection(JabberSession session, JabberMessageReceiver receiver) {
        this.context = session.getContext();
        JabberContentHandler contentHandler = new JabberContentHandler(session, receiver, this.queue, new JDOMXMessageHandler(session.getMessageParser()));
        this.handler = new JabberProtocol(contentHandler, this.queue);
        this.connector = new SocketConnector(this.handler);
        this.receiver = receiver;
        this.sem = new Semaphore(0L);
        this.connector.addConnectionListener(new JabberConnectionListener());
        this.addMessageListener(this);
    }

    public void disconnect() {
        this.handler.shutdown();
    }

    public synchronized void connect(ConnectionModel cmodel) throws ConnectionFailedException {
        if (this.connected) {
            return;
        }
        this.cmodel = cmodel;
        this.queue.start();
        this.cmodel.setSSL(this.context.isSSL());
        this.connector.aconnect(cmodel);
        try {
            this.sem.acquire();
            if (!this.connected) {
                throw new ConnectionFailedException("Connection Failed");
            }
        }
        catch (InterruptedException ex) {
            this.disconnect();
            throw new ConnectionFailedException("Timeout during connection");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(JabberMessage msg) throws SendMessageFailedException {
        if (!this.connected) {
            throw new SendMessageFailedException("Send Failure: not connected to server");
        }
        try {
            JabberMessage jabberMessage = msg;
            synchronized (jabberMessage) {
                this.handler.send(msg);
                if (this.context.getSessionID() != null && msg.getMessageType() == 1) {
                    return;
                }
                if (msg.isSynchronized()) {
                    msg.wait(msg.getTimeout());
                }
            }
        }
        catch (InterruptedException ex) {
            throw new SendMessageFailedException("Send Failure: interrupted while waiting for reply");
        }
    }

    public void sendLater(Runnable sendThread) {
        Thread thread = new Thread(sendThread, "Send Message Thread");
        thread.start();
    }

    public void addConnectionListener(ConnectionListener l) {
        this.listenerList.add(class$com$echomine$net$ConnectionListener == null ? (class$com$echomine$net$ConnectionListener = JabberConnection.class$("com.echomine.net.ConnectionListener")) : class$com$echomine$net$ConnectionListener, l);
    }

    public void removeConnectionListener(ConnectionListener l) {
        this.listenerList.remove(class$com$echomine$net$ConnectionListener == null ? (class$com$echomine$net$ConnectionListener = JabberConnection.class$("com.echomine.net.ConnectionListener")) : class$com$echomine$net$ConnectionListener, l);
    }

    public ConnectionModel getConnectionModel() {
        return this.cmodel;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void addMessageListener(JabberMessageListener l) {
        this.receiver.addMessageListener(l);
    }

    public void removeMessageListener(JabberMessageListener l) {
        this.receiver.removeMessageListener(l);
    }

    public void messageReceived(JabberMessageEvent event) {
        if (event.getMessageType() == 1) {
            MsgSessionInit msg = (MsgSessionInit)event.getMessage();
            if (this.context.getSessionID() == null) {
                this.context.setSessionID(msg.getSessionID());
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class JabberConnectionListener
    implements ConnectionListener {
        JabberConnectionListener() {
        }

        public void connectionStarting(ConnectionEvent e) throws ConnectionVetoException {
            JabberConnection.this.fireConnectionStartingWithoutVeto(e);
        }

        public void connectionEstablished(ConnectionEvent e) {
            JabberConnection.this.connected = true;
            Runnable run = new Runnable(this){
                private final /* synthetic */ JabberConnectionListener this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    MsgSessionInit init = new MsgSessionInit(JabberConnection.access$300(JabberConnectionListener.access$200(this.this$1)).getServerName());
                    try {
                        JabberConnectionListener.access$200(this.this$1).send(init);
                        if (init.getReplyMessage() instanceof MsgSessionInit) {
                            JabberConnection.access$300(JabberConnectionListener.access$200(this.this$1)).setSessionID(((MsgSessionInit)init.getReplyMessage()).getSessionID());
                        }
                        JabberConnection.access$400(JabberConnectionListener.access$200(this.this$1)).release();
                    }
                    catch (SendMessageFailedException sendMessageFailedException) {
                        // empty catch block
                    }
                }
            };
            JabberConnection.this.sendLater(run);
            JabberConnection.this.fireConnectionEstablished(e);
        }

        public void connectionClosed(ConnectionEvent e) {
            if (!JabberConnection.this.connected) {
                JabberConnection.this.sem.release();
            }
            JabberConnection.this.connected = false;
            JabberConnection.this.context.setSessionID(null);
            JabberConnection.this.fireConnectionClosed(e);
        }

        static /* synthetic */ JabberConnection access$200(JabberConnectionListener x0) {
            return x0.JabberConnection.this;
        }
    }
}

