/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber;

import com.echomine.jabber.JabberMessage;
import com.echomine.jabber.JabberMessageHandler;
import com.echomine.jabber.JabberMessageReceiver;
import com.echomine.jabber.JabberSession;
import com.echomine.jabber.MessageRequestQueue;
import com.echomine.jabber.MsgSessionInit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class JabberContentHandler
extends DefaultHandler {
    private static Log inlogger = LogFactory.getLog((String)"jabber/msg/incoming");
    private JabberSession session;
    private JabberMessageReceiver receiver;
    private JabberMessageHandler msgHandler;
    private MessageRequestQueue queue;
    private boolean delegated;
    private String msgLocalName;

    public JabberContentHandler(JabberSession session, JabberMessageReceiver receiver, MessageRequestQueue queue, JabberMessageHandler msgHandler) {
        this.queue = queue;
        this.receiver = receiver;
        this.session = session;
        this.msgHandler = msgHandler;
    }

    public void startDocument() {
        this.delegated = false;
        this.msgLocalName = null;
    }

    public void endDocument() {
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attr) {
        if (localName.equals("stream")) {
            String id = attr.getValue("id");
            String from = attr.getValue("from");
            String version = attr.getValue("version");
            if (id == null || from == null) {
                this.session.disconnect();
                return;
            }
            MsgSessionInit initmsg = new MsgSessionInit(from, id, version);
            JabberMessage sentMsg = this.queue.getMessageForReply(initmsg.getMessageID());
            if (sentMsg != null) {
                sentMsg.replyReceived(initmsg);
            }
            if (inlogger.isDebugEnabled()) {
                inlogger.debug((Object)initmsg);
            }
            this.receiver.receive(initmsg);
            return;
        }
        if (!this.delegated) {
            this.delegated = true;
            this.msgLocalName = localName;
            this.msgHandler.startMessage();
        }
        if (this.delegated) {
            this.msgHandler.startElement(namespaceURI, localName, qName, attr);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        if (localName.equals("stream")) {
            this.session.disconnect();
            return;
        }
        if (this.delegated) {
            this.msgHandler.endElement(namespaceURI, localName, qName);
        }
        if (localName.equals(this.msgLocalName)) {
            this.msgHandler.endMessage();
            JabberMessage msg = this.msgHandler.getMessage();
            JabberMessage sentMsg = this.queue.getMessageForReply(msg.getMessageID());
            if (sentMsg != null) {
                msg = sentMsg.replyReceived(msg);
            }
            if (inlogger.isDebugEnabled()) {
                inlogger.debug((Object)msg);
            }
            this.receiver.receive(msg);
            this.delegated = false;
            this.msgLocalName = null;
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.delegated) {
            this.msgHandler.characters(ch, start, length);
        }
    }
}

