/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber;

import com.echomine.common.ParseException;
import com.echomine.jabber.JabberMessage;
import com.echomine.jabber.JabberMessageParsable;
import com.echomine.jabber.JabberMessageParser;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class JabberJDOMMessage
extends JabberMessage
implements JabberMessageParsable {
    private Element msgTree;
    private XMLOutputter output;

    protected JabberJDOMMessage() {
    }

    public JabberJDOMMessage(Element rootElem) {
        this.msgTree = rootElem;
        String id = rootElem.getAttributeValue("id");
        if (id != null) {
            this.setMessageID(id);
        }
    }

    public JabberMessage parse(JabberMessageParser parser, Element msgTree) throws ParseException {
        this.msgTree = msgTree;
        String id = msgTree.getAttributeValue("id");
        if (id != null) {
            this.setMessageID(id);
        }
        return this;
    }

    public Element getDOM() {
        return this.msgTree;
    }

    public String encode() throws ParseException {
        StringWriter writer = new StringWriter(100);
        writer.write("<" + this.msgTree.getQualifiedName());
        if (!this.msgTree.getNamespaceURI().equals("")) {
            writer.write(" xmlns=\"" + this.msgTree.getNamespaceURI() + "\"");
        }
        Iterator<Object> iter = this.msgTree.getAttributes().iterator();
        while (iter.hasNext()) {
            Attribute attr = (Attribute)iter.next();
            writer.write(" " + attr.getQualifiedName() + "='" + attr.getValue() + "'");
        }
        writer.write(">");
        iter = this.msgTree.getChildren().iterator();
        XMLOutputter os = this.getXMLOutputter();
        while (iter.hasNext()) {
            Element elem = (Element)iter.next();
            try {
                os.output(elem, (Writer)writer);
            }
            catch (IOException ex) {}
        }
        if (this.isSendXMessages() && this.getXMessages() != null) {
            iter = this.getXMessages().values().iterator();
            while (iter.hasNext()) {
                JabberMessage msg = (JabberMessage)iter.next();
                writer.write(msg.encode());
            }
        }
        writer.write("</" + this.msgTree.getQualifiedName() + ">");
        return writer.toString();
    }

    public String toString() {
        try {
            return this.encode();
        }
        catch (ParseException ex) {
            return "Parse Exception: " + ex.toString();
        }
    }

    protected XMLOutputter getXMLOutputter() {
        if (this.output == null) {
            this.output = new XMLOutputter();
            this.output.setEncoding("UTF8");
        }
        return this.output;
    }

    public int getMessageType() {
        return 0;
    }
}

