/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber;

import com.echomine.common.SendMessageFailedException;
import com.echomine.jabber.JID;
import com.echomine.jabber.JabberPresenceMessage;
import com.echomine.jabber.JabberSession;

public class JabberPresenceService {
    private JabberSession session;

    public JabberPresenceService(JabberSession session) {
        this.session = session;
    }

    public void setToAvailable(String showState, String status, boolean wait) throws SendMessageFailedException {
        JabberPresenceMessage msg = new JabberPresenceMessage("available");
        if (showState != null) {
            msg.setShowState(showState);
        }
        if (status != null) {
            msg.setStatus(status);
        } else {
            msg.setStatus("Online");
        }
        msg.setSynchronized(wait);
        this.session.sendMessage(msg);
    }

    public void setToUnavailable() throws SendMessageFailedException {
        this.session.sendMessage(new JabberPresenceMessage("unavailable"));
    }

    public void subscribe(JID jid) throws SendMessageFailedException {
        JabberPresenceMessage msg = new JabberPresenceMessage("subscribe");
        msg.setTo(jid);
        this.session.sendMessage(msg);
    }

    public void unsubscribe(JID jid) throws SendMessageFailedException {
        JabberPresenceMessage msg = new JabberPresenceMessage("unsubscribe");
        msg.setTo(jid);
        this.session.sendMessage(msg);
    }

    public void sendSubscribed(JID jid) throws SendMessageFailedException {
        JabberPresenceMessage msg = new JabberPresenceMessage("subscribed");
        msg.setTo(jid);
        this.session.sendMessage(msg);
    }

    public void sendUnsubscribed(JID jid) throws SendMessageFailedException {
        JabberPresenceMessage msg = new JabberPresenceMessage("unsubscribed");
        msg.setTo(jid);
        this.session.sendMessage(msg);
    }

    public void acceptSubscribe(JabberPresenceMessage msg) throws SendMessageFailedException {
        JabberPresenceMessage reply = new JabberPresenceMessage("subscribed");
        reply.setTo(msg.getFrom());
        this.session.sendMessage(reply);
    }

    public void denySubscribe(JabberPresenceMessage msg) throws SendMessageFailedException {
        JabberPresenceMessage reply = new JabberPresenceMessage("unsubscribed");
        reply.setTo(msg.getFrom());
        this.session.sendMessage(reply);
    }
}

