/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber;

import com.echomine.common.SendMessageFailedException;
import com.echomine.jabber.DefaultMessageReceiver;
import com.echomine.jabber.JabberChatService;
import com.echomine.jabber.JabberClientService;
import com.echomine.jabber.JabberConnection;
import com.echomine.jabber.JabberContext;
import com.echomine.jabber.JabberMessage;
import com.echomine.jabber.JabberMessageListener;
import com.echomine.jabber.JabberMessageParser;
import com.echomine.jabber.JabberMessageReceiver;
import com.echomine.jabber.JabberPresenceService;
import com.echomine.jabber.JabberRosterService;
import com.echomine.jabber.JabberServerService;
import com.echomine.jabber.JabberUserService;
import com.echomine.net.ConnectionFailedException;
import com.echomine.net.ConnectionModel;
import java.net.UnknownHostException;

public class JabberSession {
    private JabberContext context;
    private JabberMessageReceiver receiver;
    private JabberConnection connection;
    private JabberMessageParser msgParser;
    private JabberUserService userService;
    private JabberPresenceService presenceService;
    private JabberRosterService rosterService;
    private JabberChatService chatService;
    private JabberServerService serverService;
    private JabberClientService clientService;

    public JabberSession(JabberContext context, JabberMessageParser parser) {
        this.context = context;
        this.receiver = new DefaultMessageReceiver(this);
        this.msgParser = parser;
    }

    public void connect(String hostname, int port) throws ConnectionFailedException, UnknownHostException {
        this.connect(new ConnectionModel(hostname, port));
    }

    public void connect(ConnectionModel cmodel) throws ConnectionFailedException {
        if (this.connection == null) {
            this.connection = new JabberConnection(this, this.receiver);
        }
        this.connection.connect(cmodel);
    }

    public void disconnect() {
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    public void sendMessage(JabberMessage msg) throws SendMessageFailedException {
        if (this.connection == null) {
            throw new SendMessageFailedException("Sending a message when connection not established");
        }
        this.connection.send(msg);
    }

    public void sendMessageLater(Runnable runnable) {
        if (this.connection == null) {
            throw new IllegalArgumentException("Connection is not initialized and established.");
        }
        this.connection.sendLater(runnable);
    }

    public JabberContext getContext() {
        return this.context;
    }

    public JabberConnection getConnection() {
        if (this.connection == null) {
            this.connection = new JabberConnection(this, this.receiver);
        }
        return this.connection;
    }

    public JabberMessageParser getMessageParser() {
        return this.msgParser;
    }

    public JabberRosterService getRosterService() {
        if (this.rosterService == null) {
            this.rosterService = new JabberRosterService(this);
        }
        return this.rosterService;
    }

    public JabberChatService getChatService() {
        if (this.chatService == null) {
            this.chatService = new JabberChatService(this);
        }
        return this.chatService;
    }

    public JabberPresenceService getPresenceService() {
        if (this.presenceService == null) {
            this.presenceService = new JabberPresenceService(this);
        }
        return this.presenceService;
    }

    public JabberUserService getUserService() {
        if (this.userService == null) {
            this.userService = new JabberUserService(this);
        }
        return this.userService;
    }

    public JabberServerService getServerService() {
        if (this.serverService == null) {
            this.serverService = new JabberServerService(this);
        }
        return this.serverService;
    }

    public JabberClientService getClientService() {
        if (this.clientService == null) {
            this.clientService = new JabberClientService(this);
        }
        return this.clientService;
    }

    public void addMessageListener(JabberMessageListener l) {
        this.connection.addMessageListener(l);
    }

    public void removeMessageListener(JabberMessageListener l) {
        this.connection.removeMessageListener(l);
    }
}

