/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber;

import com.echomine.common.SendMessageFailedException;
import com.echomine.jabber.JID;
import com.echomine.jabber.JabberContext;
import com.echomine.jabber.JabberMessageException;
import com.echomine.jabber.JabberSession;
import com.echomine.jabber.msg.AuthIQMessage;
import com.echomine.jabber.msg.GatewayIQMessage;
import com.echomine.jabber.msg.RegisterIQMessage;
import com.echomine.jabber.msg.VacationIQMessage;
import java.util.Calendar;
import java.util.HashMap;

public class JabberUserService {
    private JabberSession session;

    public JabberUserService(JabberSession session) {
        this.session = session;
    }

    public int login() throws JabberMessageException, SendMessageFailedException {
        JabberContext context = this.session.getContext();
        AuthIQMessage msg = AuthIQMessage.createGetAuthMethodsMessage(context);
        this.session.sendMessage(msg);
        if (msg.isError()) {
            throw new JabberMessageException(msg.getErrorMessage());
        }
        int authType = msg.getMostSecureAuth();
        String zerokToken = msg.getZerokToken();
        int zerokSeq = msg.getZerokSeq();
        msg = AuthIQMessage.createLoginMessage(context, authType, zerokToken, zerokSeq);
        this.session.sendMessage(msg);
        if (msg.isError()) {
            throw new JabberMessageException(msg.getErrorMessage());
        }
        if (zerokToken != null && zerokSeq <= 3) {
            this.changePassword(context.getPassword());
        }
        return authType;
    }

    public void register(JID serviceJID, HashMap fields) throws JabberMessageException, SendMessageFailedException {
        RegisterIQMessage msg = new RegisterIQMessage("set");
        msg.setTo(serviceJID);
        msg.setSynchronized(true);
        msg.addFields(fields);
        this.session.sendMessage(msg);
        if (msg.isError()) {
            throw new JabberMessageException(msg.getErrorMessage());
        }
    }

    public void changePassword(String newPassword) throws JabberMessageException, SendMessageFailedException {
        RegisterIQMessage msg = new RegisterIQMessage("set");
        JabberContext context = this.session.getContext();
        msg.setTo(context.getServerNameJID());
        msg.addField("username", context.getUsername());
        msg.addField("password", newPassword);
        msg.setSynchronized(true);
        this.session.sendMessage(msg);
        if (msg.isError()) {
            throw new JabberMessageException(msg.getErrorMessage());
        }
    }

    public HashMap getRegisterFields(JID serviceJID) throws JabberMessageException, SendMessageFailedException {
        RegisterIQMessage msg = new RegisterIQMessage("get");
        msg.setTo(serviceJID);
        msg.setSynchronized(true);
        this.session.sendMessage(msg);
        if (msg.isError()) {
            throw new JabberMessageException(msg.getErrorMessage());
        }
        return ((RegisterIQMessage)msg.getReplyMessage()).getFields();
    }

    public void removeRegisterService(JID serviceJID, String key) throws JabberMessageException, SendMessageFailedException {
        RegisterIQMessage msg = new RegisterIQMessage("set");
        msg.setTo(serviceJID);
        if (key != null) {
            msg.addField("key", key);
        }
        msg.addField("remove", null);
        msg.setSynchronized(true);
        this.session.sendMessage(msg);
        if (msg.isError()) {
            throw new JabberMessageException(msg.getErrorMessage());
        }
    }

    public String translateUserToJID(JID serviceJID, String user) throws JabberMessageException, SendMessageFailedException {
        GatewayIQMessage msg = new GatewayIQMessage("set");
        msg.setTo(serviceJID);
        msg.setSynchronized(true);
        msg.addField("prompt", user);
        this.session.sendMessage(msg);
        if (msg.isError()) {
            throw new JabberMessageException(msg.getErrorMessage());
        }
        GatewayIQMessage reply = (GatewayIQMessage)msg.getReplyMessage();
        return (String)reply.getFields().get("prompt");
    }

    public VacationIQMessage requestVacationMessage(boolean wait) throws SendMessageFailedException, JabberMessageException {
        VacationIQMessage msg = VacationIQMessage.createRequestVacationMessage();
        msg.setSynchronized(wait);
        this.session.sendMessage(msg);
        if (wait) {
            if (msg.isError()) {
                throw new JabberMessageException(msg.getErrorMessage());
            }
            VacationIQMessage reply = (VacationIQMessage)msg.getReplyMessage();
            return reply;
        }
        return null;
    }

    public void removeVacationMessage() throws SendMessageFailedException, JabberMessageException {
        VacationIQMessage msg = VacationIQMessage.createRequestVacationMessage();
        msg.setSynchronized(true);
        this.session.sendMessage(msg);
        if (msg.isError()) {
            throw new JabberMessageException(msg.getErrorMessage());
        }
    }

    public void setVacationMessage(Calendar startDate, Calendar endDate, String vacationMessage) throws SendMessageFailedException, JabberMessageException {
        VacationIQMessage msg = VacationIQMessage.createSetVacationMessage(startDate, endDate, vacationMessage);
        msg.setSynchronized(true);
        this.session.sendMessage(msg);
        if (msg.isError()) {
            throw new JabberMessageException(msg.getErrorMessage());
        }
    }
}

