/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber;

import com.echomine.common.ParseException;
import java.io.IOException;
import java.io.StringReader;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.xml.sax.InputSource;

public class JabberUtil {
    private static Pattern datePat;
    private static Pattern timePat;
    private static Pattern dateTimePat;
    private static final String DATE_PATTERN = "([0-9]{4})-([0-1][0-9])-([0-3][0-9])";
    private static final String TIME_PATTERN = "([0-2][0-9]):([0-5][0-9]):([0-5][0-9])(?:\\.[0-9]{3})?(?:(?:Z)|([+-][0-9]{2}:[0-9]{2}))?";
    private static final String DATETIME_PATTERN = "([0-9]{4})-([0-1][0-9])-([0-3][0-9])T([0-2][0-9]):([0-5][0-9]):([0-5][0-9])(?:\\.[0-9]{3})?(?:(?:Z)|([+-][0-9]{2}:[0-9]{2}))";

    private static void setup() throws MalformedPatternException {
        Perl5Compiler p5compiler = new Perl5Compiler();
        datePat = p5compiler.compile(DATE_PATTERN);
        timePat = p5compiler.compile(TIME_PATTERN);
        dateTimePat = p5compiler.compile(DATETIME_PATTERN);
    }

    public static Calendar parseDate(String date) throws ParseException {
        try {
            Perl5Matcher p5matcher;
            if (datePat == null) {
                JabberUtil.setup();
            }
            if ((p5matcher = new Perl5Matcher()).matches(date, datePat)) {
                Calendar cal = Calendar.getInstance();
                MatchResult result = p5matcher.getMatch();
                cal.set(1, Integer.parseInt(result.group(1)));
                cal.set(2, Integer.parseInt(result.group(2)) - 1);
                cal.set(5, Integer.parseInt(result.group(3)));
                return cal;
            }
            throw new ParseException("The date provided does not conform to the parsing patterns");
        }
        catch (MalformedPatternException ex) {
            throw new ParseException("The regular expression for parsing date is valid");
        }
    }

    public static Calendar parseTime(String time) throws ParseException {
        try {
            Perl5Matcher p5matcher;
            if (timePat == null) {
                JabberUtil.setup();
            }
            if ((p5matcher = new Perl5Matcher()).matches(time, timePat)) {
                Calendar cal = Calendar.getInstance();
                MatchResult result = p5matcher.getMatch();
                cal.set(11, Integer.parseInt(result.group(1)));
                cal.set(12, Integer.parseInt(result.group(2)));
                cal.set(13, Integer.parseInt(result.group(3)));
                cal.setTimeZone(JabberUtil.parseTimeZone(result.group(4)));
                return cal;
            }
            throw new ParseException("The time provided does not conform to the parsing patterns");
        }
        catch (MalformedPatternException ex) {
            throw new ParseException("The regular expression for parsing date is valid");
        }
    }

    public static Calendar parseDateTime(String dateTime) throws ParseException {
        try {
            Perl5Matcher p5matcher;
            if (dateTimePat == null) {
                JabberUtil.setup();
            }
            if ((p5matcher = new Perl5Matcher()).matches(dateTime, dateTimePat)) {
                Calendar cal = Calendar.getInstance();
                MatchResult result = p5matcher.getMatch();
                cal.set(1, Integer.parseInt(result.group(1)));
                cal.set(2, Integer.parseInt(result.group(2)) - 1);
                cal.set(5, Integer.parseInt(result.group(3)));
                cal.set(11, Integer.parseInt(result.group(4)));
                cal.set(12, Integer.parseInt(result.group(5)));
                cal.set(13, Integer.parseInt(result.group(6)));
                cal.setTimeZone(JabberUtil.parseTimeZone(result.group(7)));
                return cal;
            }
            throw new ParseException("The time provided does not conform to the parsing patterns");
        }
        catch (MalformedPatternException ex) {
            throw new ParseException("The regular expression for parsing date is valid");
        }
    }

    public static String formatDateTime(Calendar cal) {
        StringBuffer buf = new StringBuffer();
        buf.append(cal.get(1)).append("-");
        buf.append(cal.get(2) + 1).append("-");
        buf.append(cal.get(5)).append("T");
        buf.append(cal.get(11)).append(":");
        buf.append(cal.get(12)).append(":");
        buf.append(cal.get(13));
        String tz = cal.getTimeZone().getID();
        if ("GMT".equals(tz)) {
            buf.append("Z");
        } else {
            buf.append(tz.substring(3, tz.length()));
        }
        return buf.toString();
    }

    public static TimeZone parseTimeZone(String tz) {
        if (tz == null) {
            return TimeZone.getTimeZone("GMT");
        }
        return TimeZone.getTimeZone("GMT" + tz);
    }

    public static Element parseXmlStringToDOM(String xmlStr) throws IOException, JDOMException {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(new InputSource(new StringReader(xmlStr)));
        return doc.getRootElement().detach();
    }
}

