/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber;

import com.echomine.jabber.JabberSession;
import com.echomine.jabber.NullMessage;
import com.echomine.net.ConnectionEvent;
import com.echomine.net.ConnectionListener;
import com.echomine.net.ConnectionVetoException;

public class KeepAlive
extends Thread {
    private static final NullMessage NULLMSG = new NullMessage();
    private JabberSession session;
    private int timeout;
    private boolean running;

    public KeepAlive(JabberSession session, int timeout) {
        this(session, timeout, false);
    }

    public KeepAlive(JabberSession session, int timeout, boolean isDaemon) {
        if (session == null || timeout <= 0) {
            throw new IllegalArgumentException("session cannot be null and timeout must be > 0");
        }
        this.session = session;
        this.timeout = timeout;
        this.running = true;
        this.setName("Jabber KeepAlive Thread");
        this.setDaemon(isDaemon);
        session.getConnection().addConnectionListener(new KeepAliveConnectionListener());
        this.start();
    }

    public synchronized void shutdown() {
        this.running = false;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.running) {
            KeepAlive keepAlive;
            while (this.session.getConnection().isConnected()) {
                keepAlive = this;
                synchronized (keepAlive) {
                    try {
                        this.wait(this.timeout);
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    try {
                        this.session.sendMessage(NULLMSG);
                    }
                    catch (Exception e) {
                        this.session.disconnect();
                    }
                }
            }
            keepAlive = this;
            synchronized (keepAlive) {
                if (this.running && !this.session.getConnection().isConnected()) {
                    try {
                        this.wait(0L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    class KeepAliveConnectionListener
    implements ConnectionListener {
        KeepAliveConnectionListener() {
        }

        public void connectionClosed(ConnectionEvent e) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connectionEstablished(ConnectionEvent e) {
            KeepAlive keepAlive = KeepAlive.this;
            synchronized (keepAlive) {
                this.notify();
            }
        }

        public void connectionStarting(ConnectionEvent e) throws ConnectionVetoException {
        }
    }
}

