/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber;

import com.echomine.jabber.JabberMessage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class MessageRequestQueue {
    private LinkedList msgQueue = new LinkedList();
    private HashMap msgReplyTable = new HashMap(30);
    private boolean shutdown;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(JabberMessage msg) {
        if (!this.shutdown) {
            Cloneable cloneable;
            if (msg.isReplyRequired()) {
                cloneable = this.msgReplyTable;
                synchronized (cloneable) {
                    this.msgReplyTable.put(msg.getMessageID(), msg);
                }
            }
            cloneable = this.msgQueue;
            synchronized (cloneable) {
                this.msgQueue.addLast(msg);
                this.msgQueue.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JabberMessage waitForMessage() {
        JabberMessage msg;
        block7: {
            msg = null;
            try {
                if (this.shutdown) break block7;
                LinkedList linkedList = this.msgQueue;
                synchronized (linkedList) {
                    if (this.msgQueue.size() == 0 && !this.shutdown) {
                        this.msgQueue.wait();
                    }
                    if (this.msgQueue.size() > 0 && !this.shutdown) {
                        msg = (JabberMessage)this.msgQueue.removeFirst();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.shutdown = true;
        Cloneable cloneable = this.msgQueue;
        synchronized (cloneable) {
            this.msgQueue.notifyAll();
        }
        cloneable = this.msgReplyTable;
        synchronized (cloneable) {
            Iterator iter = this.msgReplyTable.values().iterator();
            while (iter.hasNext()) {
                JabberMessage msg = (JabberMessage)iter.next();
                msg.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JabberMessage getMessageForReply(String id) {
        JabberMessage msg = null;
        HashMap hashMap = this.msgReplyTable;
        synchronized (hashMap) {
            msg = (JabberMessage)this.msgReplyTable.remove(id);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Cloneable cloneable = this.msgQueue;
        synchronized (cloneable) {
            this.msgQueue.clear();
        }
        cloneable = this.msgReplyTable;
        synchronized (cloneable) {
            this.msgReplyTable.clear();
        }
    }

    public void start() {
        this.shutdown = false;
    }
}

