/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber.msg;

import com.echomine.jabber.JabberCode;
import com.echomine.jabber.JabberContext;
import com.echomine.jabber.JabberIQMessage;
import com.echomine.util.HexDec;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Iterator;
import org.jdom.Element;

public class AuthIQMessage
extends JabberIQMessage {
    public static final int AUTH_CLEARTEXT = 1;
    public static final int AUTH_DIGEST = 2;
    public static final int AUTH_ZERO_KNOWLEDGE = 3;
    private int mostSecureAuth = 0;
    private String mostSecurePassword = null;
    private String digest = null;
    private String hash = null;
    private String zerokToken;
    private int zerokSeq;

    public AuthIQMessage(String type) {
        super(type);
        this.setSynchronized(true);
        this.getDOM().addContent(new Element("query", JabberCode.XMLNS_IQ_AUTH));
    }

    public AuthIQMessage() {
        this("get");
    }

    public int getMostSecureAuth() {
        if (this.mostSecureAuth != 0) {
            return this.mostSecureAuth;
        }
        if (this.getReplyMessage() == null) {
            return 1;
        }
        AuthIQMessage reply = (AuthIQMessage)this.getReplyMessage();
        Element elem = reply.getDOM();
        HashMap<String, String> authMethods = new HashMap<String, String>();
        Iterator iter = elem.getChild("query", JabberCode.XMLNS_IQ_AUTH).getChildren().iterator();
        while (iter.hasNext()) {
            Element authMethod = (Element)iter.next();
            authMethods.put(authMethod.getName(), authMethod.getText());
        }
        this.mostSecureAuth = authMethods.containsKey("digest") ? 2 : 1;
        if (authMethods.containsKey("token") && authMethods.containsKey("sequence")) {
            String token = (String)authMethods.get("token");
            String sequence = (String)authMethods.get("sequence");
            if (token == null || sequence == null) {
                return this.mostSecureAuth;
            }
            try {
                this.zerokToken = token;
                this.zerokSeq = Integer.parseInt(sequence);
            }
            catch (NumberFormatException ex) {
                return this.mostSecureAuth;
            }
            if (this.zerokSeq <= 1) {
                return this.mostSecureAuth;
            }
            this.mostSecureAuth = 3;
        }
        return this.mostSecureAuth;
    }

    public String getPassword(JabberContext context, int authType) {
        if (this.mostSecurePassword != null) {
            return this.mostSecurePassword;
        }
        switch (authType) {
            case 3: {
                this.mostSecurePassword = this.getZeroKnowledgePassword(context, this.zerokToken, this.zerokSeq);
                break;
            }
            case 2: {
                this.mostSecurePassword = this.getDigestPassword(context);
                break;
            }
            default: {
                this.mostSecurePassword = this.getCleartextPassword(context);
            }
        }
        return this.mostSecurePassword;
    }

    protected String getCleartextPassword(JabberContext context) {
        return context.getPassword();
    }

    protected String getDigestPassword(JabberContext context) {
        if (this.digest != null) {
            return this.digest;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            md.update(context.getSessionID().getBytes());
            md.update(context.getPassword().getBytes());
            byte[] hash = md.digest();
            this.digest = HexDec.convertBytesToHexString(hash).toLowerCase();
        }
        catch (NoSuchAlgorithmException ex) {
            return "";
        }
        return this.digest;
    }

    protected String getZeroKnowledgePassword(JabberContext context, String zerokToken, int zerokSeq) {
        if (this.hash != null) {
            return this.hash;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            byte[] hashA = md.digest(context.getPassword().getBytes());
            md.reset();
            md.update(HexDec.convertBytesToHexString(hashA).toLowerCase().getBytes());
            md.update(zerokToken.getBytes());
            byte[] hash0 = md.digest();
            for (int i = 0; i < zerokSeq; ++i) {
                md.reset();
                hash0 = md.digest(HexDec.convertBytesToHexString(hash0).toLowerCase().getBytes());
            }
            this.hash = HexDec.convertBytesToHexString(hash0).toLowerCase();
        }
        catch (NoSuchAlgorithmException ex) {
            return "";
        }
        return this.hash;
    }

    public static AuthIQMessage createGetAuthMethodsMessage(JabberContext context) {
        AuthIQMessage authMsg = new AuthIQMessage("get");
        Element elem = authMsg.getDOM();
        Element query = elem.getChild("query", JabberCode.XMLNS_IQ_AUTH);
        Element username = new Element("username", JabberCode.XMLNS_IQ_AUTH);
        username.setText(context.getUsername());
        query.addContent(username);
        return authMsg;
    }

    public static AuthIQMessage createLoginMessage(JabberContext context, int authType, String zerokToken, int zerokSeq) {
        Element temp;
        AuthIQMessage msg = new AuthIQMessage("set");
        msg.setZerokToken(zerokToken);
        msg.setZerokSeq(zerokSeq);
        Element elem = msg.getDOM();
        Element query = elem.getChild("query", JabberCode.XMLNS_IQ_AUTH);
        if (context.getUsername() != null) {
            temp = new Element("username", JabberCode.XMLNS_IQ_AUTH);
            temp.setText(context.getUsername());
            query.addContent(temp);
        }
        if (context.getPassword() != null) {
            switch (authType) {
                case 2: {
                    temp = new Element("digest", JabberCode.XMLNS_IQ_AUTH);
                    break;
                }
                case 3: {
                    temp = new Element("hash", JabberCode.XMLNS_IQ_AUTH);
                    break;
                }
                default: {
                    temp = new Element("password", JabberCode.XMLNS_IQ_AUTH);
                }
            }
            String password = msg.getPassword(context, authType);
            if (password != null) {
                temp.setText(password);
            }
            query.addContent(temp);
        }
        temp = new Element("resource", JabberCode.XMLNS_IQ_AUTH);
        temp.setText(context.getResource());
        query.addContent(temp);
        return msg;
    }

    private void setZerokToken(String zerokToken) {
        this.zerokToken = zerokToken;
    }

    private void setZerokSeq(int zerokSeq) {
        this.zerokSeq = zerokSeq;
    }

    public String getZerokToken() {
        return this.zerokToken;
    }

    public int getZerokSeq() {
        return this.zerokSeq;
    }

    public int getMessageType() {
        return 13;
    }
}

